/*
 * Decompiled with CFR 0.152.
 */
package com.inverce.mod.events;

import android.support.annotation.NonNull;
import com.inverce.mod.core.collections.CacheFunctionMap;
import com.inverce.mod.core.reflection.Reflection;
import com.inverce.mod.events.Event;
import com.inverce.mod.events.annotation.Listener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Channel
extends HashMap<Class<? extends Listener>, Event<? extends Listener>> {
    protected static CacheFunctionMap<Class<?>, Set<Class<?>>> listenersInClass = new CacheFunctionMap(Channel::getListenersInClassImpl);
    private final boolean useWeekEvents;

    @NonNull
    public static Set<Class<?>> getListenersInClassImpl(Class<?> clazz) {
        Set allInterfaces = Reflection.getImplementedInterfaces(clazz);
        HashSet listeners = new HashSet();
        for (Class check : allInterfaces) {
            if (!Listener.class.isAssignableFrom(check) || check == Listener.class) continue;
            listeners.add(check);
        }
        return listeners;
    }

    public Channel() {
        this(true);
    }

    public Channel(boolean useWeekEvents) {
        this.useWeekEvents = useWeekEvents;
    }

    public <T extends Listener> void registerAll(@NonNull T listener) {
        for (Class clazz : (Set)listenersInClass.get(listener.getClass())) {
            this.eventInternal(clazz).addListenerInternal(listener);
        }
    }

    public <T extends Listener> void unregisterAll(@NonNull T listener) {
        for (Class clazz : (Set)listenersInClass.get(listener.getClass())) {
            this.eventInternal(clazz).removeListenerInternal(listener);
        }
    }

    public <T extends Listener> void register(Class<T> clazz, T listener) {
        this.event(clazz).addListener(listener);
    }

    public <T extends Listener> void registerSingle(Class<T> clazz, T listener) {
        this.event(clazz).setListener(listener);
    }

    public <T extends Listener> void unregister(Class<T> clazz, T listener) {
        this.event(clazz).removeListener(listener);
    }

    @NonNull
    public <T extends Listener> T post(Class<T> clazz) {
        return (T)this.event(clazz).post();
    }

    @NonNull
    public <T extends Listener> Event<T> event(Class<T> clazz) {
        Event<T> event = (Event<T>)super.get(clazz);
        if (event != null) {
            return event;
        }
        event = new Event<T>(clazz, this.useWeekEvents);
        this.put(clazz, event);
        return event;
    }

    @NonNull
    private Event<?> eventInternal(Class<?> clazz) {
        Event event = new Event(clazz, this.useWeekEvents);
        this.put(clazz, event);
        return event;
    }
}

