/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.oauth2.http;

import com.intuit.oauth2.exception.InvalidRequestException;
import com.intuit.oauth2.http.MethodType;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.http.NameValuePair;

public class Request {
    private final MethodType method;
    private final String url;
    private final List<NameValuePair> postParams;
    private final boolean requiresAuthentication;
    private final String authString;
    private final String postJson;

    private Request(RequestBuilder builder) {
        this.method = builder.method;
        this.url = builder.url;
        this.requiresAuthentication = builder.requiresAuthentication;
        this.authString = builder.authString;
        this.postParams = builder.postParams;
        this.postJson = builder.postJson;
    }

    public MethodType getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isRequiresAuthentication() {
        return this.requiresAuthentication;
    }

    public String getAuthString() {
        return this.authString;
    }

    public List<NameValuePair> getPostParams() {
        return this.postParams;
    }

    public String getPostJson() {
        return this.postJson;
    }

    public URL constructURL() throws InvalidRequestException {
        String stringUri = this.url;
        try {
            URI uri = new URI(stringUri);
            return uri.toURL();
        }
        catch (URISyntaxException e) {
            throw new InvalidRequestException("Bad URI: " + stringUri, e);
        }
        catch (MalformedURLException e) {
            throw new InvalidRequestException("Bad URL: " + stringUri, e);
        }
    }

    public static class RequestBuilder {
        private final MethodType method;
        private final String url;
        private List<NameValuePair> postParams;
        private boolean requiresAuthentication;
        private String authString;
        private String postJson;

        public RequestBuilder(MethodType method, String url) {
            this.method = method;
            this.url = url;
        }

        public RequestBuilder postParams(List<NameValuePair> postParams) {
            this.postParams = postParams;
            return this;
        }

        public RequestBuilder requiresAuthentication(boolean requiresAuthentication) {
            this.requiresAuthentication = requiresAuthentication;
            return this;
        }

        public RequestBuilder authString(String authString) {
            this.authString = authString;
            return this;
        }

        public RequestBuilder postJson(String postJson) {
            this.postJson = postJson;
            return this;
        }

        public Request build() {
            return new Request(this);
        }
    }
}

