/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.oauth2.http;

import com.intuit.oauth2.exception.ConnectionException;
import com.intuit.oauth2.utils.LoggerImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;

public class Response {
    private final InputStream stream;
    private final int statusCode;
    private String content;
    private static final Logger logger = LoggerImpl.getInstance();

    public Response(InputStream stream, int statusCode) {
        this.stream = stream;
        this.statusCode = statusCode;
    }

    public String getContent() throws ConnectionException {
        logger.debug("Enter Response::getContent");
        if (this.content != null) {
            logger.debug("content already available ");
            return this.content;
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(this.stream));
        StringBuffer result = new StringBuffer();
        String line = "";
        try {
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException e) {
            logger.error("Exception while retrieving content", (Throwable)e);
            throw new ConnectionException(e.getMessage());
        }
        this.content = result.toString();
        logger.debug("End Response::getContent");
        return this.content;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public InputStream getStream() {
        return this.stream;
    }
}

