/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.query;

import com.intuit.ipp.query.Path;
import com.intuit.ipp.query.QueryMessage;
import com.intuit.ipp.query.expr.Expression;
import org.slf4j.Logger;

public class OptionalSyntax {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private QueryMessage message = null;

    public OptionalSyntax(QueryMessage mess) {
        this.message = mess;
    }

    public OptionalSyntax where(Expression<?> ... expression) {
        for (Expression<?> exp : expression) {
            this.getMessage().getOptional().add(exp.toString());
            LOG.debug("expression: " + exp);
        }
        QueryMessage mess = this.getMessage();
        return new OptionalSyntax(mess);
    }

    public OptionalSyntax orderBy(Path<?> ... path) {
        String fieldList = "";
        boolean firstExpression = true;
        for (Path<?> exp : path) {
            if (firstExpression) {
                fieldList = fieldList.concat(exp.toString());
                firstExpression = false;
            } else {
                fieldList = fieldList.concat(", ").concat(exp.toString());
            }
            LOG.debug("expression: " + exp);
        }
        QueryMessage mess = this.getMessage();
        mess.setOrderByClause(fieldList);
        return new OptionalSyntax(mess);
    }

    public OptionalSyntax orderByAscending(Path<?> ... path) {
        String fieldList = "";
        boolean firstExpression = true;
        for (Path<?> exp : path) {
            if (firstExpression) {
                fieldList = fieldList.concat(exp.toString());
                firstExpression = false;
            } else {
                fieldList = fieldList.concat(", ").concat(exp.toString());
            }
            LOG.debug("expression: " + exp);
        }
        fieldList = fieldList.concat(" ASC");
        QueryMessage mess = this.getMessage();
        mess.setOrderByClause(fieldList);
        return new OptionalSyntax(mess);
    }

    public OptionalSyntax orderByDescending(Path<?> ... path) {
        String fieldList = "";
        boolean firstExpression = true;
        for (Path<?> exp : path) {
            if (firstExpression) {
                fieldList = fieldList.concat(exp.toString());
                firstExpression = false;
            } else {
                fieldList = fieldList.concat(", ").concat(exp.toString());
            }
            LOG.debug("expression: " + exp);
        }
        fieldList = fieldList.concat(" DESC");
        QueryMessage mess = this.getMessage();
        mess.setOrderByClause(fieldList);
        return new OptionalSyntax(mess);
    }

    public OptionalSyntax skip(int num) {
        this.getMessage().setStartposition(num);
        QueryMessage mess = this.getMessage();
        return new OptionalSyntax(mess);
    }

    public OptionalSyntax take(int num) {
        this.getMessage().setMaxresults(num);
        QueryMessage mess = this.getMessage();
        return new OptionalSyntax(mess);
    }

    public QueryMessage getMessage() {
        return this.message;
    }

    public void setMessage(QueryMessage message) {
        this.message = message;
    }

    public String generate() {
        return this.toString();
    }

    public String toString() {
        return this.getMessage().toString();
    }
}

