/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.exception;

import com.intuit.ipp.data.Error;
import java.util.List;

public class FMSException
extends Exception {
    private static final long serialVersionUID = -3232762146006749659L;
    private List<Error> errorList = null;
    private Throwable throwable;
    private String intuit_tid;

    public FMSException(List<Error> errorList) {
        super(FMSException.getString(errorList));
        this.errorList = errorList;
    }

    public FMSException(String errorMessage) {
        super(errorMessage);
    }

    public FMSException(Throwable throwable) {
        super(throwable);
        this.throwable = throwable;
    }

    public FMSException(String errorMessage, Throwable throwable) {
        super(errorMessage, throwable);
        this.throwable = throwable;
    }

    public FMSException(String errorMessage, Throwable throwable, String intuit_tid) {
        super(errorMessage, throwable);
        this.throwable = throwable;
        this.intuit_tid = intuit_tid;
    }

    public List<Error> getErrorList() {
        return this.errorList;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getIntuit_tid() {
        return this.intuit_tid;
    }

    public void setIntuit_tid(String intuit_tid) {
        this.intuit_tid = intuit_tid;
    }

    protected static String getString(List<Error> errorList) {
        String exceptionDetails = "";
        if (errorList != null) {
            for (Error error : errorList) {
                StringBuilder sb = new StringBuilder();
                sb.append("ERROR CODE:").append(error.getCode()).append(", ERROR MESSAGE:").append(error.getMessage()).append(", ERROR DETAIL:").append(error.getDetail());
                if (error.getElement() != null) {
                    sb.append(", MORE ERROR DETAIL:").append(error.getElement());
                }
                sb.append("\r\n");
                exceptionDetails = exceptionDetails + sb.toString();
            }
        }
        return exceptionDetails;
    }
}

