/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.interceptors;

import com.intuit.ipp.compression.CompressorFactory;
import com.intuit.ipp.compression.ICompressor;
import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.interceptors.Interceptor;
import com.intuit.ipp.interceptors.IntuitMessage;
import com.intuit.ipp.interceptors.ResponseElements;
import com.intuit.ipp.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;

public class DecompressionInterceptor
implements Interceptor {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();

    @Override
    public void execute(IntuitMessage intuitMessage) throws FMSException {
        LOG.debug("Enter DecompressInterceptor...");
        ResponseElements responseElements = intuitMessage.getResponseElements();
        String contentEncoding = responseElements.getEncodingHeader();
        String decompressedData = null;
        boolean isCompressionEnabled = false;
        if (contentEncoding != null && StringUtils.hasText(contentEncoding)) {
            isCompressionEnabled = true;
            LOG.info("compression format : " + contentEncoding);
            LOG.debug("compression format : " + contentEncoding);
            ICompressor compressor = CompressorFactory.getCompressor(contentEncoding);
            try {
                ByteArrayOutputStream bytes = (ByteArrayOutputStream)compressor.decompress(responseElements.getResponseContent());
                responseElements.setResponseBytes(new ByteArrayInputStream(bytes.toByteArray()));
                decompressedData = new String(bytes.toByteArray());
            }
            catch (IllegalStateException e) {
                LOG.error("IllegalStateException while get the content from HttpResponse.", (Throwable)e);
                throw new FMSException(e);
            }
            catch (Exception e) {
                LOG.error("IOException in DecompressInterceptor.", (Throwable)e);
                throw new FMSException(e);
            }
        }
        if (!isCompressionEnabled) {
            BufferedReader br = null;
            String readLine = null;
            StringBuilder responseBody = new StringBuilder();
            try {
                br = new BufferedReader(new InputStreamReader(responseElements.getResponseContent()));
                while ((readLine = br.readLine()) != null) {
                    responseBody.append(readLine).append(System.getProperty("line.separator"));
                }
            }
            catch (IllegalStateException e) {
                LOG.error("IllegalStateException while get the content from HttpResponse.", (Throwable)e);
                throw new FMSException(e);
            }
            catch (Exception e) {
                LOG.error("IOException in DecompressInterceptor.", (Throwable)e);
                throw new FMSException(e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to close BufferedReader", (Throwable)e);
                    }
                }
            }
            try {
                responseElements.getResponseContent().reset();
            }
            catch (IOException ex) {
                LOG.warn("Unable to reset ResponseContent for bytes without compression", (Throwable)ex);
            }
            decompressedData = responseBody.toString();
            responseElements.setResponseBytes(responseElements.getResponseContent());
        }
        LOG.debug("Decompressed Response Body : " + decompressedData);
        LOG.debug("Exit DecompressInterceptor.");
        responseElements.setDecompressedData(decompressedData);
    }
}

