/*******************************************************************************
 * Copyright (c) 2017 Intuit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package com.intuit.ipp.serialization.custom;

import java.lang.reflect.Type;

import javax.xml.bind.JAXBElement;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.intuit.ipp.data.IntuitEntity;
import com.intuit.ipp.util.MessageUtils;

public class JAXBElementJsonSerializer implements JsonSerializer<JAXBElement<? extends IntuitEntity>> {

	  @Override
	  public JsonElement serialize(final JAXBElement<? extends IntuitEntity> jaxbVariable, final Type typeOfSrc, final JsonSerializationContext context) {
		  return new JsonPrimitive(MessageUtils.getGson().toJson(jaxbVariable.getValue()));
	  }
}
