/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.sb.cdm.util.v3;

import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateAdapter
extends XmlAdapter<String, Date> {
    private static final int lengthOfDateFmtYYYY_MM_DD = 10;
    private static final String INVALIDDATE = "9999-12-31";
    private static final String datePattern = "(19|20)\\d\\d([- /.])(0[1-9]|1[012])\\2(0[1-9]|[12][0-9]|3[01])";
    private static final DateTimeFormatter formatter = ISODateTimeFormat.date();

    @Override
    public Date unmarshal(String value) {
        if (value != null) {
            if (value.length() >= 10) {
                boolean isMatch = (value = value.substring(0, 10)).matches(datePattern);
                if (isMatch) {
                    return DatatypeConverter.parseDate(value).getTime();
                }
                return DatatypeConverter.parseDate(INVALIDDATE).getTime();
            }
            return DatatypeConverter.parseDate(INVALIDDATE).getTime();
        }
        return null;
    }

    @Override
    public String marshal(Date value) {
        if (value == null) {
            return null;
        }
        return formatter.print(new DateTime(value));
    }
}

