/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.services;

import com.intuit.ipp.core.IEntity;
import com.intuit.ipp.data.BatchItemRequest;
import com.intuit.ipp.data.CDCQuery;
import com.intuit.ipp.data.Fault;
import com.intuit.ipp.data.IntuitEntity;
import com.intuit.ipp.data.ObjectFactory;
import com.intuit.ipp.data.OperationEnum;
import com.intuit.ipp.data.Report;
import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.services.CDCQueryResult;
import com.intuit.ipp.services.QueryResult;
import com.intuit.ipp.util.DateUtils;
import com.intuit.ipp.util.StringUtils;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;

public class BatchOperation {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    protected List<BatchItemRequest> batchItemRequests = new LinkedList<BatchItemRequest>();
    private Map<String, Fault> faultResult = new HashMap<String, Fault>();
    private Map<String, Report> reportResult = new HashMap<String, Report>();
    private Map<String, QueryResult> queryResult = new HashMap<String, QueryResult>();
    private Map<String, CDCQueryResult> cdcQueryResult = new HashMap<String, CDCQueryResult>();
    private Map<String, IEntity> entityResult = new HashMap<String, IEntity>();
    protected List<String> bIds = new ArrayList<String>();

    public <T extends IEntity> void addEntity(T entity, OperationEnum operation, String bId) {
        BatchItemRequest batchItemRequest = new BatchItemRequest();
        batchItemRequest.setBId(bId);
        batchItemRequest.setOperation(operation);
        batchItemRequest.setIntuitObject(this.getIntuitObject(entity));
        this.batchItemRequests.add(batchItemRequest);
        this.bIds.add(bId);
    }

    public void addQuery(String query, String bId) {
        BatchItemRequest batchItemRequest = new BatchItemRequest();
        batchItemRequest.setBId(bId);
        batchItemRequest.setQuery(query);
        this.batchItemRequests.add(batchItemRequest);
        this.bIds.add(bId);
    }

    public void addCDCQuery(List<? extends IEntity> entities, String changedSince, String bId) throws FMSException {
        if (entities == null || entities.isEmpty()) {
            throw new FMSException("Entities is required.");
        }
        if (!StringUtils.hasText(changedSince)) {
            throw new FMSException("changedSince is required.");
        }
        CDCQuery cdcQuery = new CDCQuery();
        StringBuffer entityParam = new StringBuffer();
        for (IEntity iEntity : entities) {
            entityParam.append(iEntity.getClass().getSimpleName()).append(",");
        }
        entityParam.delete(entityParam.length() - 1, entityParam.length());
        cdcQuery.setEntities(entityParam.toString());
        try {
            cdcQuery.setChangedSince(DateUtils.getDateFromString(changedSince));
        }
        catch (ParseException e) {
            LOG.error("ParseException while converting to Date.", e);
            throw new FMSException("ParseException while converting to Date. Please provide valid DateTime (yyyy-MM-ddTHH:mm:ss.SSSZ).", e);
        }
        BatchItemRequest batchItemRequest = new BatchItemRequest();
        batchItemRequest.setBId(bId);
        batchItemRequest.setCDCQuery(cdcQuery);
        this.batchItemRequests.add(batchItemRequest);
        this.bIds.add(bId);
    }

    public void addReportQuery(String reportQuery, String bId) {
        BatchItemRequest batchItemRequest = new BatchItemRequest();
        batchItemRequest.setBId(bId);
        batchItemRequest.setReportQuery(reportQuery);
        this.batchItemRequests.add(batchItemRequest);
        this.bIds.add(bId);
    }

    public List<BatchItemRequest> getBatchItemRequests() {
        return this.batchItemRequests;
    }

    public List<String> getBIds() {
        return this.bIds;
    }

    public boolean isFault(String bId) {
        return this.faultResult.containsKey(bId);
    }

    public boolean isReport(String bId) {
        return this.reportResult.containsKey(bId);
    }

    public boolean isQuery(String bId) {
        return this.queryResult.containsKey(bId);
    }

    public boolean isCDCQuery(String bId) {
        return this.cdcQueryResult.containsKey(bId);
    }

    public boolean isEntity(String bId) {
        return this.entityResult.containsKey(bId);
    }

    public Fault getFault(String bId) {
        return this.faultResult.get(bId);
    }

    public Report getReport(String bId) {
        return this.reportResult.get(bId);
    }

    public QueryResult getQueryResponse(String bId) {
        return this.queryResult.get(bId);
    }

    public CDCQueryResult getCDCQueryResult(String bId) {
        return this.cdcQueryResult.get(bId);
    }

    public IEntity getEntity(String bId) {
        return this.entityResult.get(bId);
    }

    public Map<String, Fault> getFaultResult() {
        return this.faultResult;
    }

    public Map<String, Report> getReportResult() {
        return this.reportResult;
    }

    public Map<String, QueryResult> getQueryResult() {
        return this.queryResult;
    }

    public Map<String, CDCQueryResult> getCDCQueryResult() {
        return this.cdcQueryResult;
    }

    public Map<String, IEntity> getEntityResult() {
        return this.entityResult;
    }

    protected <T> JAXBElement<? extends IntuitEntity> getIntuitObject(T entity) {
        Class<?> objectClass = entity.getClass();
        String methodName = "create".concat(objectClass.getSimpleName());
        ObjectFactory objectEntity = new ObjectFactory();
        Class<?> objectEntityClass = objectEntity.getClass();
        Method method = null;
        try {
            method = objectEntityClass.getMethod(methodName, Class.forName(objectClass.getName()));
        }
        catch (Exception e) {
            LOG.error("Exception while prepare the method signature using reflection to generate JAXBElement", e);
        }
        JAXBElement jaxbElement = null;
        try {
            jaxbElement = (JAXBElement)method.invoke((Object)objectEntity, entity);
        }
        catch (Exception e) {
            LOG.error("Exception while invoking the method using reflection to generate JAXBElement", e);
        }
        return jaxbElement;
    }
}

