/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import com.intuit.ipp.data.Fault;
import com.intuit.ipp.data.IntuitResponse;
import com.intuit.ipp.data.TaxRateApplicableOnEnum;
import com.intuit.ipp.data.TaxRateDetails;
import com.intuit.ipp.data.TaxService;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;

public class TaxServiceDeserializer
extends JsonDeserializer<TaxService> {
    private static final String FAULT = "Fault";

    @Override
    public TaxService deserialize(JsonParser jp, DeserializationContext desContext) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        TaxService taxService = new TaxService();
        JaxbAnnotationIntrospector primary = new JaxbAnnotationIntrospector();
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair(primary, secondary);
        mapper.setAnnotationIntrospector(pair);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode jn = (JsonNode)jp.readValueAsTree();
        Iterator<String> ite = jn.fieldNames();
        IntuitResponse qr = new IntuitResponse();
        ArrayList<TaxRateDetails> taxRateDetailsList = new ArrayList<TaxRateDetails>();
        while (ite.hasNext()) {
            String key = ite.next();
            if (key.equalsIgnoreCase(FAULT)) {
                qr.setFault(mapper.treeToValue(jn.get(FAULT), Fault.class));
                taxService.setFault(mapper.treeToValue(jn.get(FAULT), Fault.class));
                continue;
            }
            if (key.equalsIgnoreCase("TaxCode")) {
                taxService.setTaxCode(mapper.treeToValue(jn.get(key), String.class));
                continue;
            }
            if (key.equalsIgnoreCase("TaxCodeId")) {
                taxService.setTaxCodeId(mapper.treeToValue(jn.get(key), String.class));
                continue;
            }
            if (!key.equalsIgnoreCase("TaxRateDetails")) continue;
            JsonNode jn1 = jn.get(key);
            if (jn1.isArray()) {
                for (JsonNode jn2 : jn1) {
                    TaxRateDetails taxRateDetails = this.getTaxRateDetails(jn2);
                    taxRateDetailsList.add(taxRateDetails);
                }
            }
            taxService.setTaxRateDetails(taxRateDetailsList);
        }
        return taxService;
    }

    private TaxRateDetails getTaxRateDetails(JsonNode jn) throws IOException {
        TaxRateDetails taxRateDetails = new TaxRateDetails();
        ObjectMapper mapper = new ObjectMapper();
        JaxbAnnotationIntrospector primary = new JaxbAnnotationIntrospector(mapper.getTypeFactory());
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair(primary, secondary);
        mapper.setAnnotationIntrospector(pair);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Iterator<String> ite = jn.fieldNames();
        while (ite.hasNext()) {
            String key = ite.next();
            if (key.equalsIgnoreCase("TaxRateName")) {
                taxRateDetails.setTaxRateName(mapper.treeToValue(jn.get(key), String.class));
                continue;
            }
            if (key.equalsIgnoreCase("RateValue")) {
                taxRateDetails.setRateValue(mapper.treeToValue(jn.get(key), BigDecimal.class));
                continue;
            }
            if (key.equalsIgnoreCase("TaxAgencyId")) {
                taxRateDetails.setTaxAgencyId(mapper.treeToValue(jn.get(key), String.class));
                continue;
            }
            if (key.equalsIgnoreCase("TaxApplicableOn")) {
                taxRateDetails.setTaxApplicableOn(mapper.treeToValue(jn.get(key), TaxRateApplicableOnEnum.class));
                continue;
            }
            if (!key.equalsIgnoreCase("TaxRateId")) continue;
            taxRateDetails.setTaxRateId(mapper.treeToValue(jn.get(key), String.class));
        }
        return taxRateDetails;
    }
}

