/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import com.intuit.ipp.data.Error;
import com.intuit.ipp.data.IntuitEntity;
import com.intuit.ipp.data.ObjectFactory;
import com.intuit.ipp.data.SyncError;
import com.intuit.ipp.data.SyncObject;
import com.intuit.ipp.serialization.JsonResourceTypeLocator;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;

public class SyncErrorDeserializer
extends JsonDeserializer<SyncError> {
    ObjectMapper mapper = new ObjectMapper();
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final String CLOUDVERSION = "CloudVersion";
    private static final String QBVERSION = "QBVersion";
    private static final String ERROR = "Error";
    private ObjectFactory objFactory = new ObjectFactory();

    @Override
    public SyncError deserialize(JsonParser jp, DeserializationContext desContext) throws IOException {
        JaxbAnnotationIntrospector primary = new JaxbAnnotationIntrospector();
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair(primary, secondary);
        this.mapper.setAnnotationIntrospector(pair);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode jn = (JsonNode)jp.readValueAsTree();
        SyncError se = new SyncError();
        Iterator<String> ite = jn.fieldNames();
        while (ite.hasNext()) {
            String key = ite.next();
            if (key.equals(CLOUDVERSION)) {
                se.setCloudVersion(this.getSyncObject(jn.get(key)));
                continue;
            }
            if (key.equals(QBVERSION)) {
                se.setQBVersion(this.getSyncObject(jn.get(key)));
                continue;
            }
            if (!key.equals(ERROR)) continue;
            se.setError(this.mapper.treeToValue(jn.get(key), Error.class));
        }
        return se;
    }

    private SyncObject getSyncObject(JsonNode jsonNode) {
        Object name = null;
        JsonNode jn1 = null;
        SyncObject syncObject = new SyncObject();
        Iterator<String> ite = jsonNode.fieldNames();
        while (ite.hasNext()) {
            String key = ite.next();
            if (JsonResourceTypeLocator.lookupType(key) == null) continue;
            jn1 = jsonNode.get(key);
            LOG.debug("Query response entity Key :" + key);
            try {
                Object intuitType = this.mapper.treeToValue(jn1, JsonResourceTypeLocator.lookupType(key));
                if (!(intuitType instanceof IntuitEntity)) continue;
                JAXBElement<IntuitEntity> intuitObject = this.objFactory.createIntuitObject((IntuitEntity)intuitType);
                syncObject.setIntuitObject(intuitObject);
            }
            catch (JsonParseException e) {
                e.printStackTrace();
            }
            catch (JsonMappingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return syncObject;
    }
}

