/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import com.intuit.ipp.data.AttachableResponse;
import com.intuit.ipp.data.BatchItemResponse;
import com.intuit.ipp.data.CDCResponse;
import com.intuit.ipp.data.Columns;
import com.intuit.ipp.data.CustomFieldDefinition;
import com.intuit.ipp.data.Fault;
import com.intuit.ipp.data.IntuitEntity;
import com.intuit.ipp.data.IntuitResponse;
import com.intuit.ipp.data.OLBStatus;
import com.intuit.ipp.data.OLBTransaction;
import com.intuit.ipp.data.ObjectFactory;
import com.intuit.ipp.data.QueryResponse;
import com.intuit.ipp.data.Report;
import com.intuit.ipp.data.ReportHeader;
import com.intuit.ipp.data.Rows;
import com.intuit.ipp.data.SyncErrorResponse;
import com.intuit.ipp.serialization.AttachableResponseDeserializer;
import com.intuit.ipp.serialization.BatchItemResponseDeserializer;
import com.intuit.ipp.serialization.CDCQueryResponseDeserializer;
import com.intuit.ipp.serialization.CustomFieldDefinitionDeserializer;
import com.intuit.ipp.serialization.IntuitResponseDeserializerHelper;
import com.intuit.ipp.serialization.JsonResourceTypeLocator;
import com.intuit.ipp.serialization.QueryResponseDeserializer;
import com.intuit.ipp.serialization.SyncErrorResponseDeserializer;
import com.intuit.ipp.util.DateUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;

public class IntuitResponseDeserializer
extends JsonDeserializer<IntuitResponse> {
    private IntuitResponseDeserializerHelper intuitResponseDeserializerHelper = new IntuitResponseDeserializerHelper();
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final String FAULT = "Fault";
    private static final String REPORT = "Report";
    private static final String HEADER = "Header";
    private static final String ROWS = "Rows";
    private static final String COLUMNS = "Columns";
    private static final String REQUESTID = "requestId";
    private static final String STATUS = "status";
    private static final String TIME = "time";
    private static final String SYNC_ERROR_RESPONSE = "SyncErrorResponse";
    private static final String QUERY_RESPONSE = "QueryResponse";
    private static final String CDC_QUERY_RESPONSE = "CDCResponse";
    private static final String BATCH_ITEM_RESPONSE = "BatchItemResponse";
    private static final String ATTACHABLE_RESPONSE = "AttachableResponse";
    private ObjectFactory objFactory = new ObjectFactory();

    @Override
    public IntuitResponse deserialize(JsonParser jp, DeserializationContext desContext) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Report report = new Report();
        JaxbAnnotationIntrospector primary = new JaxbAnnotationIntrospector();
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair(primary, secondary);
        mapper.setAnnotationIntrospector(pair);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode jn = (JsonNode)jp.readValueAsTree();
        IntuitResponse qr = new IntuitResponse();
        ArrayList<BatchItemResponse> batchItemResponses = null;
        ArrayList<AttachableResponse> attachableResponses = null;
        Iterator<String> ite = jn.fieldNames();
        while (ite.hasNext()) {
            JsonNode jn1;
            String key = ite.next();
            if (key.equalsIgnoreCase(FAULT)) {
                mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
                qr.setFault(mapper.treeToValue(jn.get(key), Fault.class));
                continue;
            }
            if (key.equalsIgnoreCase(REPORT)) {
                qr.setReport(mapper.treeToValue(jn.get(key), Report.class));
                continue;
            }
            if (key.equalsIgnoreCase(HEADER)) {
                ReportHeader header = mapper.treeToValue(jn.get(HEADER), ReportHeader.class);
                report.setHeader(header);
                continue;
            }
            if (key.equalsIgnoreCase(ROWS)) {
                Rows rows = mapper.treeToValue(jn.get(ROWS), Rows.class);
                report.setRows(rows);
                continue;
            }
            if (key.equalsIgnoreCase(COLUMNS)) {
                Columns columns = mapper.treeToValue(jn.get(COLUMNS), Columns.class);
                report.setColumns(columns);
                continue;
            }
            if (key.equalsIgnoreCase(REQUESTID)) {
                qr.setRequestId(jn.get(REQUESTID).textValue());
                continue;
            }
            if (key.equals(TIME)) {
                try {
                    qr.setTime(DateUtils.getDateFromString(jn.get(TIME).textValue()));
                }
                catch (Exception columns) {}
                continue;
            }
            if (key.equals(STATUS)) {
                qr.setStatus(jn.get(STATUS).textValue());
                continue;
            }
            if (key.equals(SYNC_ERROR_RESPONSE)) {
                qr.setSyncErrorResponse(this.getSyncErrorResponse(jn.get(key)));
                continue;
            }
            if (key.equals(QUERY_RESPONSE)) {
                qr.setQueryResponse(this.getQueryResponse(jn.get(key)));
                continue;
            }
            if (key.equals(CDC_QUERY_RESPONSE)) {
                ArrayList<CDCResponse> cdcResponses = new ArrayList<CDCResponse>();
                JsonNode jn12 = jn.get(key);
                if (jn12.isArray()) {
                    for (JsonNode jn2 : jn12) {
                        cdcResponses.add(this.getCDCQueryResponse(jn2));
                    }
                }
                qr.setCDCResponse(cdcResponses);
                continue;
            }
            if (key.equals(BATCH_ITEM_RESPONSE)) {
                if (JsonResourceTypeLocator.lookupType(key) == null) continue;
                LOG.debug("processing batch item response");
                jn1 = jn.get(key);
                batchItemResponses = new ArrayList<BatchItemResponse>();
                if (jn1.isArray()) {
                    for (JsonNode jn2 : jn1) {
                        batchItemResponses.add(this.getBatchItemResponse(jn2));
                    }
                }
                qr.setBatchItemResponse(batchItemResponses);
                continue;
            }
            if (key.equals(ATTACHABLE_RESPONSE)) {
                if (JsonResourceTypeLocator.lookupType(key) == null) continue;
                LOG.debug("processing attachable response");
                jn1 = jn.get(key);
                attachableResponses = new ArrayList<AttachableResponse>();
                if (jn1.isArray()) {
                    for (JsonNode jn2 : jn1) {
                        attachableResponses.add(this.getAttachableResponse(jn2));
                    }
                }
                qr.setAttachableResponse(attachableResponses);
                continue;
            }
            String entity = key;
            LOG.debug("entity key : " + key);
            if (JsonResourceTypeLocator.lookupType(entity) == null) continue;
            this.registerModulesForCustomFieldDef(mapper);
            Object intuitType = mapper.treeToValue(jn.get(key), JsonResourceTypeLocator.lookupType(entity));
            if (intuitType instanceof IntuitEntity) {
                this.intuitResponseDeserializerHelper.updateBigDecimalScale((IntuitEntity)intuitType);
                JAXBElement<IntuitEntity> intuitObject = this.objFactory.createIntuitObject((IntuitEntity)intuitType);
                qr.setIntuitObject(intuitObject);
                continue;
            }
            if (intuitType instanceof OLBStatus) {
                qr.setOLBStatus((OLBStatus)intuitType);
                continue;
            }
            if (!(intuitType instanceof OLBTransaction)) continue;
            qr.setOLBTransaction((OLBTransaction)intuitType);
        }
        qr.setReport(report);
        return qr;
    }

    private QueryResponse getQueryResponse(JsonNode jsonNode) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule("QueryResponseDeserializer", new Version(1, 0, 0, null));
        simpleModule.addDeserializer(QueryResponse.class, new QueryResponseDeserializer());
        mapper.registerModule(simpleModule);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper.treeToValue(jsonNode, QueryResponse.class);
    }

    private CDCResponse getCDCQueryResponse(JsonNode jsonNode) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule("CDCQueryResponseDeserializer", new Version(1, 0, 0, null));
        simpleModule.addDeserializer(CDCResponse.class, new CDCQueryResponseDeserializer());
        mapper.registerModule(simpleModule);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper.treeToValue(jsonNode, CDCResponse.class);
    }

    private BatchItemResponse getBatchItemResponse(JsonNode jsonNode) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule("BatchItemResponseDeserializer", new Version(1, 0, 0, null));
        simpleModule.addDeserializer(BatchItemResponse.class, new BatchItemResponseDeserializer());
        mapper.registerModule(simpleModule);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper.treeToValue(jsonNode, BatchItemResponse.class);
    }

    private AttachableResponse getAttachableResponse(JsonNode jsonNode) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule("AttachableResponseDeserializer", new Version(1, 0, 0, null));
        simpleModule.addDeserializer(AttachableResponse.class, new AttachableResponseDeserializer());
        mapper.registerModule(simpleModule);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper.treeToValue(jsonNode, AttachableResponse.class);
    }

    private void registerModulesForCustomFieldDef(ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule("CustomFieldDefinition", new Version(1, 0, 0, null));
        simpleModule.addDeserializer(CustomFieldDefinition.class, new CustomFieldDefinitionDeserializer());
        objectMapper.registerModule(simpleModule);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private SyncErrorResponse getSyncErrorResponse(JsonNode jsonNode) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule("SyncErrorResponseDeserializer", new Version(1, 0, 0, null));
        simpleModule.addDeserializer(SyncErrorResponse.class, new SyncErrorResponseDeserializer());
        mapper.registerModule(simpleModule);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper.treeToValue(jsonNode, SyncErrorResponse.class);
    }
}

