/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.query;

import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.query.GenerateQuery;
import com.intuit.ipp.query.Path;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;

public class MyMethodInterceptor
implements MethodInterceptor {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final int NUM_3 = 3;
    private static final int NUM_2 = 2;

    @Override
    public Object intercept(Object arg0, Method arg1, Object[] arg2, MethodProxy arg3) throws FMSException {
        if (GenerateQuery.path.get() == null) {
            GenerateQuery.path.set(new Path(this.extractPropertyName(arg1), this.extractEntity(arg0)));
        } else {
            String parentPath = GenerateQuery.path.get().getPathString();
            GenerateQuery.path.get().setPathString(parentPath.concat(".").concat(this.extractPropertyName(arg1)));
        }
        return this.createInstance(arg0, arg1, arg2, arg3);
    }

    private String extractEntity(Object obj) {
        String name = obj.getClass().getSimpleName();
        String[] extracted = name.split("\\$\\$");
        if (extracted.length == 3) {
            return extracted[0];
        }
        return null;
    }

    protected String extractPropertyName(Method method) {
        String name = method.getName();
        name = name.startsWith("is") ? name.substring(2) : name.substring(3);
        return name;
    }

    public <T> T createInstance(Object arg0, Method arg1, Object[] arg2, MethodProxy arg3) throws FMSException {
        Class<Object> obj = null;
        Class<?> type = arg1.getReturnType();
        if (String.class.equals(type)) {
            obj = null;
        } else if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            obj = 0;
        } else if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
            obj = 0;
        } else if (java.util.Date.class.equals(type)) {
            obj = new java.util.Date();
        } else if (Timestamp.class.equals(type)) {
            obj = new Timestamp(System.currentTimeMillis());
        } else if (Date.class.equals(type)) {
            obj = new Date(System.currentTimeMillis());
        } else if (Time.class.equals(type)) {
            obj = new Time(System.currentTimeMillis());
        } else if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            obj = 0L;
        } else if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            obj = Short.valueOf("0");
        } else if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            obj = 0.0;
        } else if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            obj = Float.valueOf(0.0f);
        } else if (BigInteger.class.equals(type)) {
            obj = BigInteger.valueOf(0L);
        } else if (BigDecimal.class.equals(type)) {
            obj = BigDecimal.valueOf(0L);
        } else if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            obj = Boolean.TRUE;
        } else if (List.class.isAssignableFrom(type)) {
            try {
                Type t = arg1.getGenericReturnType();
                Object value = this.getObject(t);
                Object queryValue = GenerateQuery.createQueryEntity(value);
                obj = arg3.invokeSuper(arg0, arg2);
                ((List)((Object)obj)).add(queryValue);
            }
            catch (Throwable t) {
                throw new FMSException(t);
            }
        } else if (Enum.class.isAssignableFrom(type)) {
            LOG.debug("Create instance for Enum");
        } else if (type.isArray()) {
            LOG.debug("Create instance for Array Object");
        } else {
            obj = !Modifier.isFinal(type.getModifiers()) ? GenerateQuery.createQueryEntity(type) : null;
        }
        return (T)obj;
    }

    public Object getObject(Type type) throws FMSException {
        Object obj = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            String typeString = pt.getActualTypeArguments()[0].toString().split(" ")[1];
            try {
                obj = Class.forName(typeString).newInstance();
            }
            catch (Exception e) {
                throw new FMSException(e);
            }
        }
        return obj;
    }
}

