/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.query;

import com.intuit.ipp.core.IEntity;
import com.intuit.ipp.query.MyMethodInterceptor;
import com.intuit.ipp.query.OptionalSyntax;
import com.intuit.ipp.query.Path;
import com.intuit.ipp.query.QueryMessage;
import com.intuit.ipp.query.expr.BooleanPath;
import com.intuit.ipp.query.expr.CalendarPath;
import com.intuit.ipp.query.expr.EnumPath;
import com.intuit.ipp.query.expr.NumberPath;
import com.intuit.ipp.query.expr.StringPath;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.NoOp;
import org.slf4j.Logger;

public final class GenerateQuery {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final int LEN_3 = 3;
    public static ThreadLocal<Path<?>> path = new ThreadLocal();
    private static QueryMessage message = new QueryMessage();
    private static final CallbackFilter CALLBACK_FILTER = new CallbackFilter(){

        @Override
        public int accept(Method method) {
            if (this.isFinalizeMethod(method) || this.isCloneMethod(method) || this.isEqualsMethod(method) || this.isHashCodeMethod(method) || this.isToStringMethod(method)) {
                return 0;
            }
            return 1;
        }

        private boolean isFinalizeMethod(Method method) {
            return method != null && method.getName().equals("finalize") && method.getParameterTypes().length == 0;
        }

        private boolean isCloneMethod(Method method) {
            return method != null && method.getName().equals("clone") && method.getParameterTypes().length == 0;
        }

        private boolean isEqualsMethod(Method method) {
            if (method == null || !method.getName().equals("equals")) {
                return false;
            }
            Class<?>[] paramTypes = method.getParameterTypes();
            return paramTypes.length == 1 && paramTypes[0] == Object.class;
        }

        private boolean isHashCodeMethod(Method method) {
            return method != null && method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
        }

        private boolean isToStringMethod(Method method) {
            return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
        }
    };

    private GenerateQuery() {
    }

    public static <T> T createQueryEntity(Class<T> cl) {
        Enhancer enhancer = new Enhancer();
        if (cl.isInterface()) {
            LOG.debug("The given class is interface");
        } else {
            enhancer.setSuperclass(cl);
        }
        enhancer.setCallbackFilter(CALLBACK_FILTER);
        enhancer.setCallbacks(new Callback[]{NoOp.INSTANCE, new MyMethodInterceptor()});
        return (T)enhancer.create();
    }

    public static <T> T createQueryEntity(T entity) {
        Class<?> cl = entity.getClass();
        Enhancer enhancer = new Enhancer();
        if (cl.isInterface()) {
            LOG.debug("The given entity is interface");
        } else {
            enhancer.setSuperclass(cl);
            enhancer.setCallbackFilter(CALLBACK_FILTER);
            enhancer.setCallbacks(new Callback[]{NoOp.INSTANCE, new MyMethodInterceptor()});
        }
        return (T)enhancer.create();
    }

    public static Path<?> $(Object ret) {
        Path<?> currentPath = path.get();
        path.set(null);
        if (currentPath != null) {
            return new Path(currentPath.getPathString().concat(".*"), currentPath.getEntity());
        }
        String name = ret.getClass().getSimpleName();
        String[] extracted = name.split("\\$\\$");
        return new Path("*", extracted[0]);
    }

    public static CalendarPath $(Calendar ret) {
        Path<?> currentPath = path.get();
        path.set(null);
        return new CalendarPath(currentPath.getPathString(), currentPath.getEntity());
    }

    public static CalendarPath $(Date ret) {
        Path<?> currentPath = path.get();
        path.set(null);
        return new CalendarPath(currentPath.getPathString(), currentPath.getEntity());
    }

    public static StringPath $(String ret) {
        Path<?> currentPath = path.get();
        path.set(null);
        return new StringPath(currentPath.getPathString(), currentPath.getEntity());
    }

    public static NumberPath $(Number ret) {
        Path<?> currentPath = path.get();
        path.set(null);
        return new NumberPath(currentPath.getPathString(), currentPath.getEntity());
    }

    public static BooleanPath $(Boolean ret) {
        Path<?> currentPath = path.get();
        path.set(null);
        return new BooleanPath(currentPath.getPathString(), currentPath.getEntity());
    }

    public static EnumPath $(Enum<?> ret) {
        Path<?> currentPath = path.get();
        path.set(null);
        return new EnumPath(currentPath.getPathString(), currentPath.getEntity());
    }

    public static <T extends IEntity> OptionalSyntax select(Path<?> path, Path<?> ... pathlist) {
        GenerateQuery.resetQueryMessage();
        GenerateQuery.getMessage().setSQL("SELECT");
        GenerateQuery.getMessage().setEntity(path.getEntity());
        GenerateQuery.getMessage().getProjection().add(path.toString());
        if (pathlist.length != 0) {
            for (Path<?> singlePath : pathlist) {
                GenerateQuery.getMessage().getProjection().add(singlePath.toString());
            }
        }
        return new OptionalSyntax(GenerateQuery.getMessage());
    }

    public static <T extends IEntity> OptionalSyntax selectCount(T entity) {
        GenerateQuery.resetQueryMessage();
        GenerateQuery.getMessage().setSQL("SELECT");
        String name = entity.getClass().getSimpleName();
        String[] extracted = name.split("\\$\\$");
        GenerateQuery.getMessage().setCount(true);
        if (extracted.length == 3) {
            GenerateQuery.getMessage().setEntity(extracted[0]);
        }
        return new OptionalSyntax(GenerateQuery.getMessage());
    }

    public static QueryMessage getMessage() {
        return message;
    }

    public static void setMessage(QueryMessage mess) {
        message = mess;
    }

    public static void resetQueryMessage() {
        GenerateQuery.setMessage(new QueryMessage());
    }
}

