/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.interceptors;

import com.intuit.ipp.data.Attachable;
import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.interceptors.Interceptor;
import com.intuit.ipp.interceptors.IntuitMessage;
import com.intuit.ipp.interceptors.RequestElements;
import com.intuit.ipp.interceptors.UploadRequestElements;
import com.intuit.ipp.net.MethodType;
import com.intuit.ipp.net.OperationType;
import com.intuit.ipp.serialization.IEntitySerializer;
import com.intuit.ipp.serialization.SerializerFactory;
import com.intuit.ipp.util.Config;
import com.intuit.ipp.util.StringUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;

public class SerializeInterceptor
implements Interceptor {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final String[] IMAGE_MIMES = new String[]{"jpg", "jpeg", "tif", "tiff", "gif", "png", "bmp"};

    @Override
    public void execute(IntuitMessage intuitMessage) throws FMSException {
        LOG.debug("Enter SerializeInterceptor...");
        String serializedData = null;
        RequestElements requestElements = intuitMessage.getRequestElements();
        String methodType = requestElements.getRequestParameters().get("method_type");
        if (methodType.equals(MethodType.POST.toString())) {
            String serializeFormat = this.getSerializationRequestFormat();
            LOG.info("serialization format : " + serializeFormat);
            if (StringUtils.hasText(requestElements.getPostString())) {
                serializedData = requestElements.getPostString();
            } else if (StringUtils.hasText(serializeFormat)) {
                IEntitySerializer serializer = SerializerFactory.getSerializer(serializeFormat);
                serializedData = serializer.serialize(requestElements.getObjectToSerialize());
                String action = requestElements.getAction();
                if (action != null && action.equals(OperationType.UPLOAD.toString())) {
                    UploadRequestElements uploadRequestElements = requestElements.getUploadRequestElements();
                    StringBuilder input = new StringBuilder();
                    input.append(uploadRequestElements.getBoundaryForEntity()).append(serializedData);
                    input.append(uploadRequestElements.getBoundaryForContent());
                    serializedData = input.toString();
                    requestElements.setUploadFile(this.getUploadFileContent(requestElements));
                }
            } else {
                LOG.debug("Serialization doesn't applicable for this request");
            }
        } else {
            LOG.debug("Serialization doesn't applicable for the GET request");
        }
        LOG.debug("Exit SerializeInterceptor.");
        requestElements.setSerializedData(serializedData);
    }

    protected String getSerializationRequestFormat() {
        return Config.getProperty("message.request.serialization");
    }

    private byte[] getUploadFileContent(RequestElements requestElements) throws FMSException {
        Attachable attachable = (Attachable)requestElements.getEntity();
        InputStream docContent = requestElements.getUploadRequestElements().getDocContent();
        String mime = this.getMime(attachable.getFileName(), ".");
        String string = mime = mime != null ? mime : this.getMime(attachable.getContentType(), "/");
        if (this.isImageType(mime)) {
            return this.getImageContent(docContent, mime);
        }
        return this.getContent(docContent);
    }

    private byte[] getContent(InputStream in) throws FMSException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] content = null;
        try {
            int nRead;
            byte[] data = new byte[1028];
            while ((nRead = in.read(data, 0, data.length)) != -1) {
                baos.write(data, 0, nRead);
            }
            baos.flush();
            content = baos.toByteArray();
        }
        catch (IOException e) {
            throw new FMSException("Error while reading the upload file.", e);
        }
        finally {
            this.close(baos);
            this.close(in);
        }
        return content;
    }

    private byte[] getImageContent(InputStream in, String mime) throws FMSException {
        byte[] imageInByte = null;
        ByteArrayOutputStream baos = null;
        try {
            BufferedImage originalImage = ImageIO.read(in);
            baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)originalImage, mime, baos);
            baos.flush();
            imageInByte = baos.toByteArray();
            baos.close();
            this.close(baos);
            this.close(in);
        }
        catch (IOException e) {
            try {
                throw new FMSException("Error while reading the upload file.", e);
            }
            catch (Throwable throwable) {
                this.close(baos);
                this.close(in);
                throw throwable;
            }
        }
        return imageInByte;
    }

    private boolean isImageType(String mime) {
        if (StringUtils.hasText(mime)) {
            for (String imageMime : IMAGE_MIMES) {
                if (!mime.equalsIgnoreCase(imageMime)) continue;
                return true;
            }
        }
        return false;
    }

    private String getMime(String name, String delimiter) {
        if (StringUtils.hasText(name)) {
            return name.substring(name.lastIndexOf(delimiter) + 1, name.length());
        }
        return null;
    }

    private void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                LOG.error("Exception while closing the InputStream.", e);
            }
        }
    }

    private void close(ByteArrayOutputStream baos) {
        if (baos != null) {
            try {
                baos.close();
            }
            catch (IOException e) {
                LOG.error("Exception while closing the ByteArrayOutputStream.", e);
            }
        }
    }
}

