/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.interceptors;

import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.interceptors.DecompressionInterceptor;
import com.intuit.ipp.interceptors.DeserializeInterceptor;
import com.intuit.ipp.interceptors.HTTPClientConnectionInterceptor;
import com.intuit.ipp.interceptors.Interceptor;
import com.intuit.ipp.interceptors.IntuitMessage;
import com.intuit.ipp.interceptors.PrepareRequestInterceptor;
import java.util.ArrayList;
import java.util.List;

public class PlatformInterceptorProvider {
    private List<Interceptor> requestInterceptors = new ArrayList<Interceptor>();
    private List<Interceptor> responseInterceptors = new ArrayList<Interceptor>();

    public PlatformInterceptorProvider() {
        this.requestInterceptors.add(new PrepareRequestInterceptor());
        this.requestInterceptors.add(new HTTPClientConnectionInterceptor());
        this.responseInterceptors.add(new DecompressionInterceptor());
        this.responseInterceptors.add(new DeserializeInterceptor());
    }

    public void executeInterceptors(IntuitMessage intuitMessage) throws FMSException {
        this.executeRequestInterceptors(intuitMessage);
        this.executeResponseInterceptors(intuitMessage);
    }

    private void executeRequestInterceptors(IntuitMessage intuitMessage) throws FMSException {
        for (Interceptor interceptor : this.requestInterceptors) {
            interceptor.execute(intuitMessage);
        }
    }

    private void executeResponseInterceptors(IntuitMessage intuitMessage) throws FMSException {
        for (Interceptor interceptor : this.responseInterceptors) {
            interceptor.execute(intuitMessage);
        }
    }
}

