/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.interceptors;

import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.interceptors.HTTPBatchClientConnectionInterceptor;
import com.intuit.ipp.interceptors.HTTPClientConnectionInterceptor;
import com.intuit.ipp.interceptors.Interceptor;
import com.intuit.ipp.interceptors.IntuitInterceptorProvider;
import com.intuit.ipp.interceptors.IntuitMessage;
import java.util.List;
import org.slf4j.Logger;

public class IntuitBatchInterceptorProvider
extends IntuitInterceptorProvider
implements Interceptor {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();

    public IntuitBatchInterceptorProvider() {
        this.swapRequestInterceptor(HTTPClientConnectionInterceptor.class, this);
    }

    private void swapRequestInterceptor(Class<? extends Interceptor> target, Interceptor interceptor) {
        List<Interceptor> list = this.getRequestInterceptors();
        for (Interceptor object : list) {
            if (object.getClass() != target) continue;
            list.set(list.indexOf(object), interceptor);
        }
        this.setRequestInterceptors(list);
    }

    public void executeInterceptors(List<IntuitMessage> intuitMessages) throws FMSException {
        for (IntuitMessage message : intuitMessages) {
            this.executeRequestInterceptors(message);
        }
        HTTPBatchClientConnectionInterceptor batchConnectionInterceptor = new HTTPBatchClientConnectionInterceptor();
        batchConnectionInterceptor.execute(intuitMessages);
        for (IntuitMessage message : intuitMessages) {
            try {
                message.getResponseElements().getResponseContent().reset();
            }
            catch (Exception ex) {
                LOG.error("IllegalStateException while get the content from HttpRespose.", (Throwable)ex);
                throw new FMSException(ex);
            }
            this.executeResponseInterceptors(message);
        }
    }

    @Override
    public void execute(IntuitMessage intuitMessage) throws FMSException {
    }
}

