/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.interceptors;

import com.intuit.ipp.core.Context;
import com.intuit.ipp.exception.CompressionException;
import com.intuit.ipp.exception.ConfigurationException;
import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.interceptors.Interceptor;
import com.intuit.ipp.interceptors.IntuitMessage;
import com.intuit.ipp.interceptors.RequestElements;
import com.intuit.ipp.interceptors.ResponseElements;
import com.intuit.ipp.net.IntuitRetryPolicyHandler;
import com.intuit.ipp.net.MethodType;
import com.intuit.ipp.util.Config;
import com.intuit.ipp.util.PropertyHelper;
import com.intuit.ipp.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;

public class HTTPClientConnectionInterceptor
implements Interceptor {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final int LENGTH_256 = 256;

    @Override
    public void execute(IntuitMessage intuitMessage) throws FMSException {
        LOG.debug("Enter HTTPClientConnectionInterceptor...");
        RequestElements intuitRequest = intuitMessage.getRequestElements();
        IntuitRetryPolicyHandler handler = this.getRetryHandler();
        HttpClientBuilder hcBuilder = HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)handler).setDefaultRequestConfig(this.setTimeout(intuitRequest.getContext())).setDefaultCredentialsProvider(this.setProxyAuthentication()).setSSLSocketFactory((LayeredConnectionSocketFactory)this.prepareClientSSL());
        HttpHost proxy = this.getProxy();
        if (proxy != null) {
            hcBuilder.setProxy(proxy);
        }
        CloseableHttpClient client = hcBuilder.build();
        HttpGet httpRequest = null;
        URI uri = null;
        try {
            uri = new URI(intuitRequest.getRequestParameters().get("uri"));
        }
        catch (URISyntaxException e) {
            throw new FMSException("URISyntaxException", e);
        }
        String methodtype = intuitRequest.getRequestParameters().get("method_type");
        if (methodtype.equals(MethodType.GET.toString())) {
            httpRequest = new HttpGet(uri);
        } else if (methodtype.equals(MethodType.POST.toString())) {
            httpRequest = new HttpPost(uri);
            byte[] compressedData = intuitRequest.getCompressedData();
            if (compressedData != null) {
                ByteArrayInputStream is = new ByteArrayInputStream(compressedData);
                InputStreamEntity entity = new InputStreamEntity((InputStream)is, (long)compressedData.length);
                ((HttpPost)httpRequest).setEntity((HttpEntity)entity);
            } else if (null != intuitRequest.getPostString()) {
                StringEntity entity;
                try {
                    entity = new StringEntity(intuitRequest.getPostString());
                }
                catch (UnsupportedEncodingException e) {
                    throw new FMSException("UnsupportedEncodingException", e);
                }
                ((HttpPost)httpRequest).setEntity((HttpEntity)entity);
            }
        }
        this.populateRequestHeaders((HttpRequestBase)httpRequest, intuitRequest.getRequestHeaders());
        this.authorizeRequest(intuitRequest.getContext(), (HttpRequestBase)httpRequest);
        LOG.debug("Request URI : " + uri);
        LOG.debug("Http Method : " + methodtype);
        LOG.debug("Request Body : " + intuitRequest.getSerializedData());
        CloseableHttpResponse httpResponse = null;
        try {
            HttpHost target = new HttpHost(uri.getHost(), -1, uri.getScheme());
            httpResponse = client.execute(target, (HttpRequest)httpRequest);
            LOG.debug("Connection status : " + httpResponse.getStatusLine());
            this.setResponseElements(intuitMessage, (HttpResponse)httpResponse);
        }
        catch (ClientProtocolException e) {
            throw new ConfigurationException("Error in Http Protocol definition", e);
        }
        catch (IOException e) {
            throw new FMSException(e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    LOG.warn("Unable to close CloseableHttpResponse .", (Throwable)e);
                }
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (Exception e) {
                    LOG.warn("Unable to close CloseableHttpClient connection.", (Throwable)e);
                }
            }
        }
        LOG.debug("Exit HTTPClientConnectionInterceptor.");
    }

    private void populateRequestHeaders(HttpRequestBase httpRequest, Map<String, String> requestHeaders) {
        Set<String> keySet = requestHeaders.keySet();
        for (String key : keySet) {
            String value = requestHeaders.get(key);
            httpRequest.addHeader(key, value);
        }
        PropertyHelper propertyHelper = PropertyHelper.getInstance();
        String requestSource = propertyHelper.getRequestSource() + propertyHelper.getVersion();
        if (propertyHelper.getRequestSourceHeader() != null) {
            httpRequest.addHeader(propertyHelper.getRequestSourceHeader(), requestSource);
        }
    }

    private void authorizeRequest(Context context, HttpRequestBase httpRequest) throws FMSException {
        context.getAuthorizer().authorize(httpRequest);
    }

    private IntuitRetryPolicyHandler getRetryHandler() throws FMSException {
        IntuitRetryPolicyHandler handler = null;
        String policy = Config.getProperty("retry.mode");
        if (policy.equalsIgnoreCase("fixed")) {
            String retryCountStr = Config.getProperty("retry.fixed.count");
            String retryIntervalStr = Config.getProperty("retry.fixed.interval");
            try {
                handler = new IntuitRetryPolicyHandler(Integer.parseInt(retryCountStr), Integer.parseInt(retryIntervalStr));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(e);
            }
        }
        if (policy.equalsIgnoreCase("incremental")) {
            String retryCountStr = Config.getProperty("retry.incremental.count");
            String retryIntervalStr = Config.getProperty("retry.incremental.interval");
            String retryIncrementStr = Config.getProperty("retry.incremental.increment");
            try {
                handler = new IntuitRetryPolicyHandler(Integer.parseInt(retryCountStr), Integer.parseInt(retryIntervalStr), Integer.parseInt(retryIncrementStr));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(e);
            }
        }
        if (policy.equalsIgnoreCase("exponential")) {
            String retryCountStr = Config.getProperty("retry.exponential.count");
            String minBackoffStr = Config.getProperty("retry.exponential.minBackoff");
            String maxBackoffStr = Config.getProperty("retry.exponential.maxBackoff");
            String deltaBackoffStr = Config.getProperty("retry.exponential.deltaBackoff");
            try {
                handler = new IntuitRetryPolicyHandler(Integer.parseInt(retryCountStr), Integer.parseInt(minBackoffStr), Integer.parseInt(maxBackoffStr), Integer.parseInt(deltaBackoffStr));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(e);
            }
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLConnectionSocketFactory prepareClientSSL() {
        try {
            String path = Config.getProperty("proxy.keystore.path");
            String pass = Config.getProperty("proxy.keystore.password");
            KeyStore trustStore = null;
            if (path != null && pass != null) {
                trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                try (FileInputStream instream = new FileInputStream(new File(path));){
                    trustStore.load(instream, pass.toCharArray());
                }
            }
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            String tlsVersion = Config.getProperty("tls.version");
            SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, new String[]{tlsVersion}, null, (HostnameVerifier)new NoopHostnameVerifier());
            return sslConnectionFactory;
        }
        catch (Exception ex) {
            LOG.error("couldn't create httpClient!! {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    public HttpHost getProxy() {
        String host = Config.getProperty("proxy.host");
        String port = Config.getProperty("proxy.port");
        HttpHost proxy = null;
        if (StringUtils.hasText(host) && StringUtils.hasText(port)) {
            proxy = new HttpHost(host, Integer.parseInt(port));
        }
        return proxy;
    }

    public CredentialsProvider setProxyAuthentication() {
        String username = Config.getProperty("proxy.username");
        String password = Config.getProperty("proxy.password");
        if (StringUtils.hasText(username) && StringUtils.hasText(password)) {
            String host = Config.getProperty("proxy.host");
            String port = Config.getProperty("proxy.port");
            if (StringUtils.hasText(host) && StringUtils.hasText(port)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                String domain = Config.getProperty("proxy.domain");
                if (StringUtils.hasText(domain)) {
                    credentialsProvider.setCredentials(new AuthScope(host, Integer.parseInt(port)), (Credentials)new NTCredentials(username, password, host, domain));
                } else {
                    credentialsProvider.setCredentials(new AuthScope(host, Integer.parseInt(port)), (Credentials)new UsernamePasswordCredentials(username, password));
                }
                return credentialsProvider;
            }
        }
        return null;
    }

    private void setResponseElements(IntuitMessage intuitMessage, HttpResponse httpResponse) throws FMSException {
        ResponseElements responseElements = intuitMessage.getResponseElements();
        if (httpResponse.getLastHeader("Content-Encoding") != null) {
            responseElements.setEncodingHeader(httpResponse.getLastHeader("Content-Encoding").getValue());
        } else {
            responseElements.setEncodingHeader(null);
        }
        if (httpResponse.getLastHeader("content-type") != null) {
            responseElements.setContentTypeHeader(httpResponse.getLastHeader("content-type").getValue());
        } else {
            responseElements.setContentTypeHeader(null);
        }
        responseElements.setStatusLine(httpResponse.getStatusLine());
        responseElements.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        try {
            responseElements.setResponseContent(this.getCopyOfResponseContent(httpResponse.getEntity().getContent()));
        }
        catch (IllegalStateException e) {
            LOG.error("IllegalStateException while get the content from HttpRespose.", (Throwable)e);
            throw new FMSException(e);
        }
        catch (Exception e) {
            LOG.error("IOException in HTTPClientConnectionInterceptor while reading the entity from HttpResponse.", (Throwable)e);
            throw new FMSException(e);
        }
    }

    private InputStream getCopyOfResponseContent(InputStream is) throws FMSException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream copyIs = null;
        try {
            int r;
            byte[] bbuf = new byte[256];
            while ((r = is.read(bbuf)) >= 0) {
                baos.write(bbuf, 0, r);
            }
            ByteArrayInputStream byteArrayInputStream = copyIs = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException ioe) {
            LOG.error("IOException while decompress the data using GZIP compression.", (Throwable)ioe);
            throw new CompressionException(ioe);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    LOG.error("Unable to close ByteArrayOutputStream.");
                }
            }
        }
    }

    private RequestConfig setTimeout(Context context) {
        int socketTimeout = 0;
        int connectionTimeout = 0;
        if (context.getCustomerRequestTimeout() != null) {
            socketTimeout = context.getCustomerRequestTimeout();
        } else {
            String reqTimeout = Config.getProperty("timeout.requestTimeout");
            if (StringUtils.hasText(reqTimeout)) {
                socketTimeout = new Integer(reqTimeout.trim());
            }
        }
        String connTimeout = Config.getProperty("timeout.connectionTimeout");
        if (StringUtils.hasText(connTimeout)) {
            connectionTimeout = new Integer(connTimeout.trim());
        }
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(connectionTimeout).setCookieSpec("ignoreCookies").build();
        return defaultRequestConfig;
    }
}

