/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.interceptors;

import com.intuit.ipp.core.IEntity;
import com.intuit.ipp.core.Response;
import com.intuit.ipp.data.BatchItemResponse;
import com.intuit.ipp.data.CDCResponse;
import com.intuit.ipp.data.Fault;
import com.intuit.ipp.data.IntuitResponse;
import com.intuit.ipp.data.QueryResponse;
import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.interceptors.Interceptor;
import com.intuit.ipp.interceptors.IntuitMessage;
import com.intuit.ipp.net.ContentTypes;
import com.intuit.ipp.net.OperationType;
import com.intuit.ipp.services.BatchOperation;
import com.intuit.ipp.services.CDCQueryResult;
import com.intuit.ipp.services.CallbackMessage;
import com.intuit.ipp.services.QueryResult;
import com.intuit.ipp.util.StringUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;

public class CallbackHandlerInterceptor
implements Interceptor {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();

    @Override
    public void execute(IntuitMessage intuitMessage) throws FMSException {
        LOG.debug("Enter CallbackHandlerInterceptor...");
        CallbackMessage callbackMessage = intuitMessage.getResponseElements().getCallbackMessage();
        Response response = intuitMessage.getResponseElements().getResponse();
        if (response != null) {
            List batchItemResponses;
            List attachableResponses;
            List cdcResponses;
            QueryResponse queryResponse;
            IntuitResponse intuitResponse = (IntuitResponse)response;
            JAXBElement intuitObject = intuitResponse.getIntuitObject();
            if (intuitObject != null) {
                LOG.debug("CallbackHandlerInterceptor setting IntuitObject...");
                callbackMessage.setEntity((IEntity)intuitObject.getValue());
            }
            if ((queryResponse = intuitResponse.getQueryResponse()) != null) {
                LOG.debug("CallbackHandlerInterceptor setting QueryResponse...");
                QueryResult queryResult = this.getQueryResult(queryResponse);
                callbackMessage.setQueryResult(queryResult);
            }
            if ((cdcResponses = intuitResponse.getCDCResponse()) != null) {
                LOG.debug("CallbackHandlerInterceptor setting CDCQueryResponse...");
                List<CDCQueryResult> cdcQueryResults = this.getCDCQueryResult(cdcResponses);
                callbackMessage.setCDCQueryResults(cdcQueryResults);
            }
            if ((attachableResponses = intuitResponse.getAttachableResponse()) != null) {
                LOG.debug("CallbackHandlerInterceptor setting AttachableResponse...");
                callbackMessage.setAttachableResponse(attachableResponses);
            }
            if ((batchItemResponses = intuitResponse.getBatchItemResponse()) != null && !batchItemResponses.isEmpty()) {
                LOG.debug("CallbackHandlerInterceptor setting BatchItemResponse...");
                BatchOperation batchOperation = intuitMessage.getRequestElements().getBatchOperation();
                int count = 0;
                for (BatchItemResponse batchItemResponse : batchItemResponses) {
                    String bId = batchItemResponse.getBId();
                    if (!StringUtils.hasText(bId)) {
                        bId = batchOperation.getBatchItemRequests().get(count).getBId();
                    }
                    if (batchItemResponse.getFault() != null) {
                        batchOperation.getFaultResult().put(bId, batchItemResponse.getFault());
                    } else if (batchItemResponse.getReport() != null) {
                        batchOperation.getReportResult().put(bId, batchItemResponse.getReport());
                    } else if (batchItemResponse.getIntuitObject() != null) {
                        batchOperation.getEntityResult().put(bId, (IEntity)batchItemResponse.getIntuitObject().getValue());
                    } else if (batchItemResponse.getQueryResponse() != null) {
                        QueryResult queryResult = this.getQueryResult(batchItemResponse.getQueryResponse());
                        batchOperation.getQueryResult().put(bId, queryResult);
                    } else if (batchItemResponse.getCDCResponse() != null) {
                        CDCQueryResult cdcQueryResult = this.getCDCQueryResult(batchItemResponse.getCDCResponse());
                        batchOperation.getCDCQueryResult().put(bId, cdcQueryResult);
                    } else {
                        LOG.warn("BatchItemResponse is not Fault, Entity, Query and Report.");
                    }
                    ++count;
                }
                callbackMessage.setBatchOperation(batchOperation);
            }
        } else if (this.isDownload(intuitMessage.getRequestElements().getAction())) {
            LOG.debug("CallbackHandlerInterceptor setting downloadedFile...");
            callbackMessage.setDownloadedFile(this.getDownloadedFile(intuitMessage.getResponseElements().getDecompressedData()));
        } else if (this.isDownloadPDF(intuitMessage.getRequestElements().getRequestParameters())) {
            LOG.debug("CallbackHandlerInterceptor setting binary content for PDF...");
            callbackMessage.setDownloadedFile(intuitMessage.getResponseElements().getResponseBytes());
        }
        intuitMessage.getRequestElements().getCallbackHandler().execute(callbackMessage);
        LOG.debug("Exit CallbackHandlerInterceptor.");
    }

    private <T extends IEntity> List<T> getEntities(QueryResponse queryResponse) {
        ArrayList<IEntity> entityList = new ArrayList<IEntity>();
        List intuitObjectsList = queryResponse.getIntuitObject();
        if (intuitObjectsList != null && !intuitObjectsList.isEmpty()) {
            for (JAXBElement intuitObject : intuitObjectsList) {
                entityList.add((IEntity)intuitObject.getValue());
            }
        }
        return entityList;
    }

    private QueryResult getQueryResult(QueryResponse queryResponse) {
        QueryResult queryResult = null;
        if (queryResponse != null) {
            queryResult = new QueryResult();
            queryResult.setEntities(this.getEntities(queryResponse));
            queryResult.setFault(queryResponse.getFault());
            queryResult.setMaxResults(queryResponse.getMaxResults());
            queryResult.setStartPosition(queryResponse.getStartPosition());
            queryResult.setTotalCount(queryResponse.getTotalCount());
        }
        return queryResult;
    }

    private List<CDCQueryResult> getCDCQueryResult(List<CDCResponse> cdcResponses) {
        ArrayList<CDCQueryResult> cdcQueryResults = null;
        if (cdcResponses != null) {
            Iterator<CDCResponse> cdcResponseItr = cdcResponses.iterator();
            while (cdcResponseItr.hasNext()) {
                cdcQueryResults = new ArrayList<CDCQueryResult>();
                CDCQueryResult cdcQueryResult = this.getCDCQueryResult(cdcResponseItr.next());
                cdcQueryResults.add(cdcQueryResult);
            }
        }
        return cdcQueryResults;
    }

    private CDCQueryResult getCDCQueryResult(CDCResponse cdcResponse) {
        CDCQueryResult cdcQueryResult = new CDCQueryResult();
        List queryResponses = cdcResponse.getQueryResponse();
        if (queryResponses != null) {
            HashMap<String, QueryResult> queryResults = new HashMap<String, QueryResult>();
            for (QueryResponse queryResponse : queryResponses) {
                QueryResult queryResult = this.getQueryResult(queryResponse);
                this.populateQueryResultsInCDC(queryResults, queryResult);
                this.populateFaultInCDC(cdcQueryResult, queryResult);
            }
            if (queryResults != null && !queryResults.isEmpty()) {
                cdcQueryResult.setQueryResults(queryResults);
                cdcQueryResult.setSize(cdcResponse.getSize());
            }
        } else if (cdcResponse.getFault() != null) {
            cdcQueryResult.setFalut(cdcResponse.getFault());
        }
        return cdcQueryResult;
    }

    private void populateQueryResultsInCDC(Map<String, QueryResult> queryResults, QueryResult queryResult) {
        List<? extends IEntity> entities;
        if (queryResult != null && (entities = queryResult.getEntities()) != null && !entities.isEmpty()) {
            IEntity entity = entities.get(0);
            String entityName = entity.getClass().getSimpleName();
            queryResults.put(entityName, queryResult);
        }
    }

    private void populateFaultInCDC(CDCQueryResult cdcQueryResult, QueryResult queryResult) {
        Fault fault;
        if (queryResult != null && (fault = queryResult.getFault()) != null) {
            cdcQueryResult.setFalut(fault);
        }
    }

    private boolean isDownload(String action) {
        return StringUtils.hasText(action) && action.equals(OperationType.DOWNLOAD.toString());
    }

    private boolean isDownloadPDF(Map<String, String> requestHeaders) {
        return StringUtils.hasText(requestHeaders.get("selector")) && requestHeaders.get("selector").equalsIgnoreCase(ContentTypes.PDF.name());
    }

    private InputStream getDownloadedFile(String response) throws FMSException {
        if (response != null) {
            try {
                URL url = new URL(response);
                return url.openStream();
            }
            catch (Exception e) {
                throw new FMSException("Exception while downloading the file from URL.", e);
            }
        }
        return null;
    }
}

