/*
 * The MIT License
 *
 * Copyright 2019 Intuit Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.intuit.karate.driver;

/**
 *
 * @author pthomas3
 */
public class Key {

    public static final Key INSTANCE = new Key();

    public final char NULL = Keys.NULL;
    public final char CANCEL = Keys.CANCEL;
    public final char HELP = Keys.HELP;
    public final char BACK_SPACE = Keys.BACK_SPACE;
    public final char TAB = Keys.TAB;
    public final char CLEAR = Keys.CLEAR;
    public final char RETURN = Keys.RETURN;
    public final char ENTER = Keys.ENTER;
    public final char SHIFT = Keys.SHIFT;
    public final char CONTROL = Keys.CONTROL;
    public final char ALT = Keys.ALT;
    public final char PAUSE = Keys.PAUSE;
    public final char ESCAPE = Keys.ESCAPE;
    public final char SPACE = Keys.SPACE;
    public final char PAGE_UP = Keys.PAGE_UP;
    public final char PAGE_DOWN = Keys.PAGE_DOWN;
    public final char END = Keys.END;
    public final char HOME = Keys.HOME;
    public final char LEFT = Keys.LEFT;
    public final char UP = Keys.UP;
    public final char RIGHT = Keys.RIGHT;
    public final char DOWN = Keys.DOWN;
    public final char INSERT = Keys.INSERT;
    public final char DELETE = Keys.DELETE;
    public final char SEMICOLON = Keys.SEMICOLON;
    public final char EQUALS = Keys.EQUALS;

    // numpad keys
    public final char NUMPAD0 = Keys.NUMPAD0;
    public final char NUMPAD1 = Keys.NUMPAD1;
    public final char NUMPAD2 = Keys.NUMPAD2;
    public final char NUMPAD3 = Keys.NUMPAD3;
    public final char NUMPAD4 = Keys.NUMPAD4;
    public final char NUMPAD5 = Keys.NUMPAD5;
    public final char NUMPAD6 = Keys.NUMPAD6;
    public final char NUMPAD7 = Keys.NUMPAD7;
    public final char NUMPAD8 = Keys.NUMPAD8;
    public final char NUMPAD9 = Keys.NUMPAD9;
    public final char MULTIPLY = Keys.MULTIPLY;
    public final char ADD = Keys.ADD;
    public final char SEPARATOR = Keys.SEPARATOR;
    public final char SUBTRACT = Keys.SUBTRACT;
    public final char DECIMAL = Keys.DECIMAL;
    public final char DIVIDE = Keys.DIVIDE;

    // function keys
    public final char F1 = Keys.F1;
    public final char F2 = Keys.F2;
    public final char F3 = Keys.F3;
    public final char F4 = Keys.F4;
    public final char F5 = Keys.F5;
    public final char F6 = Keys.F6;
    public final char F7 = Keys.F7;
    public final char F8 = Keys.F8;
    public final char F9 = Keys.F9;
    public final char F10 = Keys.F10;
    public final char F11 = Keys.F11;
    public final char F12 = Keys.F12;
    public final char META = Keys.META;
    
}
