/*
 * Decompiled with CFR 0.152.
 */
package io.netty.karate.handler.codec.base64;

import io.netty.karate.buffer.ByteBuf;
import io.netty.karate.channel.ChannelHandler;
import io.netty.karate.channel.ChannelHandlerContext;
import io.netty.karate.handler.codec.MessageToMessageEncoder;
import io.netty.karate.handler.codec.base64.Base64;
import io.netty.karate.handler.codec.base64.Base64Dialect;
import io.netty.karate.util.internal.ObjectUtil;
import java.util.List;

@ChannelHandler.Sharable
public class Base64Encoder
extends MessageToMessageEncoder<ByteBuf> {
    private final boolean breakLines;
    private final Base64Dialect dialect;

    public Base64Encoder() {
        this(true);
    }

    public Base64Encoder(boolean breakLines) {
        this(breakLines, Base64Dialect.STANDARD);
    }

    public Base64Encoder(boolean breakLines, Base64Dialect dialect) {
        this.dialect = ObjectUtil.checkNotNull(dialect, "dialect");
        this.breakLines = breakLines;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(Base64.encode(msg, msg.readerIndex(), msg.readableBytes(), this.breakLines, this.dialect));
    }
}

