/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.netty;

import com.intuit.karate.StringUtils;
import com.intuit.karate.core.FeaturesBackend;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.MultiValuedMap;
import com.intuit.karate.netty.NettyUtils;
import io.netty.karate.buffer.ByteBuf;
import io.netty.karate.buffer.Unpooled;
import io.netty.karate.channel.ChannelFutureListener;
import io.netty.karate.channel.ChannelHandlerContext;
import io.netty.karate.channel.SimpleChannelInboundHandler;
import io.netty.karate.handler.codec.http.DefaultFullHttpResponse;
import io.netty.karate.handler.codec.http.FullHttpRequest;
import io.netty.karate.handler.codec.http.FullHttpResponse;
import io.netty.karate.handler.codec.http.HttpHeaderNames;
import io.netty.karate.handler.codec.http.HttpHeaderValues;
import io.netty.karate.handler.codec.http.HttpHeaders;
import io.netty.karate.handler.codec.http.HttpMethod;
import io.netty.karate.handler.codec.http.HttpResponseStatus;
import io.netty.karate.handler.codec.http.HttpVersion;
import io.netty.karate.handler.codec.http.QueryStringDecoder;
import io.netty.karate.handler.ssl.SslContext;
import io.netty.karate.handler.ssl.SslHandler;
import io.netty.karate.util.CharsetUtil;
import io.netty.karate.util.concurrent.Future;
import io.netty.karate.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.MDC;

public class FeatureServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final FeaturesBackend backend;
    private final Runnable stopFunction;
    private final boolean ssl;
    private final Supplier<SslContext> contextSupplier;
    private static final String STOP_URI = "/__admin/stop";

    public FeatureServerHandler(FeaturesBackend backend, boolean ssl, Supplier<SslContext> contextSupplier, Runnable stopFunction) {
        this.backend = backend;
        this.ssl = ssl;
        this.contextSupplier = contextSupplier;
        this.stopFunction = stopFunction;
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) {
        DefaultFullHttpResponse nettyResponse;
        long startTime = System.currentTimeMillis();
        String requestId = System.identityHashCode(msg) + "";
        MDC.put((String)"karateRequestId", (String)requestId);
        this.backend.getContext().logger.debug("handling method: {}, uri: {}", msg.method(), msg.uri());
        long delay = 0L;
        if (msg.uri().startsWith(STOP_URI)) {
            this.backend.getContext().logger.info("stop uri invoked, shutting down", new Object[0]);
            ByteBuf responseBuf = Unpooled.copiedBuffer("stopped", CharsetUtil.UTF_8);
            nettyResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, responseBuf);
            this.stopFunction.run();
        } else {
            if (HttpMethod.CONNECT.equals(msg.method())) {
                SslContext sslContext = this.contextSupplier.get();
                SslHandler sslHandler = sslContext.newHandler(ctx.alloc());
                FullHttpResponse response = NettyUtils.connectionEstablished();
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                ctx.writeAndFlush(response).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)l -> ctx.channel().pipeline().addFirst(sslHandler)));
                return;
            }
            StringUtils.Pair url = NettyUtils.parseUriIntoUrlBaseAndPath(msg.uri());
            HttpRequest request = new HttpRequest();
            if (url.left == null) {
                String requestScheme = this.ssl ? "https" : "http";
                String host = msg.headers().get(HttpHeaderNames.HOST);
                request.setUrlBase(requestScheme + "://" + host);
            } else {
                request.setUrlBase(url.left);
            }
            request.setUri(url.right);
            request.setMethod(msg.method().name());
            request.setRequestId(requestId);
            msg.headers().forEach(h -> request.addHeader((String)h.getKey(), (String)h.getValue()));
            QueryStringDecoder decoder = new QueryStringDecoder(url.right);
            decoder.parameters().forEach((k, v) -> request.putParam((String)k, (List<String>)v));
            FullHttpRequest httpContent = msg;
            ByteBuf content = httpContent.content();
            if (content.isReadable()) {
                byte[] bytes = new byte[content.readableBytes()];
                content.readBytes(bytes);
                request.setBody(bytes);
            }
            HttpResponse response = this.backend.buildResponse(request, startTime);
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.valueOf(response.getStatus());
            byte[] responseBody = response.getBody();
            if (responseBody != null) {
                ByteBuf responseBuf = Unpooled.copiedBuffer(responseBody);
                nettyResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, httpResponseStatus, responseBuf);
            } else {
                nettyResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, httpResponseStatus);
            }
            MultiValuedMap karateHeaders = response.getHeaders();
            if (karateHeaders != null) {
                HttpHeaders nettyHeaders = nettyResponse.headers();
                karateHeaders.forEach((k, v) -> nettyHeaders.add((String)k, (Iterable<?>)v));
            }
            if (response.getDelay() != 0L) {
                delay = response.getDelay() - response.getResponseTime();
            }
        }
        ctx.executor().schedule(() -> {
            ctx.write(nettyResponse);
            ctx.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }, delay, TimeUnit.MILLISECONDS).addListener(future -> this.backend.getContext().logger.debug("response {} written after {} milliseconds", future.isSuccess() ? "successfully" : "not", System.currentTimeMillis() - startTime));
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause.getMessage() == null) {
            cause.printStackTrace();
        } else {
            this.backend.getContext().logger.error("closing connection: {}", cause.getMessage());
        }
        ctx.close();
    }
}

