/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.job;

import com.intuit.karate.job.JobCommand;
import com.intuit.karate.job.JobContext;
import com.intuit.karate.job.MavenJobConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MavenChromeJobConfig
extends MavenJobConfig {
    private int width = 1280;
    private int height = 720;

    public MavenChromeJobConfig(int executorCount, String host, int port) {
        super(executorCount, host, port);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public String getExecutorCommand(String jobId, String jobUrl, int index) {
        return "docker run --rm --cap-add=SYS_ADMIN -e KARATE_JOBURL=" + jobUrl + " -e KARATE_WIDTH=" + this.width + " -e KARATE_HEIGHT=" + this.height + " " + this.dockerImage;
    }

    @Override
    public List<JobCommand> getPreCommands(JobContext jc) {
        return Collections.singletonList(new JobCommand("supervisorctl start ffmpeg"));
    }

    @Override
    public List<JobCommand> getPostCommands(JobContext jc) {
        ArrayList<JobCommand> list = new ArrayList<JobCommand>();
        list.add(new JobCommand("supervisorctl stop ffmpeg"));
        list.add(new JobCommand("mv /tmp/karate.mp4 " + jc.getUploadDir()));
        return list;
    }
}

