/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.job;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.job.JobMessage;
import com.intuit.karate.job.JobServer;
import com.jayway.jsonpath.Predicate;
import io.netty.karate.buffer.ByteBuf;
import io.netty.karate.buffer.Unpooled;
import io.netty.karate.channel.ChannelFutureListener;
import io.netty.karate.channel.ChannelHandlerContext;
import io.netty.karate.channel.SimpleChannelInboundHandler;
import io.netty.karate.handler.codec.http.DefaultFullHttpResponse;
import io.netty.karate.handler.codec.http.FullHttpRequest;
import io.netty.karate.handler.codec.http.HttpHeaderNames;
import io.netty.karate.handler.codec.http.HttpMethod;
import io.netty.karate.handler.codec.http.HttpResponseStatus;
import io.netty.karate.handler.codec.http.HttpVersion;
import io.netty.karate.util.CharsetUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    protected static final Logger logger = LoggerFactory.getLogger(JobServerHandler.class);
    protected final JobServer server;

    public JobServerHandler(JobServer server) {
        this.server = server;
    }

    private static DefaultFullHttpResponse response(String message) {
        ByteBuf responseBuf = Unpooled.copiedBuffer(message, CharsetUtil.UTF_8);
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, responseBuf);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        DefaultFullHttpResponse response;
        if (!HttpMethod.POST.equals(msg.method())) {
            logger.warn("ignoring non-POST request: {}", (Object)msg);
            response = JobServerHandler.response(msg.method() + " not supported\n");
        } else {
            String method = StringUtils.trimToNull(msg.headers().get("karate-method"));
            String executorId = StringUtils.trimToNull(msg.headers().get("karate-executor-id"));
            String chunkId = StringUtils.trimToNull(msg.headers().get("karate-chunk-id"));
            String contentType = StringUtils.trimToNull(msg.headers().get(HttpHeaderNames.CONTENT_TYPE));
            if (method == null) {
                response = JobServerHandler.response("karate-method header is null\n");
            } else {
                JobMessage req;
                byte[] bytes;
                FullHttpRequest httpContent = msg;
                ByteBuf content = httpContent.content();
                if (content.isReadable()) {
                    bytes = new byte[content.readableBytes()];
                    content.readBytes(bytes);
                } else {
                    bytes = null;
                }
                if (contentType.contains("octet-stream")) {
                    if (chunkId == null) {
                        logger.warn("chunk id is null for binary upload from executor");
                    }
                    req = new JobMessage(method);
                    req.setBytes(bytes);
                } else {
                    String json = FileUtils.toString(bytes);
                    Map map = (Map)JsonUtils.toJsonDoc(json).read("$", new Predicate[0]);
                    req = new JobMessage(method, map);
                }
                req.setExecutorId(executorId);
                req.setChunkId(chunkId);
                logger.debug("<< {}", (Object)req);
                JobMessage res = this.handle(req);
                logger.debug(">> {}", (Object)res);
                if (res == null) {
                    response = JobServerHandler.response("unable to create response for: " + req + "\n");
                } else {
                    boolean binary;
                    bytes = res.getBytes();
                    if (bytes == null) {
                        binary = false;
                        String json = JsonUtils.toJson(res.body);
                        bytes = FileUtils.toBytes(json);
                    } else {
                        binary = true;
                    }
                    ByteBuf responseBuf = Unpooled.copiedBuffer(bytes);
                    response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, responseBuf);
                    response.headers().add("karate-method", (Object)res.method);
                    response.headers().add("karate-job-id", (Object)this.server.jobId);
                    if (res.getExecutorId() != null) {
                        response.headers().add("karate-executor-id", (Object)res.getExecutorId());
                    }
                    if (res.getChunkId() != null) {
                        response.headers().add("karate-chunk-id", (Object)res.getChunkId());
                    }
                    if (binary) {
                        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/octet-stream");
                    } else {
                        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
                    }
                }
            }
        }
        ctx.write(response);
        ctx.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
    }

    protected void dumpLog(JobMessage jm) {
        logger.debug("\n>>>>>>>>>>>>>>>>>>>>> {}\n{}<<<<<<<<<<<<<<<<<<<< {}", new Object[]{jm, jm.get("log", String.class), jm});
    }

    protected abstract JobMessage handle(JobMessage var1);
}

