/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.job;

import com.intuit.karate.FileUtils;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.ScenarioExecutionUnit;
import com.intuit.karate.job.ChunkResult;
import com.intuit.karate.job.JobConfig;
import com.intuit.karate.job.JobUtils;
import com.intuit.karate.job.ScenarioJobServerHandler;
import io.netty.karate.bootstrap.ServerBootstrap;
import io.netty.karate.channel.Channel;
import io.netty.karate.channel.ChannelInitializer;
import io.netty.karate.channel.ChannelPipeline;
import io.netty.karate.channel.EventLoopGroup;
import io.netty.karate.channel.nio.NioEventLoopGroup;
import io.netty.karate.channel.socket.nio.NioServerSocketChannel;
import io.netty.karate.handler.codec.http.HttpObjectAggregator;
import io.netty.karate.handler.codec.http.HttpServerCodec;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobServer {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JobServer.class);
    protected final JobConfig config;
    protected final String basePath;
    protected final File ZIP_FILE;
    protected final String jobId;
    protected final String jobUrl;
    protected final String reportDir;
    protected final AtomicInteger executorCounter = new AtomicInteger(1);
    private final Channel channel;
    private final int port;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;

    public static File getFirstFileWithExtension(File parent, String extension) {
        File[] files = parent.listFiles((f, n) -> n.endsWith("." + extension));
        return files.length == 0 ? null : files[0];
    }

    public void startExecutors() {
        try {
            this.config.startExecutors(this.jobId, this.jobUrl);
        }
        catch (Exception e) {
            LOGGER.error("failed to start executors: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    protected String resolveUploadDir() {
        String temp = this.config.getUploadDir();
        if (temp != null) {
            return temp;
        }
        return this.reportDir;
    }

    public byte[] getDownload() {
        try {
            FileInputStream is = new FileInputStream(this.ZIP_FILE);
            return FileUtils.toBytes(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void addFeature(ExecutionContext var1, List<ScenarioExecutionUnit> var2, Runnable var3);

    public abstract ChunkResult getNextChunk(String var1);

    public abstract void handleUpload(File var1, String var2, String var3);

    protected void handleUpload(byte[] bytes, String executorId, String chunkId) {
        String chunkBasePath = this.basePath + File.separator + executorId + File.separator + chunkId;
        File zipFile = new File(chunkBasePath + ".zip");
        FileUtils.writeToFile(zipFile, bytes);
        File upload = new File(chunkBasePath);
        JobUtils.unzip(zipFile, upload);
        this.handleUpload(upload, executorId, chunkId);
    }

    public int getPort() {
        return this.port;
    }

    public void waitSync() {
        try {
            this.channel.closeFuture().sync();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        LOGGER.info("stop: shutting down");
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        LOGGER.info("stop: shutdown complete");
    }

    public JobServer(JobConfig config, String reportDir) {
        this.config = config;
        this.reportDir = reportDir;
        this.jobId = System.currentTimeMillis() + "";
        this.basePath = FileUtils.getBuildDir() + File.separator + this.jobId;
        this.ZIP_FILE = new File(this.basePath + ".zip");
        JobUtils.zip(new File(config.getSourcePath()), this.ZIP_FILE);
        LOGGER.info("created zip archive: {}", (Object)this.ZIP_FILE);
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(new ChannelInitializer(){

                protected void initChannel(Channel c) {
                    ChannelPipeline p = c.pipeline();
                    p.addLast(new HttpServerCodec(4096, 12288, 8192));
                    p.addLast(new HttpObjectAggregator(0x100000));
                    p.addLast(new ScenarioJobServerHandler(JobServer.this));
                }
            });
            this.channel = b.bind(config.getPort()).sync().channel();
            InetSocketAddress isa = (InetSocketAddress)this.channel.localAddress();
            this.port = isa.getPort();
            this.jobUrl = "http://" + config.getHost() + ":" + this.port;
            LOGGER.info("job server started - {} - {}", (Object)this.jobUrl, (Object)this.jobId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

