/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.job;

import com.intuit.karate.job.JobCommand;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobMessage {
    public static final String KARATE_METHOD = "karate-method";
    public static final String KARATE_JOB_ID = "karate-job-id";
    public static final String KARATE_EXECUTOR_ID = "karate-executor-id";
    public static final String KARATE_CHUNK_ID = "karate-chunk-id";
    public final String method;
    public final Map<String, Object> body;
    private String jobId;
    private String executorId;
    private String chunkId;
    private byte[] bytes;

    public JobMessage(String method) {
        this(method, new HashMap<String, Object>());
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getChunkId() {
        return this.chunkId;
    }

    public void setChunkId(String chunkId) {
        this.chunkId = chunkId;
    }

    public void setExecutorId(String executorId) {
        this.executorId = executorId;
    }

    public String getExecutorId() {
        return this.executorId;
    }

    public boolean is(String method) {
        return this.method.equals(method);
    }

    public JobMessage(String method, Map<String, Object> body) {
        this.method = method;
        this.body = body;
    }

    public <T> T get(String key, Class<T> clazz) {
        return (T)this.body.get(key);
    }

    public JobMessage put(String key, List<JobCommand> commands) {
        if (commands == null) {
            this.body.remove(key);
            return this;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(commands.size());
        for (JobCommand jc : commands) {
            list.add(jc.toMap());
        }
        return this.put(key, list);
    }

    public List<JobCommand> getCommands(String key) {
        List maps = this.get(key, List.class);
        if (maps == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<JobCommand> list = new ArrayList<JobCommand>(maps.size());
        for (Map map : maps) {
            list.add(new JobCommand(map));
        }
        return list;
    }

    public JobMessage put(String key, Object value) {
        this.body.put(key, value);
        return this;
    }

    public JobMessage putBase64(String key, byte[] bytes) {
        String encoded = Base64.getEncoder().encodeToString(bytes);
        return this.put(key, encoded);
    }

    public byte[] getBase64(String key) {
        String encoded = this.get(key, String.class);
        return Base64.getDecoder().decode(encoded);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[method: ").append(this.method);
        if (this.jobId != null) {
            sb.append(", jobId: ").append(this.jobId);
        }
        if (this.executorId != null) {
            sb.append(", executorId: ").append(this.executorId);
        }
        if (this.chunkId != null) {
            sb.append(", chunkId: ").append(this.chunkId);
        }
        if (this.body != null && !this.body.isEmpty()) {
            sb.append(", body: ");
            this.body.forEach((k, v) -> {
                sb.append("[").append((String)k).append(": ");
                if ("log".equals(k)) {
                    sb.append("...");
                } else if (v instanceof String) {
                    String s = (String)v;
                    if (s.length() > 1024) {
                        sb.append("...");
                    } else {
                        sb.append(s);
                    }
                } else {
                    sb.append(v);
                }
                sb.append("]");
            });
        }
        sb.append("]");
        return sb.toString();
    }
}

