/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.Json;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.driver.DevToolsDriver;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevToolsMessage {
    private static final Logger logger = LoggerFactory.getLogger(DevToolsMessage.class);
    protected final DevToolsDriver driver;
    private Integer id;
    private String sessionId;
    private final String method;
    private Map<String, Object> params;
    private Map<String, Object> error;
    private ScriptValue result;
    private Integer timeout;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean methodIs(String method) {
        return method.equals(this.method);
    }

    public <T> T get(String path, Class<T> clazz) {
        if (this.params == null) {
            return null;
        }
        Json json = new Json(this.params);
        try {
            return json.get(path, clazz);
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace("json-path evaluation failed: {}", (Object)e.getMessage());
            }
            return null;
        }
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public ScriptValue getResult() {
        return this.result;
    }

    public <T> T getResult(String path, Class<T> clazz) {
        if (this.result == null) {
            return null;
        }
        Json json = new Json(this.result.getValue());
        return json.get(path, clazz);
    }

    public void setResult(ScriptValue result) {
        this.result = result;
    }

    private static Map<String, Object> toMap(List<Map<String, Object>> list) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (Map<String, Object> map : list) {
            String key = (String)map.get("name");
            Map valMap = (Map)map.get("value");
            res.put(key, valMap == null ? null : (Object)valMap.get("value"));
        }
        return res;
    }

    public boolean isResultError() {
        if (this.error != null) {
            return true;
        }
        if (this.result == null || !this.result.isMapLike()) {
            return false;
        }
        String resultError = (String)this.result.getAsMap().get("subtype");
        return "error".equals(resultError);
    }

    public ScriptValue getResult(String key) {
        if (this.result == null || !this.result.isMapLike()) {
            return null;
        }
        return new ScriptValue(this.result.getAsMap().get(key));
    }

    public ScriptValue getParam(String key) {
        if (this.params == null) {
            return ScriptValue.NULL;
        }
        return new ScriptValue(this.params.get(key));
    }

    public DevToolsMessage(DevToolsDriver driver, String method) {
        this.driver = driver;
        this.id = driver.nextId();
        this.method = method;
        this.sessionId = driver.sessionId;
    }

    public DevToolsMessage(DevToolsDriver driver, Map<String, Object> map) {
        this.driver = driver;
        this.id = (Integer)map.get("id");
        this.method = (String)map.get("method");
        this.params = (Map)map.get("params");
        Map temp = (Map)map.get("result");
        if (temp != null) {
            Map innerMap;
            String subtype;
            Object inner;
            this.result = temp.containsKey("result") ? ((inner = temp.get("result")) instanceof List ? new ScriptValue(DevToolsMessage.toMap((List)inner)) : ("error".equals(subtype = (String)(innerMap = (Map)inner).get("subtype")) || innerMap.containsKey("objectId") ? new ScriptValue(innerMap) : new ScriptValue(innerMap.get("value")))) : new ScriptValue(temp);
        }
        this.error = (Map)map.get("error");
    }

    public DevToolsMessage param(String key, Object value) {
        if (this.params == null) {
            this.params = new LinkedHashMap<String, Object>();
        }
        this.params.put(key, value);
        return this;
    }

    public DevToolsMessage params(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("id", this.id);
        if (this.sessionId != null) {
            map.put("sessionId", this.sessionId);
        }
        map.put("method", this.method);
        if (this.params != null) {
            map.put("params", this.params);
        }
        if (this.result != null) {
            map.put("result", this.result);
        }
        return map;
    }

    public void sendWithoutWaiting() {
        this.driver.send(this);
    }

    public DevToolsMessage send() {
        return this.send(null);
    }

    public DevToolsMessage send(Predicate<DevToolsMessage> condition) {
        return this.driver.sendAndWait(this, condition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[id: ").append(this.id);
        if (this.sessionId != null) {
            sb.append(", sessionId: ").append(this.sessionId);
        }
        if (this.method != null) {
            sb.append(", method: ").append(this.method);
        }
        if (this.params != null) {
            sb.append(", params: ").append(this.params);
        }
        if (this.result != null) {
            sb.append(", result: ").append(this.result);
        }
        if (this.error != null) {
            sb.append(", error: ").append(this.error);
        }
        sb.append("]");
        return sb.toString();
    }
}

