/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.debug;

import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.core.Step;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class StackFrame {
    private final long id;
    private final int line;
    private final int column = 0;
    private final String name;
    private final Map<String, Object> source = new HashMap<String, Object>();

    public StackFrame(long frameId, ScenarioContext context) {
        this.id = frameId;
        Step step = context.getExecutionUnit().getCurrentStep();
        this.line = step.getLine();
        Scenario scenario = context.getExecutionUnit().scenario;
        this.name = scenario.getDisplayMeta();
        Path path = step.getFeature().getPath();
        this.source.put("name", path.getFileName().toString());
        this.source.put("path", path.toString());
        this.source.put("sourceReference", 0);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.id);
        map.put("line", this.line);
        map.put("column", 0);
        map.put("name", this.name);
        map.put("source", this.source);
        return map;
    }
}

