/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.debug;

import com.intuit.karate.Json;
import com.intuit.karate.debug.Breakpoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SourceBreakpoints {
    public final String name;
    public final String path;
    public final List<Breakpoint> breakpoints;
    public final boolean sourceModified;

    public boolean isBreakpoint(int line) {
        if (this.breakpoints == null || this.breakpoints.isEmpty()) {
            return false;
        }
        for (Breakpoint b : this.breakpoints) {
            if (b.line != line) continue;
            return true;
        }
        return false;
    }

    public SourceBreakpoints(Map<String, Object> map) {
        Json json = new Json(map);
        this.name = json.getString("source.name");
        this.path = json.getString("source.path");
        List list = json.getList("breakpoints");
        this.breakpoints = new ArrayList<Breakpoint>(list.size());
        for (Map bm : list) {
            this.breakpoints.add(new Breakpoint(bm));
        }
        this.sourceModified = json.getBoolean("sourceModified");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[name: ").append(this.name);
        sb.append(", path: ").append(this.path);
        sb.append(", breakpoints: ").append(this.breakpoints);
        sb.append(", sourceModified: ").append(this.sourceModified);
        sb.append("]");
        return sb.toString();
    }
}

