/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureSection;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.Table;
import com.intuit.karate.core.Tag;
import com.intuit.karate.core.Tags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Scenario {
    public static final String TYPE = "scenario";
    public static final String KEYWORD = "Scenario";
    private final Feature feature;
    private final FeatureSection section;
    private final int index;
    private List<Tag> tags;
    private int line;
    private String name;
    private String description;
    private List<Step> steps;
    private boolean outline;
    private Map<String, Object> exampleData;
    private int exampleIndex = -1;
    private String dynamicExpression;
    private boolean backgroundDone;
    private Tags tagsEffective;

    protected Scenario() {
        this(null, null, -1);
    }

    public Scenario(Feature feature, FeatureSection section, int index) {
        this.feature = feature;
        this.section = section;
        this.index = index;
    }

    public String getNameAndDescription() {
        String temp = "";
        if (this.name != null) {
            temp = temp + this.name;
        }
        if (this.description != null) {
            if (!temp.isEmpty()) {
                temp = temp + " ";
            }
            temp = temp + this.description;
        }
        return temp;
    }

    public String getNameForReport() {
        if (this.name == null) {
            return this.getDisplayMeta();
        }
        return this.getDisplayMeta() + " " + this.name;
    }

    public Scenario copy(int exampleIndex) {
        Scenario s = new Scenario(this.feature, this.section, exampleIndex);
        s.name = this.name;
        s.description = this.description;
        s.tags = this.tags;
        s.line = this.line;
        s.exampleIndex = exampleIndex;
        s.outline = true;
        s.steps = new ArrayList<Step>(this.steps.size());
        for (Step step : this.steps) {
            Step temp = new Step(this.feature, s, step.getIndex());
            s.steps.add(temp);
            temp.setLine(step.getLine());
            temp.setEndLine(step.getEndLine());
            temp.setPrefix(step.getPrefix());
            temp.setText(step.getText());
            temp.setDocString(step.getDocString());
            temp.setTable(step.getTable());
        }
        return s;
    }

    public void replace(String token, String value) {
        if (value == null) {
            return;
        }
        this.name = this.name.replace(token, value);
        this.description = this.description.replace(token, value);
        for (Step step : this.steps) {
            Table table;
            String text = step.getText();
            step.setText(text.replace(token, value));
            String docString = step.getDocString();
            if (docString != null) {
                step.setDocString(docString.replace(token, value));
            }
            if ((table = step.getTable()) == null) continue;
            step.setTable(table.replace(token, value));
        }
    }

    public Step getStepByLine(int line) {
        for (Step step : this.getStepsIncludingBackground()) {
            if (step.getLine() != line) continue;
            return step;
        }
        return null;
    }

    public String getDisplayMeta() {
        int num = this.section.getIndex() + 1;
        String meta = "[" + num;
        if (this.index != -1) {
            meta = meta + "." + (this.index + 1);
        }
        return meta + ":" + this.line + "]";
    }

    public String getUniqueId() {
        int num = this.section.getIndex() + 1;
        String meta = "-" + num;
        if (this.index != -1) {
            meta = meta + "_" + (this.index + 1);
        }
        return meta;
    }

    public List<Step> getBackgroundSteps() {
        return this.feature.isBackgroundPresent() ? this.feature.getBackground().getSteps() : Collections.EMPTY_LIST;
    }

    public List<Step> getStepsIncludingBackground() {
        List<Step> background = this.feature.isBackgroundPresent() ? this.feature.getBackground().getSteps() : null;
        int count = background == null ? this.steps.size() : this.steps.size() + background.size();
        ArrayList<Step> temp = new ArrayList<Step>(count);
        if (background != null) {
            temp.addAll(background);
        }
        temp.addAll(this.steps);
        return temp;
    }

    public String getKeyword() {
        return this.outline ? "Scenario Outline" : KEYWORD;
    }

    public Tags getTagsEffective() {
        if (this.tagsEffective == null) {
            this.tagsEffective = Tags.merge(this.feature.getTags(), this.tags);
        }
        return this.tagsEffective;
    }

    public FeatureSection getSection() {
        return this.section;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public boolean isOutline() {
        return this.outline;
    }

    public void setOutline(boolean outline) {
        this.outline = outline;
    }

    public boolean isDynamic() {
        return this.dynamicExpression != null;
    }

    public String getDynamicExpression() {
        return this.dynamicExpression;
    }

    public void setDynamicExpression(String dynamicExpression) {
        this.dynamicExpression = dynamicExpression;
    }

    public boolean isBackgroundDone() {
        return this.backgroundDone;
    }

    public void setBackgroundDone(boolean backgroundDone) {
        this.backgroundDone = backgroundDone;
    }

    public Map<String, Object> getExampleData() {
        return this.exampleData;
    }

    public void setExampleData(Map<String, Object> exampleData) {
        this.exampleData = exampleData;
    }

    public int getExampleIndex() {
        return this.exampleIndex;
    }

    public void setExampleIndex(int exampleIndex) {
        this.exampleIndex = exampleIndex;
    }

    public String toString() {
        return this.feature.toString() + this.getDisplayMeta();
    }
}

