/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.HtmlReport;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Tags;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.Element;

public class HtmlTagsReport
extends HtmlReport {
    private final List<FeatureResult> FEATURES = new ArrayList<FeatureResult>();

    public HtmlTagsReport() {
        this.set("/html/head/title", "Karate Tags Report");
        this.setById("nav-type", "Tags");
        this.contentContainer.appendChild(this.div("page-heading alert alert-primary", this.summaryLink()));
    }

    public void addFeatureResult(FeatureResult result) {
        this.FEATURES.add(result);
    }

    public File save(String targetDir) {
        TreeSet<String> allTags = new TreeSet<String>();
        TreeSet<String> failedTags = new TreeSet<String>();
        HashMap featureTagsMap = new HashMap();
        for (FeatureResult fr : this.FEATURES) {
            HashSet<String> featureTags = new HashSet<String>();
            featureTagsMap.put(fr.getPackageQualifiedName(), featureTags);
            for (ScenarioResult sr : fr.getScenarioResults()) {
                Tags tags = sr.getScenario().getTagsEffective();
                Collection<String> tagKeys = tags.getTagKeys();
                allTags.addAll(tagKeys);
                featureTags.addAll(tagKeys);
                if (!sr.isFailed()) continue;
                failedTags.addAll(tagKeys);
            }
        }
        this.setById("nav-pass", allTags.size() - failedTags.size() + "");
        this.setById("nav-fail", failedTags.size() + "");
        Element table = this.node("table", "tags-table table table-sm table-bordered");
        this.contentContainer.appendChild(table);
        Element thead = this.node("thead", null);
        table.appendChild(thead);
        Element headRow = this.node("tr", null);
        thead.appendChild(headRow);
        headRow.appendChild(this.th("Feature", "feature-cell"));
        for (String tagKey : allTags) {
            String tagClass = failedTags.contains(tagKey) ? "failed" : "passed";
            headRow.appendChild(this.th(tagKey, tagClass));
        }
        Element tbody = this.node("tbody", null);
        table.appendChild(tbody);
        for (FeatureResult fr : this.FEATURES) {
            Element tr = this.node("tr", null);
            tbody.appendChild(tr);
            Element featureCell = this.node("td", "feature-cell");
            tr.appendChild(featureCell);
            Element featureLink = this.node("a", "");
            featureCell.appendChild(featureLink);
            featureLink.setAttribute("href", HtmlTagsReport.getHtmlFileName(fr));
            featureLink.setTextContent(fr.getDisplayUri());
            Set featureTags = (Set)featureTagsMap.get(fr.getPackageQualifiedName());
            for (String tagKey : allTags) {
                String tagClass = fr.isFailed() ? "failed" : "passed";
                Element td = featureTags.contains(tagKey) ? this.td("X", tagClass) : this.td("", null);
                tr.appendChild(td);
            }
        }
        return this.saveHtmlToFile(targetDir, "karate-tags.html");
    }
}

