/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.CallContext;
import com.intuit.karate.FileUtils;
import com.intuit.karate.Results;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.FeatureResult;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class ExecutionContext {
    public final Results results;
    public final long startTime;
    public final FeatureContext featureContext;
    public final CallContext callContext;
    public final FeatureResult result;
    public final Consumer<Runnable> system;
    public final ExecutorService scenarioExecutor;
    public final ClassLoader classLoader;
    private final File reportDir;

    public ExecutionContext(Results results, long startTime, FeatureContext featureContext, CallContext callContext, String reportDirString, Consumer<Runnable> system, ExecutorService scenarioExecutor) {
        this(results, startTime, featureContext, callContext, reportDirString, system, scenarioExecutor, null);
    }

    public ExecutionContext(Results results, long startTime, FeatureContext featureContext, CallContext callContext, String reportDirString, Consumer<Runnable> system, ExecutorService scenarioExecutor, ClassLoader classLoader) {
        this.results = results;
        this.scenarioExecutor = scenarioExecutor;
        this.startTime = startTime;
        this.result = new FeatureResult(results, featureContext.feature);
        this.featureContext = featureContext;
        this.callContext = callContext;
        this.classLoader = classLoader;
        if (callContext.perfMode) {
            this.reportDir = null;
        } else {
            if (reportDirString == null) {
                reportDirString = FileUtils.getBuildDir() + File.separator + "surefire-reports";
            }
            this.reportDir = new File(reportDirString);
            if (!this.reportDir.exists()) {
                this.reportDir.mkdirs();
            }
        }
        this.system = system == null ? r -> r.run() : system;
    }
}

