/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.StringUtils;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    private XmlUtils() {
    }

    public static String toString(Node node) {
        return XmlUtils.toString(node, false);
    }

    public static String toString(Node node, boolean pretty) {
        if (pretty) {
            XmlUtils.trimWhiteSpace(node);
        }
        DOMSource domSource = new DOMSource(node);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            if (pretty) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            } else {
                transformer.setOutputProperty("indent", "no");
            }
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void trimWhiteSpace(Node node) {
        NodeList children = node.getChildNodes();
        int count = children.getLength();
        for (int i = 0; i < count; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                child.setTextContent(child.getTextContent() == null ? "" : child.getTextContent().trim());
            }
            XmlUtils.trimWhiteSpace(child);
        }
    }

    public static Document toXmlDoc(String xml) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DtdEntityResolver dtdEntityResolver = new DtdEntityResolver();
            builder.setEntityResolver(dtdEntityResolver);
            InputStream is = FileUtils.toInputStream(xml);
            Document doc = builder.parse(is);
            if (dtdEntityResolver.dtdPresent) {
                return XmlUtils.toXmlDoc(XmlUtils.toString(doc, false));
            }
            return doc;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static XPathExpression compile(String path) {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        try {
            return xpath.compile(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static NodeList getNodeListByPath(Node node, String path) {
        XPathExpression expr = XmlUtils.compile(path);
        try {
            return (NodeList)expr.evaluate(node, XPathConstants.NODESET);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String stripNameSpacePrefixes(String path) {
        if (path.indexOf(58) == -1) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : StringUtils.split(path, '/', false)) {
            sb.append('/');
            int pos = s.lastIndexOf(58);
            if (pos == -1) {
                sb.append(s);
                continue;
            }
            sb.append(s.substring(pos + 1));
        }
        return sb.toString();
    }

    public static Node getNodeByPath(Node node, String path, boolean create) {
        Node result;
        String searchPath = create ? XmlUtils.stripNameSpacePrefixes(path) : path;
        XPathExpression expr = XmlUtils.compile(searchPath);
        try {
            result = (Node)expr.evaluate(node, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        if (result == null && create) {
            Document doc = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            return XmlUtils.createNodeByPath(doc, path);
        }
        return result;
    }

    public static Node createNodeByPath(Document doc, String path) {
        int pos = path.lastIndexOf(47);
        if (pos == 0) {
            Element root = doc.getDocumentElement();
            if (root == null) {
                root = XmlUtils.createElement(doc, path.substring(1), null, null);
                doc.appendChild(root);
            }
            return root;
        }
        String left = path.substring(0, pos);
        Node parent = XmlUtils.getNodeByPath(doc, left, true);
        String right = path.substring(pos + 1);
        if (right.startsWith("@")) {
            Element parentElement = (Element)parent;
            right = right.substring(1);
            parentElement.setAttribute(right, "");
            return parentElement.getAttributeNode(right);
        }
        int bracketPos = right.indexOf(91);
        if (bracketPos != -1) {
            right = right.substring(0, bracketPos);
        }
        Element element = XmlUtils.createElement(parent, right, null, null);
        parent.appendChild(element);
        return element;
    }

    public static String getTextValueByPath(Node node, String path) {
        XPathExpression expr = XmlUtils.compile(path);
        try {
            return expr.evaluate(node);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setByPath(Node doc, String path, String value) {
        Node node = XmlUtils.getNodeByPath(doc, path, true);
        if (node.getNodeType() == 2) {
            node.setNodeValue(value);
        } else if (node.hasChildNodes() && node.getFirstChild().getNodeType() == 3) {
            node.getFirstChild().setTextContent(value);
        } else if (node.getNodeType() == 1) {
            node.setTextContent(value);
        }
    }

    public static void removeByPath(Document doc, String path) {
        Node node = XmlUtils.getNodeByPath(doc, path, false);
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 2) {
            Element parent = ((Attr)node).getOwnerElement();
            parent.removeAttribute(node.getNodeName());
        } else {
            Node parent = node.getParentNode();
            if (parent != null) {
                parent.removeChild(node);
            }
        }
    }

    public static void setByPath(Document doc, String path, Node in) {
        Node node;
        if (in.getNodeType() == 9) {
            in = in.getFirstChild();
        }
        if ((node = XmlUtils.getNodeByPath(doc, path, true)) == null) {
            throw new RuntimeException("no results for xpath: " + path);
        }
        Node newNode = doc.importNode(in, true);
        if (node.hasChildNodes() && node.getFirstChild().getNodeType() == 3) {
            node.replaceChild(newNode, node.getFirstChild());
        } else {
            node.appendChild(newNode);
        }
    }

    public static DocumentContext toJsonDoc(Node node) {
        return JsonPath.parse((Object)XmlUtils.toObject(node));
    }

    private static Map<String, Object> getAttributes(Node node) {
        NamedNodeMap attribs = node.getAttributes();
        int attribCount = attribs.getLength();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(attribCount);
        for (int j = 0; j < attribCount; ++j) {
            Node attrib = attribs.item(j);
            map.put(attrib.getNodeName(), attrib.getNodeValue());
        }
        return map;
    }

    public static int getChildElementCount(Node node) {
        NodeList nodes = node.getChildNodes();
        int childCount = nodes.getLength();
        int childElementCount = 0;
        for (int i = 0; i < childCount; ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1) continue;
            ++childElementCount;
        }
        return childElementCount;
    }

    private static Object getElementAsObject(Node node, boolean removeNamespace) {
        int childElementCount = XmlUtils.getChildElementCount(node);
        if (childElementCount == 0) {
            return StringUtils.trimToNull(node.getTextContent());
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(childElementCount);
        NodeList nodes = node.getChildNodes();
        int childCount = nodes.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = removeNamespace ? child.getNodeName().replaceFirst("(^.*:)", "") : child.getNodeName();
            Object childValue = XmlUtils.toObject(child, removeNamespace);
            if (map.containsKey(childName)) {
                ArrayList<Object> list;
                Object temp = map.get(childName);
                if (temp instanceof List) {
                    list = (ArrayList<Object>)temp;
                    list.add(childValue);
                    continue;
                }
                list = new ArrayList<Object>(childCount);
                map.put(childName, list);
                list.add(temp);
                list.add(childValue);
                continue;
            }
            map.put(childName, childValue);
        }
        return map;
    }

    public static Object toObject(Node node) {
        return XmlUtils.toObject(node, false);
    }

    public static Object toObject(Node node, boolean removeNamespace) {
        if (node.getNodeType() == 9) {
            node = node.getFirstChild();
            while (node.getNodeType() != 1) {
                node = node.getNextSibling();
            }
            String name = removeNamespace ? node.getNodeName().replaceFirst("(^.*:)", "") : node.getNodeName();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(1);
            map.put(name, XmlUtils.toObject(node, removeNamespace));
            return map;
        }
        Object value = XmlUtils.getElementAsObject(node, removeNamespace);
        if (node.hasAttributes()) {
            Map<String, Object> attribs = XmlUtils.getAttributes(node);
            if (removeNamespace) {
                attribs.keySet().removeIf(key -> "xmlns".equals(key) || key.startsWith("xmlns:"));
            }
            if (attribs.size() > 0) {
                LinkedHashMap<String, Object> wrapper = new LinkedHashMap<String, Object>(2);
                wrapper.put("_", value);
                wrapper.put("@", attribs);
                return wrapper;
            }
            return value;
        }
        return value;
    }

    public static Document fromMap(Map<String, Object> map) {
        Map.Entry<String, Object> first = map.entrySet().iterator().next();
        return XmlUtils.fromObject(first.getKey(), first.getValue());
    }

    public static Document fromObject(String name, Object o) {
        Document doc = XmlUtils.newDocument();
        List<Element> list = XmlUtils.fromObject(doc, name, o);
        Element root = list.get(0);
        doc.appendChild(root);
        return doc;
    }

    public static List<Element> fromObject(Document doc, String name, Object o) {
        if (o instanceof Map) {
            Map map = (Map)o;
            Map attribs = (Map)map.get("@");
            Object value = map.get("_");
            if (value != null || attribs != null) {
                List<Element> elements = XmlUtils.fromObject(doc, name, value);
                XmlUtils.addAttributes(elements.get(0), attribs);
                return elements;
            }
            Element element = XmlUtils.createElement(doc, name, null, null);
            for (Map.Entry entry : map.entrySet()) {
                String childName = (String)entry.getKey();
                Object childValue = entry.getValue();
                List<Element> childNodes = XmlUtils.fromObject(doc, childName, childValue);
                for (Element e : childNodes) {
                    element.appendChild(e);
                }
            }
            return Collections.singletonList(element);
        }
        if (o instanceof List) {
            List list = (List)o;
            ArrayList<Element> elements = new ArrayList<Element>(list.size());
            for (Object child : list) {
                List<Element> childNodes = XmlUtils.fromObject(doc, name, child);
                for (Element e : childNodes) {
                    elements.add(e);
                }
            }
            return elements;
        }
        String value = o == null ? null : o.toString();
        Element element = XmlUtils.createElement(doc, name, value, null);
        return Collections.singletonList(element);
    }

    public static Document newDocument() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return builder.newDocument();
    }

    public static void addAttributes(Element element, Map<String, Object> map) {
        if (map != null) {
            Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Object attrValue;
                Map.Entry<String, Object> entry;
                element.setAttribute(entry.getKey(), (attrValue = (entry = iterator.next()).getValue()) == null ? null : attrValue.toString());
            }
        }
    }

    public static Element createElement(Node node, String name, String value, Map<String, Object> attributes) {
        Document doc = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        Element element = doc.createElement(name);
        element.setTextContent(value);
        XmlUtils.addAttributes(element, attributes);
        return element;
    }

    public static Document toNewDocument(Node in) {
        Document doc = XmlUtils.newDocument();
        Node node = doc.importNode(in, true);
        doc.appendChild(node);
        return doc;
    }

    public static Document toXmlDoc(Object o) {
        DocumentContext json = JsonUtils.toJsonDoc(o);
        Object mapOrArray = json.read("$", new Predicate[0]);
        return XmlUtils.fromObject("root", mapOrArray);
    }

    public static String toXml(Object o) {
        return XmlUtils.toString(XmlUtils.toXmlDoc(o));
    }

    private static class DtdEntityResolver
    implements EntityResolver {
        protected boolean dtdPresent;

        private DtdEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            this.dtdPresent = true;
            return new InputSource(new StringReader(""));
        }
    }
}

