/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.shell;

import com.intuit.karate.LogAppender;
import com.intuit.karate.Logger;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Consumer;

public class Console
extends Thread {
    private final boolean useLineFeed;
    private final InputStream is;
    private final BufferedReader reader;
    private final Logger logger;
    private final LogAppender appender;
    private final StringBuilder buffer;
    private final Consumer<String> listener;

    public String getBuffer() {
        return this.buffer.toString();
    }

    public Console(String name, boolean useLineFeed, InputStream is, Logger logger, LogAppender appender, Consumer<String> listener) {
        super(name);
        this.useLineFeed = useLineFeed;
        this.is = is;
        this.buffer = new StringBuilder();
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.logger = logger;
        this.appender = appender;
        this.listener = listener;
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                this.appender.append(line);
                this.buffer.append(line);
                this.logger.debug("{}", line);
                if (this.useLineFeed) {
                    this.buffer.append('\n');
                }
                if (this.listener == null) continue;
                this.listener.accept(line);
            }
        }
        catch (Exception e) {
            this.logger.error("console reader error: {}", e.getMessage());
        }
    }
}

