/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.job;

import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.job.JobCommand;
import com.intuit.karate.job.JobConfig;
import com.intuit.karate.job.JobContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MavenJobConfig
implements JobConfig {
    private final int executorCount;
    private final String host;
    private final int port;
    protected final List<String> sysPropKeys = new ArrayList<String>(1);
    protected final List<String> envPropKeys = new ArrayList<String>(1);
    protected String dockerImage = "ptrthomas/karate-chrome";

    public MavenJobConfig(int executorCount, String host, int port) {
        this.executorCount = executorCount;
        this.host = host;
        this.port = port;
        this.sysPropKeys.add("karate.env");
    }

    @Override
    public String getExecutorCommand(String jobId, String jobUrl, int index) {
        return "docker run --rm --cap-add=SYS_ADMIN -e KARATE_JOBURL=" + jobUrl + " " + this.dockerImage;
    }

    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    public void addSysPropKey(String key) {
        this.sysPropKeys.add(key);
    }

    public void addEnvPropKey(String key) {
        this.envPropKeys.add(key);
    }

    @Override
    public int getExecutorCount() {
        return this.executorCount;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public List<JobCommand> getMainCommands(JobContext chunk) {
        Scenario scenario = chunk.getScenario();
        String path = scenario.getFeature().getRelativePath();
        int line = scenario.getLine();
        String temp = "mvn exec:java -Dexec.mainClass=com.intuit.karate.cli.Main -Dexec.classpathScope=test -Dexec.args=" + path + ":" + line;
        for (String k : this.sysPropKeys) {
            String v = StringUtils.trimToEmpty(System.getProperty(k));
            if (v.isEmpty()) continue;
            temp = temp + " -D" + k + "=" + v;
        }
        return Collections.singletonList(new JobCommand(temp));
    }

    @Override
    public List<JobCommand> getStartupCommands() {
        return Collections.singletonList(new JobCommand("mvn test-compile"));
    }

    @Override
    public List<JobCommand> getShutdownCommands() {
        return Collections.singletonList(new JobCommand("supervisorctl shutdown"));
    }

    @Override
    public Map<String, String> getEnvironment() {
        HashMap<String, String> map = new HashMap<String, String>(this.envPropKeys.size());
        for (String k : this.envPropKeys) {
            String v = StringUtils.trimToEmpty(System.getenv(k));
            if (v.isEmpty()) continue;
            map.put(k, v);
        }
        return map;
    }
}

