/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.FileUtils;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.http.Cookie;
import com.intuit.karate.http.MultiPartItem;
import java.io.InputStream;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.jersey.karate.uri.internal.UriTemplateParser;

public class HttpUtils {
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_ALLOW = "Allow";
    public static final String HEADER_AC_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String HEADER_AC_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String HEADER_AC_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String HEADER_AC_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String CHARSET = "charset";
    private static final String[] PRINTABLES = new String[]{"json", "xml", "text", "urlencoded", "html"};
    public static final Set<String> HTTP_METHODS = Stream.of("GET", "POST", "PUT", "DELETE", "PATCH", "OPTIONS", "HEAD", "CONNECT", "TRACE").collect(Collectors.toSet());
    public static final List<Integer> DEFAULT_PATH_SCORE = Collections.unmodifiableList(Arrays.asList(0, 0, 0));
    private static final Map<String, UriTemplateParser> TEMPLATE_PARSER_CACHE = new ConcurrentHashMap<String, UriTemplateParser>();
    private static final AtomicInteger BOUNDARY_COUNTER = new AtomicInteger();

    private HttpUtils() {
    }

    public static KeyStore getKeyStore(ScenarioContext context, String trustStoreFile, String password, String type) {
        char[] passwordChars;
        if (trustStoreFile == null) {
            return null;
        }
        char[] cArray = passwordChars = password == null ? null : password.toCharArray();
        if (type == null) {
            type = KeyStore.getDefaultType();
        }
        try {
            KeyStore keyStore = KeyStore.getInstance(type);
            InputStream is = FileUtils.readFileAsStream(trustStoreFile, context);
            keyStore.load(is, passwordChars);
            context.logger.debug("key store key count for {}: {}", trustStoreFile, keyStore.size());
            return keyStore;
        }
        catch (Exception e) {
            context.logger.error("key store init failed: {}", e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static boolean isPrintable(String mediaType) {
        if (mediaType == null) {
            return false;
        }
        String type = mediaType.toLowerCase();
        for (String temp : PRINTABLES) {
            if (!type.contains(temp)) continue;
            return true;
        }
        return false;
    }

    public static Charset parseContentTypeCharset(String mimeType) {
        Map<String, String> map = HttpUtils.parseContentTypeParams(mimeType);
        if (map == null) {
            return null;
        }
        String cs = map.get(CHARSET);
        if (cs == null) {
            return null;
        }
        return Charset.forName(cs);
    }

    public static Map<String, String> parseContentTypeParams(String mimeType) {
        List<String> items = StringUtils.split(mimeType, ';', false);
        int count = items.size();
        if (count <= 1) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(count - 1);
        for (int i = 1; i < count; ++i) {
            String item = items.get(i);
            int pos = item.indexOf(61);
            if (pos == -1) continue;
            String key = item.substring(0, pos).trim();
            String val = item.substring(pos + 1).trim();
            map.put(key, val);
        }
        return map;
    }

    public static String getContentType(ScriptValue sv) {
        if (sv.isStream()) {
            return "application/octet-stream";
        }
        if (sv.getType() == ScriptValue.Type.XML) {
            return "application/xml";
        }
        if (sv.isJsonLike()) {
            return "application/json";
        }
        return "text/plain";
    }

    public static Map<String, Cookie> parseCookieHeaderString(String header) {
        List<HttpCookie> list = HttpCookie.parse(header);
        HashMap<String, Cookie> map = new HashMap<String, Cookie>(list.size());
        list.forEach(hc -> {
            String name = hc.getName();
            Cookie c = new Cookie(name, hc.getValue());
            c.putIfValueNotNull("domain", hc.getDomain());
            c.putIfValueNotNull("path", hc.getPath());
            c.putIfValueNotNull("version", hc.getVersion() + "");
            c.putIfValueNotNull("max-age", hc.getMaxAge() + "");
            c.putIfValueNotNull("secure", hc.getSecure() + "");
            map.put(name, c);
        });
        return map;
    }

    public static String createCookieHeaderValue(Collection<Cookie> cookies) {
        return cookies.stream().map(c -> c.getName() + "=" + c.getValue()).collect(Collectors.joining("; "));
    }

    public static Map<String, String> parseUriPattern(String pattern, String url) {
        pattern = HttpUtils.normaliseUriPath(pattern);
        url = HttpUtils.normaliseUriPath(url);
        if (!pattern.contains("{") || !pattern.contains("}")) {
            return url.equals(pattern) ? Collections.emptyMap() : null;
        }
        UriTemplateParser templateParser = HttpUtils.getUriParserForPattern(pattern);
        Matcher urlMatcher = templateParser.getPattern().matcher(url);
        if (urlMatcher.matches()) {
            if (templateParser.getGroupIndexes().length == 0) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, String> pathParams = new LinkedHashMap<String, String>();
            int index = 0;
            for (String name : templateParser.getNames()) {
                String value = urlMatcher.group(templateParser.getGroupIndexes()[index]);
                if (name == null || pathParams.containsKey(name)) {
                    pathParams.put(name + "@" + (index + 1), value);
                } else {
                    pathParams.put(name, value);
                }
                ++index;
            }
            return pathParams;
        }
        return null;
    }

    private static UriTemplateParser getUriParserForPattern(String pattern) {
        UriTemplateParser templateParser = TEMPLATE_PARSER_CACHE.get(pattern = pattern.replaceAll("\\{}", "{ignored}"));
        if (templateParser == null) {
            templateParser = new UriTemplateParser(pattern);
            TEMPLATE_PARSER_CACHE.put(pattern, templateParser);
        }
        return templateParser;
    }

    public static final String normaliseUriPath(String uri) {
        String string = uri = uri.indexOf(63) == -1 ? uri : uri.substring(0, uri.indexOf(63));
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (!uri.startsWith("/")) {
            uri = "/" + uri;
        }
        return uri;
    }

    public static List<Integer> calculatePathMatchScore(String path) {
        path = HttpUtils.normaliseUriPath(path);
        UriTemplateParser templateParser = HttpUtils.getUriParserForPattern(path);
        int pathScore = templateParser.getNumberOfLiteralCharacters();
        int paramScore = templateParser.getNumberOfRegexGroups() - templateParser.getNumberOfExplicitRegexes();
        int regexScore = templateParser.getNumberOfExplicitRegexes();
        List<Integer> scores = Arrays.asList(pathScore, paramScore, regexScore);
        return scores;
    }

    public static String generateMimeBoundaryMarker() {
        StringBuilder sb = new StringBuilder("boundary_");
        sb.append(BOUNDARY_COUNTER.incrementAndGet()).append('_');
        sb.append(System.currentTimeMillis());
        return sb.toString();
    }

    public static String multiPartToString(List<MultiPartItem> items, String boundary) {
        StringBuilder sb = new StringBuilder();
        boolean firstItem = true;
        for (MultiPartItem item : items) {
            if (firstItem) {
                firstItem = false;
                sb.append("--");
            } else {
                sb.append("\r\n--");
            }
            sb.append(boundary);
            sb.append("\r\n");
            ScriptValue sv = item.getValue();
            String contentType = HttpUtils.getContentType(sv);
            sb.append("Content-Type: ").append(contentType);
            sb.append("\r\n");
            String name = item.getName();
            if (name != null) {
                sb.append("Content-Disposition: form-data");
                if (item.getFilename() != null) {
                    sb.append("; filename=\"").append(item.getFilename()).append("\"");
                }
                sb.append("; name=\"").append(name).append("\"");
                sb.append("\r\n");
            }
            sb.append("\r\n");
            if (sv.getType() == ScriptValue.Type.INPUT_STREAM) {
                InputStream is = sv.getValue(InputStream.class);
                String bytes = FileUtils.toString(is);
                sb.append(bytes);
                continue;
            }
            sb.append(sv.getAsString());
        }
        sb.append("\r\n--");
        sb.append(boundary);
        sb.append("--\r\n");
        return sb.toString();
    }
}

