/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.formats.postman;

import com.intuit.karate.formats.postman.PostmanItem;
import com.intuit.karate.formats.postman.PostmanUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class PostmanConverter {
    public boolean convert(String importFile, String outputDir) {
        try {
            Path pathTo = Paths.get(importFile, new String[0]);
            if (!Files.exists(pathTo, new LinkOption[0])) {
                System.err.println("File at '" + importFile + "' does not exist; cannot import");
                return false;
            }
            String content = new String(Files.readAllBytes(pathTo), StandardCharsets.UTF_8);
            List<PostmanItem> items = PostmanUtils.readPostmanJson(content);
            String collectionName = pathTo.getFileName().toString().replace(".postman_collection", "").replace(".json", "");
            String converted = PostmanUtils.toKarateFeature(collectionName, items);
            Path outputFilePath = Paths.get(outputDir, collectionName + ".feature");
            Files.write(outputFilePath, converted.getBytes(), new OpenOption[0]);
            System.out.println("Converted feature file available at " + outputFilePath.toAbsolutePath().toString());
            return true;
        }
        catch (IOException e) {
            System.err.println("An error occurred with processing the file - the task could not be completed");
            return false;
        }
    }
}

