/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.microsoft;

import com.intuit.karate.Http;
import com.intuit.karate.LogAppender;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.driver.DevToolsDriver;
import com.intuit.karate.driver.DriverElement;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Element;
import com.intuit.karate.shell.Command;
import java.util.Map;

public class EdgeDevToolsDriver
extends DevToolsDriver {
    public EdgeDevToolsDriver(DriverOptions options, Command command, String webSocketUrl) {
        super(options, command, webSocketUrl);
    }

    public static EdgeDevToolsDriver start(ScenarioContext context, Map<String, Object> map, LogAppender appender) {
        DriverOptions options = new DriverOptions(context, map, appender, 9222, "MicrosoftEdge");
        options.arg("--devtools-server-port");
        options.arg(options.port + "");
        options.arg("about:blank");
        Command command = options.startProcess();
        Http http = options.getHttp();
        String webSocketUrl = http.path("json", "list").get().jsonPath("get[0] $[?(@.type=='Page')].webSocketDebuggerUrl").asString();
        EdgeDevToolsDriver edge = new EdgeDevToolsDriver(options, command, webSocketUrl);
        edge.enablePageEvents();
        return edge;
    }

    @Override
    public void activate() {
    }

    @Override
    public void setUrl(String url) {
        this.method("Page.navigate").param("url", url).send();
        this.currentUrl = url;
    }

    @Override
    public Element input(String locator, String value) {
        this.eval(DriverOptions.selector(locator) + ".value = \"" + value + "\"");
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public void close() {
    }

    @Override
    public void quit() {
        this.close();
        if (this.command != null) {
            this.command.close(true);
        }
    }
}

