/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.chrome;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Http;
import com.intuit.karate.LogAppender;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.driver.DevToolsDriver;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.shell.Command;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Chrome
extends DevToolsDriver {
    public static final String DEFAULT_PATH_MAC = "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome";
    public static final String DEFAULT_PATH_WIN = "C:\\Program Files (x86)\\Google\\Chrome\\Application\\chrome.exe";
    public static final String DEFAULT_PATH_LINUX = "/usr/bin/google-chrome";

    public Chrome(DriverOptions options, Command command, String webSocketUrl) {
        super(options, command, webSocketUrl);
    }

    public static Chrome start(ScenarioContext context, Map<String, Object> map, LogAppender appender) {
        DriverOptions options = new DriverOptions(context, map, appender, 9222, FileUtils.isOsWindows() ? DEFAULT_PATH_WIN : (FileUtils.isOsMacOsX() ? DEFAULT_PATH_MAC : DEFAULT_PATH_LINUX));
        options.arg("--remote-debugging-port=" + options.port);
        options.arg("--no-first-run");
        options.arg("--user-data-dir=" + options.workingDirPath);
        options.arg("--disable-popup-blocking");
        if (options.headless) {
            options.arg("--headless");
        }
        Command command = options.startProcess();
        Http http = options.getHttp();
        Command.waitForHttp(http.urlBase);
        Http.Response res = http.path("json").get();
        if (res.body().asList().isEmpty()) {
            if (command != null) {
                command.close(true);
            }
            throw new RuntimeException("chrome server returned empty list from " + http.urlBase);
        }
        String attachUrl = null;
        String webSocketUrl = null;
        List targets = res.body().asList();
        for (Map target : targets) {
            String targetType;
            String targetUrl = (String)target.get("url");
            if (targetUrl == null || targetUrl.startsWith("chrome-") || !"page".equals(targetType = (String)target.get("type"))) continue;
            webSocketUrl = (String)target.get("webSocketDebuggerUrl");
            if (options.attach == null) break;
            if (!targetUrl.contains(options.attach)) continue;
            attachUrl = targetUrl;
            break;
        }
        if (webSocketUrl == null) {
            throw new RuntimeException("failed to attach to chrome debug server");
        }
        Chrome chrome = new Chrome(options, command, webSocketUrl);
        chrome.activate();
        chrome.enablePageEvents();
        chrome.enableRuntimeEvents();
        chrome.enableTargetEvents();
        if (!options.headless) {
            chrome.initWindowIdAndState();
        }
        if (attachUrl != null) {
            chrome.currentUrl = attachUrl;
        }
        return chrome;
    }

    public static Chrome start(String chromeExecutablePath, boolean headless) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("executable", chromeExecutablePath);
        options.put("headless", headless);
        return Chrome.start(null, options, null);
    }

    public static Chrome start(Map<String, Object> options) {
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        return Chrome.start(null, options, null);
    }

    public static Chrome start() {
        return Chrome.start(null);
    }

    public static Chrome startHeadless() {
        return Chrome.start(Collections.singletonMap("headless", true));
    }
}

