/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.driver.Driver;
import java.util.HashMap;
import java.util.Map;

public class Keys {
    private final Driver driver;
    public static final char NULL = '\ue000';
    public static final char CANCEL = '\ue001';
    public static final char HELP = '\ue002';
    public static final char BACK_SPACE = '\ue003';
    public static final char TAB = '\ue004';
    public static final char CLEAR = '\ue005';
    public static final char RETURN = '\ue006';
    public static final char ENTER = '\ue007';
    public static final char SHIFT = '\ue008';
    public static final char CONTROL = '\ue009';
    public static final char ALT = '\ue00a';
    public static final char PAUSE = '\ue00b';
    public static final char ESCAPE = '\ue00c';
    public static final char SPACE = '\ue00d';
    public static final char PAGE_UP = '\ue00e';
    public static final char PAGE_DOWN = '\ue00f';
    public static final char END = '\ue010';
    public static final char HOME = '\ue011';
    public static final char LEFT = '\ue012';
    public static final char UP = '\ue013';
    public static final char RIGHT = '\ue014';
    public static final char DOWN = '\ue015';
    public static final char INSERT = '\ue016';
    public static final char DELETE = '\ue017';
    public static final char SEMICOLON = '\ue018';
    public static final char EQUALS = '\ue019';
    public static final char NUMPAD0 = '\ue01a';
    public static final char NUMPAD1 = '\ue01b';
    public static final char NUMPAD2 = '\ue01c';
    public static final char NUMPAD3 = '\ue01d';
    public static final char NUMPAD4 = '\ue01e';
    public static final char NUMPAD5 = '\ue01f';
    public static final char NUMPAD6 = '\ue020';
    public static final char NUMPAD7 = '\ue021';
    public static final char NUMPAD8 = '\ue022';
    public static final char NUMPAD9 = '\ue023';
    public static final char MULTIPLY = '\ue024';
    public static final char ADD = '\ue025';
    public static final char SEPARATOR = '\ue026';
    public static final char SUBTRACT = '\ue027';
    public static final char DECIMAL = '\ue028';
    public static final char DIVIDE = '\ue029';
    public static final char F1 = '\ue031';
    public static final char F2 = '\ue032';
    public static final char F3 = '\ue033';
    public static final char F4 = '\ue034';
    public static final char F5 = '\ue035';
    public static final char F6 = '\ue036';
    public static final char F7 = '\ue037';
    public static final char F8 = '\ue038';
    public static final char F9 = '\ue039';
    public static final char F10 = '\ue03a';
    public static final char F11 = '\ue03b';
    public static final char F12 = '\ue03c';
    public static final char META = '\ue03d';
    private static final Map<Character, Integer> CODES = new HashMap<Character, Integer>();

    public Keys(Driver driver) {
        this.driver = driver;
    }

    public static Integer code(char c) {
        return CODES.get(Character.valueOf(c));
    }

    public static boolean isNormal(char c) {
        return c < '\ue000';
    }

    public static boolean isModifier(char c) {
        switch (c) {
            case '\ue008': 
            case '\ue009': 
            case '\ue00a': 
            case '\ue03d': {
                return true;
            }
        }
        return false;
    }

    public static String keyIdentifier(char c) {
        return "\\u" + Integer.toHexString(c | 0x10000).substring(1);
    }

    static {
        CODES.put(Character.valueOf('\ue001'), 3);
        CODES.put(Character.valueOf('\ue003'), 8);
        CODES.put(Character.valueOf('\ue004'), 9);
        CODES.put(Character.valueOf('\ue005'), 12);
        CODES.put(Character.valueOf('\ue000'), 12);
        CODES.put(Character.valueOf('\ue006'), 13);
        CODES.put(Character.valueOf('\ue007'), 13);
        CODES.put(Character.valueOf('\ue008'), 16);
        CODES.put(Character.valueOf('\ue009'), 17);
        CODES.put(Character.valueOf('\ue00a'), 18);
        CODES.put(Character.valueOf('\ue00b'), 19);
        CODES.put(Character.valueOf('\ue00c'), 27);
        CODES.put(Character.valueOf('\ue00d'), 32);
        CODES.put(Character.valueOf('\ue00e'), 33);
        CODES.put(Character.valueOf('\ue00f'), 34);
        CODES.put(Character.valueOf('\ue010'), 35);
        CODES.put(Character.valueOf('\ue011'), 36);
        CODES.put(Character.valueOf('\ue012'), 37);
        CODES.put(Character.valueOf('\ue013'), 38);
        CODES.put(Character.valueOf('\ue014'), 39);
        CODES.put(Character.valueOf('\ue015'), 40);
        CODES.put(Character.valueOf('\ue018'), 59);
        CODES.put(Character.valueOf('\ue019'), 61);
        CODES.put(Character.valueOf('\ue01a'), 96);
        CODES.put(Character.valueOf('\ue01b'), 97);
        CODES.put(Character.valueOf('\ue01c'), 98);
        CODES.put(Character.valueOf('\ue01d'), 99);
        CODES.put(Character.valueOf('\ue01e'), 100);
        CODES.put(Character.valueOf('\ue01f'), 101);
        CODES.put(Character.valueOf('\ue020'), 102);
        CODES.put(Character.valueOf('\ue021'), 103);
        CODES.put(Character.valueOf('\ue022'), 104);
        CODES.put(Character.valueOf('\ue023'), 105);
        CODES.put(Character.valueOf('\ue024'), 106);
        CODES.put(Character.valueOf('\ue025'), 107);
        CODES.put(Character.valueOf('\ue026'), 108);
        CODES.put(Character.valueOf('\ue027'), 109);
        CODES.put(Character.valueOf('\ue028'), 110);
        CODES.put(Character.valueOf('\ue029'), 111);
        CODES.put(Character.valueOf('\ue031'), 112);
        CODES.put(Character.valueOf('\ue032'), 113);
        CODES.put(Character.valueOf('\ue033'), 114);
        CODES.put(Character.valueOf('\ue034'), 115);
        CODES.put(Character.valueOf('\ue035'), 116);
        CODES.put(Character.valueOf('\ue036'), 117);
        CODES.put(Character.valueOf('\ue037'), 118);
        CODES.put(Character.valueOf('\ue038'), 119);
        CODES.put(Character.valueOf('\ue039'), 120);
        CODES.put(Character.valueOf('\ue03a'), 121);
        CODES.put(Character.valueOf('\ue03b'), 122);
        CODES.put(Character.valueOf('\ue03c'), 123);
        CODES.put(Character.valueOf('\ue017'), 127);
        CODES.put(Character.valueOf('\ue016'), 155);
        CODES.put(Character.valueOf('\ue002'), 156);
        CODES.put(Character.valueOf('\ue03d'), 157);
        CODES.put(Character.valueOf(' '), 32);
        CODES.put(Character.valueOf(','), 44);
        CODES.put(Character.valueOf('-'), 45);
        CODES.put(Character.valueOf('.'), 46);
        CODES.put(Character.valueOf('/'), 47);
        CODES.put(Character.valueOf('0'), 48);
        CODES.put(Character.valueOf('1'), 49);
        CODES.put(Character.valueOf('2'), 50);
        CODES.put(Character.valueOf('3'), 51);
        CODES.put(Character.valueOf('4'), 52);
        CODES.put(Character.valueOf('5'), 53);
        CODES.put(Character.valueOf('6'), 54);
        CODES.put(Character.valueOf('7'), 55);
        CODES.put(Character.valueOf('8'), 56);
        CODES.put(Character.valueOf('9'), 57);
        CODES.put(Character.valueOf(';'), 59);
        CODES.put(Character.valueOf('='), 61);
        CODES.put(Character.valueOf('a'), 65);
        CODES.put(Character.valueOf('b'), 66);
        CODES.put(Character.valueOf('c'), 67);
        CODES.put(Character.valueOf('d'), 68);
        CODES.put(Character.valueOf('e'), 69);
        CODES.put(Character.valueOf('f'), 70);
        CODES.put(Character.valueOf('g'), 71);
        CODES.put(Character.valueOf('h'), 72);
        CODES.put(Character.valueOf('i'), 73);
        CODES.put(Character.valueOf('j'), 74);
        CODES.put(Character.valueOf('k'), 75);
        CODES.put(Character.valueOf('l'), 76);
        CODES.put(Character.valueOf('m'), 77);
        CODES.put(Character.valueOf('n'), 78);
        CODES.put(Character.valueOf('o'), 79);
        CODES.put(Character.valueOf('p'), 80);
        CODES.put(Character.valueOf('q'), 81);
        CODES.put(Character.valueOf('r'), 82);
        CODES.put(Character.valueOf('s'), 83);
        CODES.put(Character.valueOf('t'), 84);
        CODES.put(Character.valueOf('u'), 85);
        CODES.put(Character.valueOf('v'), 86);
        CODES.put(Character.valueOf('w'), 87);
        CODES.put(Character.valueOf('x'), 88);
        CODES.put(Character.valueOf('y'), 89);
        CODES.put(Character.valueOf('z'), 90);
        CODES.put(Character.valueOf('['), 91);
        CODES.put(Character.valueOf('\\'), 92);
        CODES.put(Character.valueOf(']'), 93);
        CODES.put(Character.valueOf('&'), 150);
        CODES.put(Character.valueOf('*'), 151);
        CODES.put(Character.valueOf('\"'), 152);
        CODES.put(Character.valueOf('<'), 153);
        CODES.put(Character.valueOf('>'), 160);
        CODES.put(Character.valueOf('{'), 161);
        CODES.put(Character.valueOf('}'), 162);
        CODES.put(Character.valueOf('`'), 192);
        CODES.put(Character.valueOf('\''), 222);
        CODES.put(Character.valueOf('@'), 512);
        CODES.put(Character.valueOf(':'), 513);
        CODES.put(Character.valueOf('$'), 515);
        CODES.put(Character.valueOf('!'), 517);
        CODES.put(Character.valueOf('('), 519);
        CODES.put(Character.valueOf('#'), 520);
        CODES.put(Character.valueOf('+'), 521);
        CODES.put(Character.valueOf(')'), 522);
        CODES.put(Character.valueOf('_'), 523);
    }
}

