/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Http;
import com.intuit.karate.LogAppender;
import com.intuit.karate.Logger;
import com.intuit.karate.core.Embed;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.DriverElement;
import com.intuit.karate.driver.Element;
import com.intuit.karate.driver.MissingElement;
import com.intuit.karate.driver.Target;
import com.intuit.karate.driver.appium.AndroidDriver;
import com.intuit.karate.driver.appium.IosDriver;
import com.intuit.karate.driver.chrome.Chrome;
import com.intuit.karate.driver.chrome.ChromeWebDriver;
import com.intuit.karate.driver.firefox.GeckoWebDriver;
import com.intuit.karate.driver.microsoft.EdgeDevToolsDriver;
import com.intuit.karate.driver.microsoft.IeWebDriver;
import com.intuit.karate.driver.microsoft.MsEdgeDriver;
import com.intuit.karate.driver.microsoft.MsWebDriver;
import com.intuit.karate.driver.microsoft.WinAppDriver;
import com.intuit.karate.driver.safari.SafariWebDriver;
import com.intuit.karate.shell.Command;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class DriverOptions {
    public final Map<String, Object> options;
    public final int timeout;
    public final boolean start;
    public final String executable;
    public final String type;
    public final int port;
    public final String host;
    public final int pollAttempts;
    public final int pollInterval;
    public final boolean headless;
    public final boolean showProcessLog;
    public final boolean showDriverLog;
    public final Logger logger;
    public final LogAppender appender;
    public final Logger processLogger;
    public final Logger driverLogger;
    public final String uniqueName;
    public final File workingDir;
    public final String workingDirPath;
    public final String processLogFile;
    public final int maxPayloadSize;
    public final List<String> addOptions;
    public final List<String> args = new ArrayList<String>();
    public final String webDriverUrl;
    public final String webDriverPath;
    public final Map<String, Object> webDriverSession;
    public final Map<String, Object> httpConfig;
    public final Target target;
    public final String beforeStart;
    public final String afterStop;
    public final String videoFile;
    public final boolean highlight;
    public final int highlightDuration;
    public final String attach;
    private boolean retryEnabled;
    private Integer retryInterval = null;
    private Integer retryCount = null;
    private String preSubmitHash = null;
    private Integer timeoutOverride;
    private ScenarioContext context;
    public static final String SCROLL_JS_FUNCTION = "function(e){ var d = window.getComputedStyle(e).display; while(d == 'none'){ e = e.parentElement; d = window.getComputedStyle(e).display } e.scrollIntoView({block: 'center'}) }";
    public static final String KARATE_REF_GENERATOR = "function(e){ if (!document._karate) document._karate = { seq: (new Date()).getTime() }; var ref = 'ref' + document._karate.seq++; document._karate[ref] = e; return ref }";
    private static final String DOCUMENT = "document";
    private static final String HIGHLIGHT_FN = "function(e){ var old = e.getAttribute('style'); e.setAttribute('style', 'background: yellow; border: 2px solid red;'); setTimeout(function(){ e.setAttribute('style', old) }, %d) }";

    public void setContext(ScenarioContext context) {
        this.context = context;
    }

    public ScenarioContext getContext() {
        return this.context;
    }

    public boolean isRetryEnabled() {
        return this.retryEnabled;
    }

    public String getPreSubmitHash() {
        return this.preSubmitHash;
    }

    public void setPreSubmitHash(String preSubmitHash) {
        this.preSubmitHash = preSubmitHash;
    }

    private <T> T get(String key, T defaultValue) {
        Object temp = this.options.get(key);
        return (T)(temp == null ? defaultValue : temp);
    }

    public DriverOptions(ScenarioContext context, Map<String, Object> options, LogAppender appender, int defaultPort, String defaultExecutable) {
        this.context = context;
        this.options = options;
        this.appender = appender;
        this.logger = new Logger(this.getClass());
        this.logger.setAppender(appender);
        this.timeout = this.get("timeout", 30000);
        this.type = this.get("type", null);
        this.start = this.get("start", true);
        this.executable = this.get("executable", defaultExecutable);
        this.headless = this.get("headless", false);
        this.showProcessLog = this.get("showProcessLog", false);
        this.addOptions = this.get("addOptions", null);
        this.uniqueName = this.type + "_" + System.currentTimeMillis();
        String packageName = this.getClass().getPackage().getName();
        this.processLogger = this.showProcessLog ? this.logger : new Logger(packageName + "." + this.uniqueName);
        this.showDriverLog = this.get("showDriverLog", false);
        Logger logger = this.driverLogger = this.showDriverLog ? this.logger : new Logger(packageName + "." + this.uniqueName);
        if (this.executable != null) {
            if (this.executable.startsWith(".")) {
                this.args.add(new File(this.executable).getAbsolutePath());
            } else {
                this.args.add(this.executable);
            }
        }
        this.workingDir = new File(FileUtils.getBuildDir() + File.separator + this.uniqueName);
        this.workingDirPath = this.workingDir.getAbsolutePath();
        this.processLogFile = this.workingDir.getPath() + File.separator + this.type + ".log";
        this.maxPayloadSize = this.get("maxPayloadSize", 0x400000);
        this.target = this.get("target", null);
        this.host = this.get("host", "localhost");
        this.webDriverUrl = this.get("webDriverUrl", null);
        this.webDriverPath = this.get("webDriverPath", null);
        this.webDriverSession = this.get("webDriverSession", null);
        this.httpConfig = this.get("httpConfig", null);
        this.beforeStart = this.get("beforeStart", null);
        this.afterStop = this.get("afterStop", null);
        this.videoFile = this.get("videoFile", null);
        this.pollAttempts = this.get("pollAttempts", 20);
        this.pollInterval = this.get("pollInterval", 250);
        this.highlight = this.get("highlight", false);
        this.highlightDuration = this.get("highlightDuration", 3000);
        this.attach = this.get("attach", null);
        this.port = this.resolvePort(defaultPort);
    }

    private int resolvePort(int defaultPort) {
        if (this.webDriverUrl != null) {
            return 0;
        }
        int preferredPort = this.get("port", defaultPort);
        if (this.start) {
            int freePort = Command.getFreePort(preferredPort);
            if (freePort != preferredPort) {
                this.logger.warn("preferred port {} not available, will use: {}", preferredPort, freePort);
            }
            return freePort;
        }
        return preferredPort;
    }

    public Http getHttp() {
        Http http = Http.forUrl(this.driverLogger.getAppender(), this.getUrlBase());
        if (this.httpConfig != null) {
            http.config(this.httpConfig);
        }
        return http;
    }

    private String getUrlBase() {
        if (this.webDriverUrl != null) {
            return this.webDriverUrl;
        }
        String urlBase = "http://" + this.host + ":" + this.port;
        if (this.webDriverPath != null) {
            return urlBase + this.webDriverPath;
        }
        return urlBase;
    }

    public void arg(String arg) {
        this.args.add(arg);
    }

    public Command startProcess() {
        Command command;
        if (this.beforeStart != null) {
            Command.execLine(null, this.beforeStart);
        }
        if (this.target != null || !this.start) {
            command = null;
        } else {
            if (this.addOptions != null) {
                this.args.addAll(this.addOptions);
            }
            command = new Command(false, this.processLogger, this.uniqueName, this.processLogFile, this.workingDir, this.args.toArray(new String[0]));
            command.start();
        }
        if (this.start) {
            this.waitForPort(this.host, this.port);
        }
        return command;
    }

    public static Driver start(ScenarioContext context, Map<String, Object> options, LogAppender appender) {
        String type;
        Target target = (Target)options.get("target");
        Logger logger = context.logger;
        if (target != null) {
            logger.debug("custom target configured, calling start()", new Object[0]);
            Map<String, Object> map = target.start(logger);
            logger.debug("custom target returned options: {}", map);
            options.putAll(map);
        }
        if ((type = (String)options.get("type")) == null) {
            logger.warn("type was null, defaulting to 'chrome'", new Object[0]);
            type = "chrome";
            options.put("type", type);
        }
        try {
            switch (type) {
                case "chrome": {
                    return Chrome.start(context, options, appender);
                }
                case "msedge": {
                    return EdgeDevToolsDriver.start(context, options, appender);
                }
                case "chromedriver": {
                    return ChromeWebDriver.start(context, options, appender);
                }
                case "geckodriver": {
                    return GeckoWebDriver.start(context, options, appender);
                }
                case "safaridriver": {
                    return SafariWebDriver.start(context, options, appender);
                }
                case "msedgedriver": {
                    return MsEdgeDriver.start(context, options, appender);
                }
                case "mswebdriver": {
                    return MsWebDriver.start(context, options, appender);
                }
                case "iedriver": {
                    return IeWebDriver.start(context, options, appender);
                }
                case "winappdriver": {
                    return WinAppDriver.start(context, options, appender);
                }
                case "android": {
                    return AndroidDriver.start(context, options, appender);
                }
                case "ios": {
                    return IosDriver.start(context, options, appender);
                }
            }
            logger.warn("unknown driver type: {}, defaulting to 'chrome'", type);
            options.put("type", "chrome");
            return Chrome.start(context, options, appender);
        }
        catch (Exception e) {
            String message = "driver config / start failed: " + e.getMessage() + ", options: " + options;
            logger.error(message, e);
            if (target != null) {
                target.stop(logger);
            }
            throw new RuntimeException(message, e);
        }
    }

    private Map<String, Object> getSession(String browserName) {
        HashMap capabilities;
        Map<String, Object> session = this.webDriverSession;
        if (session == null) {
            session = new HashMap<String, Object>();
        }
        if ((capabilities = (HashMap)session.get("capabilities")) == null) {
            capabilities = (Map)session.get("desiredCapabilities");
        }
        if (capabilities == null) {
            capabilities = new HashMap();
            session.put("capabilities", capabilities);
            HashMap<String, String> alwaysMatch = new HashMap<String, String>();
            capabilities.put("alwaysMatch", alwaysMatch);
            alwaysMatch.put("browserName", browserName);
        }
        return session;
    }

    public Map<String, Object> getWebDriverSessionPayload() {
        switch (this.type) {
            case "chromedriver": {
                return this.getSession("chrome");
            }
            case "geckodriver": {
                return this.getSession("firefox");
            }
            case "safaridriver": {
                return this.getSession("safari");
            }
            case "msedgedriver": 
            case "mswebdriver": {
                return this.getSession("edge");
            }
            case "iedriver": {
                return this.getSession("internet explorer");
            }
        }
        return this.getSession(this.type);
    }

    public static String preProcessWildCard(String locator) {
        int index;
        String tag;
        String prefix;
        boolean contains;
        int pos = locator.indexOf(125);
        if (pos == -1) {
            throw new RuntimeException("bad locator prefix: " + locator);
        }
        if (locator.charAt(1) == '^') {
            contains = true;
            prefix = locator.substring(2, pos);
        } else {
            contains = false;
            prefix = locator.substring(1, pos);
        }
        String text = locator.substring(pos + 1);
        pos = prefix.indexOf(58);
        if (pos != -1) {
            String tagTemp = prefix.substring(0, pos);
            tag = tagTemp.isEmpty() ? "*" : tagTemp;
            String indexTemp = prefix.substring(pos + 1);
            if (indexTemp.isEmpty()) {
                index = 0;
            } else {
                try {
                    index = Integer.valueOf(indexTemp);
                }
                catch (Exception e) {
                    throw new RuntimeException("bad locator prefix: " + locator + ", " + e.getMessage());
                }
            }
        } else {
            tag = prefix.isEmpty() ? "*" : prefix;
            index = 0;
        }
        if (!tag.startsWith("/")) {
            tag = "//" + tag;
        }
        String xpath = contains ? tag + "[contains(normalize-space(text()),'" + text + "')]" : tag + "[normalize-space(text())='" + text + "']";
        if (index == 0) {
            return xpath;
        }
        return "/(" + xpath + ")[" + index + "]";
    }

    public static String selector(String locator) {
        return DriverOptions.selector(locator, DOCUMENT);
    }

    public static String selector(String locator, String contextNode) {
        if (locator.startsWith("(")) {
            return locator;
        }
        if (locator.startsWith("{")) {
            locator = DriverOptions.preProcessWildCard(locator);
        }
        if (locator.startsWith("/")) {
            if (locator.startsWith("/(")) {
                locator = locator.substring(1);
            }
            return "document.evaluate(\"" + locator + "\", " + contextNode + ", null, 9, null).singleNodeValue";
        }
        return contextNode + ".querySelector(\"" + locator + "\")";
    }

    public void setTimeout(Integer timeout) {
        this.timeoutOverride = timeout;
    }

    public int getTimeout() {
        if (this.timeoutOverride != null) {
            return this.timeoutOverride;
        }
        return this.timeout;
    }

    public void setRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
    }

    public int getRetryInterval() {
        if (this.retryInterval != null) {
            return this.retryInterval;
        }
        if (this.context == null) {
            return 3000;
        }
        return this.context.getConfig().getRetryInterval();
    }

    public int getRetryCount() {
        if (this.retryCount != null) {
            return this.retryCount;
        }
        if (this.context == null) {
            return 3;
        }
        return this.context.getConfig().getRetryCount();
    }

    public <T> T retry(Supplier<T> action, Predicate<T> condition, String logDescription, boolean failWithException) {
        T result;
        boolean success;
        long startTime = System.currentTimeMillis();
        int count = 0;
        int max = this.getRetryCount();
        do {
            if (count <= 0) continue;
            this.logger.debug("{} - retry #{}", logDescription, count);
            this.sleep();
        } while (!(success = condition.test(result = action.get())) && count++ < max);
        if (!success) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            String message = logDescription + ": failed after " + (count - 1) + " retries and " + elapsedTime + " milliseconds";
            this.logger.warn(message, new Object[0]);
            if (failWithException) {
                throw new RuntimeException(message);
            }
        }
        return result;
    }

    public static String wrapInFunctionInvoke(String text) {
        return "(function(){ " + text + " })()";
    }

    private static String highlightFn(int millis) {
        return String.format(HIGHLIGHT_FN, millis);
    }

    public String highlight(String locator, int millis) {
        String e = DriverOptions.selector(locator);
        String temp = "var e = " + e + "; var fun = " + DriverOptions.highlightFn(millis) + "; fun(e)";
        return DriverOptions.wrapInFunctionInvoke(temp);
    }

    public String highlightAll(String locator, int millis) {
        return this.scriptAllSelector(locator, DriverOptions.highlightFn(millis));
    }

    public String optionSelector(String locator, String text) {
        String condition;
        boolean textEquals = text.startsWith("{}");
        boolean textContains = text.startsWith("{^}");
        if (textEquals || textContains) {
            text = text.substring(text.indexOf(125) + 1);
            condition = textContains ? "e.options[i].text.indexOf(t) !== -1" : "e.options[i].text === t";
        } else {
            condition = "e.options[i].value === t";
        }
        String e = DriverOptions.selector(locator);
        String temp = "var e = " + e + "; var t = \"" + text + "\"; for (var i = 0; i < e.options.length; ++i) if (" + condition + ") { e.options[i].selected = true; e.dispatchEvent(new Event('change')) }";
        return DriverOptions.wrapInFunctionInvoke(temp);
    }

    public String optionSelector(String id, int index) {
        String e = DriverOptions.selector(id);
        String temp = "var e = " + e + "; var t = " + index + "; for (var i = 0; i < e.options.length; ++i) if (i === t) { e.options[i].selected = true; e.dispatchEvent(new Event('change')) }";
        return DriverOptions.wrapInFunctionInvoke(temp);
    }

    private String fun(String expression) {
        char first = expression.charAt(0);
        return first == '_' || first == '!' ? "function(_){ return " + expression + " }" : expression;
    }

    public String scriptSelector(String locator, String expression) {
        return this.scriptSelector(locator, expression, DOCUMENT);
    }

    public String scriptSelector(String locator, String expression, String contextNode) {
        String temp = "var fun = " + this.fun(expression) + "; var e = " + DriverOptions.selector(locator, contextNode) + "; return fun(e)";
        return DriverOptions.wrapInFunctionInvoke(temp);
    }

    public String scriptAllSelector(String locator, String expression) {
        return this.scriptAllSelector(locator, expression, DOCUMENT);
    }

    public String scriptAllSelector(String locator, String expression, String contextNode) {
        boolean isXpath;
        if (locator.startsWith("{")) {
            locator = DriverOptions.preProcessWildCard(locator);
        }
        String selector = (isXpath = locator.startsWith("/")) ? "document.evaluate(\"" + locator + "\", " + contextNode + ", null, 5, null)" : contextNode + ".querySelectorAll(\"" + locator + "\")";
        String temp = "var res = []; var fun = " + this.fun(expression) + "; var es = " + selector + "; ";
        temp = isXpath ? temp + "var e = null; while(e = es.iterateNext()) res.push(fun(e)); return res" : temp + "es.forEach(function(e){ res.push(fun(e)) }); return res";
        return DriverOptions.wrapInFunctionInvoke(temp);
    }

    public void sleep() {
        this.sleep(this.getRetryInterval());
    }

    public void sleep(int millis) {
        if (millis == 0) {
            return;
        }
        try {
            this.processLogger.trace("sleeping for millis: {}", millis);
            Thread.sleep(millis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean waitForPort(String host, int port) {
        int attempts = 0;
        while (true) {
            InetSocketAddress address = new InetSocketAddress(host, port);
            try {
                this.processLogger.debug("poll attempt #{} for port to be ready - {}:{}", attempts, host, port);
                SocketChannel sock = SocketChannel.open(address);
                sock.close();
                return true;
            }
            catch (IOException e) {
                this.sleep(this.pollInterval);
                if (attempts++ < this.pollAttempts) continue;
                return false;
            }
            break;
        }
    }

    public Map<String, Object> newMapWithSelectedKeys(Map<String, Object> map, String ... keys) {
        HashMap<String, Object> out = new HashMap<String, Object>(keys.length);
        for (String key : keys) {
            Object o = map.get(key);
            if (o == null) continue;
            out.put(key, o);
        }
        return out;
    }

    public void embedPngImage(byte[] bytes) {
        if (this.context != null) {
            this.context.embed(bytes, "image/png");
        }
    }

    public void embedContent(Embed embed) {
        if (this.context != null) {
            this.context.embed(embed);
        }
    }

    public void disableRetry() {
        this.retryEnabled = false;
        this.retryCount = null;
        this.retryInterval = null;
    }

    public void enableRetry(Integer count, Integer interval) {
        this.retryEnabled = true;
        this.retryCount = count;
        this.retryInterval = interval;
    }

    public Element waitUntil(Driver driver, String locator, String expression) {
        long startTime = System.currentTimeMillis();
        String js = this.scriptSelector(locator, expression);
        boolean found = driver.waitUntil(js);
        if (!found) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            throw new RuntimeException("wait failed for: " + locator + " and condition: " + expression + " after " + elapsedTime + " milliseconds");
        }
        return DriverElement.locatorExists(driver, locator);
    }

    public String waitForUrl(Driver driver, String expected) {
        return this.retry(() -> driver.getUrl(), url -> url.contains(expected), "waitForUrl", true);
    }

    public Element waitForAny(Driver driver, String ... locators) {
        long startTime = System.currentTimeMillis();
        List<String> list = Arrays.asList(locators);
        Iterator<String> iterator = list.iterator();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            String locator = iterator.next();
            String js = DriverOptions.selector(locator);
            sb.append("(").append(js).append(" != null)");
            if (!iterator.hasNext()) continue;
            sb.append(" || ");
        }
        boolean found = driver.waitUntil(sb.toString());
        this.disableRetry();
        if (!found) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            throw new RuntimeException("wait failed for: " + list + " after " + elapsedTime + " milliseconds");
        }
        if (locators.length == 1) {
            return DriverElement.locatorExists(driver, locators[0]);
        }
        for (String locator : locators) {
            Element temp = driver.optional(locator);
            if (!temp.isPresent()) continue;
            return temp;
        }
        throw new RuntimeException("unexpected wait failure for locators: " + list);
    }

    public Element optional(Driver driver, String locator) {
        String js = DriverOptions.selector(locator);
        String evalJs = js + " != null";
        Object o = driver.script(evalJs);
        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            return DriverElement.locatorExists(driver, locator);
        }
        return new MissingElement(driver, locator);
    }

    public static String karateLocator(String karateRef) {
        return "(document._karate." + karateRef + ")";
    }

    public String focusJs(String locator) {
        return "var e = " + DriverOptions.selector(locator) + "; e.focus(); try { e.selectionStart = e.selectionEnd = e.value.length } catch(x) {}";
    }

    public List<Element> findAll(Driver driver, String locator) {
        List list = driver.scriptAll(locator, KARATE_REF_GENERATOR);
        ArrayList<Element> elements = new ArrayList<Element>(list.size());
        for (String karateRef : list) {
            String karateLocator = DriverOptions.karateLocator(karateRef);
            elements.add(DriverElement.locatorExists(driver, karateLocator));
        }
        return elements;
    }
}

