/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.Logger;
import com.intuit.karate.driver.DevToolsMessage;
import com.intuit.karate.driver.DriverOptions;
import java.util.function.Predicate;

public class DevToolsWait {
    private final DriverOptions options;
    private DevToolsMessage lastSent;
    private Predicate<DevToolsMessage> condition;
    private DevToolsMessage lastReceived;
    private final Predicate<DevToolsMessage> DEFAULT = m -> this.lastSent.getId().equals(m.getId());
    public static final Predicate<DevToolsMessage> FRAME_RESIZED = DevToolsWait.forEvent("Page.frameResized");
    public static final Predicate<DevToolsMessage> INSPECTOR_DETACHED = DevToolsWait.forEvent("Inspector.detached");
    public static final Predicate<DevToolsMessage> DIALOG_OPENING = DevToolsWait.forEvent("Page.javascriptDialogOpening");
    public static final Predicate<DevToolsMessage> ALL_FRAMES_LOADED = m -> {
        if (m.methodIs("Page.domContentEventFired")) {
            if (m.driver.framesStillLoading.isEmpty()) {
                m.driver.logger.trace("** dom ready, and no frames loading, wait done", new Object[0]);
                return true;
            }
            m.driver.logger.trace("** dom ready, but frames still loading, will wait: {}", m.driver.framesStillLoading);
            return false;
        }
        if (m.methodIs("Page.frameStoppedLoading")) {
            if (!m.driver.domContentEventFired) {
                m.driver.logger.trace("** dom not ready, will wait, and frames loading: {}", m.driver.framesStillLoading);
                return false;
            }
            if (m.driver.framesStillLoading.isEmpty()) {
                m.driver.logger.trace("** dom ready, and no frames loading, wait done", new Object[0]);
                return true;
            }
            m.driver.logger.trace("** dom ready, but frames still loading, will wait: {}", m.driver.framesStillLoading);
        }
        return false;
    };
    private Logger logger;

    public static Predicate<DevToolsMessage> forEvent(String name) {
        return m -> name.equals(m.getMethod());
    }

    public DevToolsWait(DriverOptions options) {
        this.options = options;
        this.logger = options.driverLogger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setCondition(Predicate<DevToolsMessage> condition) {
        this.condition = condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DevToolsMessage send(DevToolsMessage dtm, Predicate<DevToolsMessage> condition) {
        this.lastReceived = null;
        this.lastSent = dtm;
        this.condition = condition == null ? this.DEFAULT : condition;
        long timeout = dtm.getTimeout() == null ? (long)this.options.getTimeout() : (long)dtm.getTimeout().intValue();
        DevToolsWait devToolsWait = this;
        synchronized (devToolsWait) {
            this.logger.trace(">> wait: {}", dtm);
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                this.logger.error("interrupted: {} wait: {}", e.getMessage(), dtm);
            }
        }
        if (this.lastReceived == null) {
            this.logger.error("<< timed out after milliseconds: {} - {}", timeout, dtm);
            return null;
        }
        this.logger.trace("<< notified: {}", dtm);
        return this.lastReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(DevToolsMessage dtm) {
        DevToolsWait devToolsWait = this;
        synchronized (devToolsWait) {
            if (this.condition.test(dtm)) {
                if (dtm.isResultError()) {
                    this.logger.warn("devtools error: {}", dtm);
                } else {
                    this.logger.trace("<< notify: {}", dtm);
                }
                this.lastReceived = dtm;
                this.notify();
            } else {
                this.logger.trace("<< ignore: {}", dtm);
            }
        }
    }
}

