/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Logger;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeaturesBackend;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.core.ScriptBridge;
import com.intuit.karate.driver.DevToolsMessage;
import com.intuit.karate.driver.DevToolsWait;
import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.DriverElement;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Element;
import com.intuit.karate.driver.Input;
import com.intuit.karate.driver.Keys;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.MultiValuedMap;
import com.intuit.karate.netty.NettyUtils;
import com.intuit.karate.netty.WebSocketClient;
import com.intuit.karate.netty.WebSocketOptions;
import com.intuit.karate.shell.Command;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.MDC;

public abstract class DevToolsDriver
implements Driver {
    protected final DriverOptions options;
    protected final Command command;
    protected final WebSocketClient client;
    private final DevToolsWait wait;
    protected final String rootFrameId;
    private Integer windowId;
    private String windowState;
    private Integer executionContextId;
    protected String sessionId;
    protected boolean domContentEventFired;
    protected final Set<String> framesStillLoading = new HashSet<String>();
    private final Map<String, String> frameSessions = new HashMap<String, String>();
    private boolean submit;
    protected String currentUrl;
    protected String currentDialogText;
    protected int currentMouseXpos;
    protected int currentMouseYpos;
    private int nextId;
    private FeaturesBackend backend;
    protected final Logger logger;

    public int nextId() {
        return ++this.nextId;
    }

    protected DevToolsDriver(DriverOptions options, Command command, String webSocketUrl) {
        this.logger = options.driverLogger;
        this.options = options;
        this.command = command;
        this.wait = new DevToolsWait(options);
        int pos = webSocketUrl.lastIndexOf(47);
        this.rootFrameId = webSocketUrl.substring(pos + 1);
        this.logger.debug("root frame id: {}", this.rootFrameId);
        WebSocketOptions wsOptions = new WebSocketOptions(webSocketUrl);
        wsOptions.setMaxPayloadSize(options.maxPayloadSize);
        wsOptions.setTextConsumer(text -> {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("<< {}", text);
            } else {
                this.logger.debug("<< {}", StringUtils.truncate(text, 1024, true));
            }
            Map map = (Map)JsonUtils.toJsonDoc(text).read("$", new com.jayway.jsonpath.Predicate[0]);
            DevToolsMessage dtm = new DevToolsMessage(this, map);
            this.receive(dtm);
        });
        this.client = new WebSocketClient(wsOptions, this.logger);
    }

    public int waitSync() {
        if (this.command == null) {
            return -1;
        }
        return this.command.waitSync();
    }

    @Override
    public Driver timeout(Integer millis) {
        this.options.setTimeout(millis);
        return this;
    }

    @Override
    public Driver timeout() {
        return this.timeout(null);
    }

    public DevToolsMessage method(String method) {
        return new DevToolsMessage(this, method);
    }

    public Map<String, Object> send(Map<String, Object> map) {
        DevToolsMessage dtm = new DevToolsMessage(this, map);
        dtm.setId(this.nextId());
        return this.sendAndWait(dtm, null).toMap();
    }

    public void send(DevToolsMessage dtm) {
        String json = JsonUtils.toJson(dtm.toMap());
        this.logger.debug(">> {}", json);
        this.client.send(json);
    }

    public DevToolsMessage sendAndWait(DevToolsMessage dtm, Predicate<DevToolsMessage> condition) {
        DevToolsMessage result;
        this.send(dtm);
        boolean wasSubmit = this.submit;
        if (condition == null && this.submit) {
            this.submit = false;
            condition = DevToolsWait.ALL_FRAMES_LOADED;
        }
        if ((result = this.wait.send(dtm, condition)) == null && !wasSubmit) {
            throw new RuntimeException("failed to get reply for: " + dtm);
        }
        return result;
    }

    public void receive(DevToolsMessage dtm) {
        String frameNavUrl;
        String frameNavId;
        if (dtm.methodIs("Page.domContentEventFired")) {
            this.domContentEventFired = true;
            this.logger.trace("** set dom ready flag to true", new Object[0]);
        }
        if (dtm.methodIs("Page.javascriptDialogOpening")) {
            this.currentDialogText = dtm.getParam("message").getAsString();
            this.wait.setCondition(DevToolsWait.DIALOG_OPENING);
        }
        if (dtm.methodIs("Page.frameNavigated")) {
            frameNavId = dtm.get("frame.id", String.class);
            frameNavUrl = dtm.get("frame.url", String.class);
            if (this.rootFrameId.equals(frameNavId)) {
                this.currentUrl = frameNavUrl;
            }
        }
        if (dtm.methodIs("Page.navigatedWithinDocument")) {
            frameNavId = dtm.get("frameId", String.class);
            frameNavUrl = dtm.get("url", String.class);
            if (this.rootFrameId.equals(frameNavId)) {
                this.currentUrl = frameNavUrl;
            }
        }
        if (dtm.methodIs("Page.frameStartedLoading")) {
            String frameLoadingId = dtm.get("frameId", String.class);
            if (this.rootFrameId.equals(frameLoadingId)) {
                this.domContentEventFired = false;
                this.framesStillLoading.clear();
                this.frameSessions.clear();
                this.logger.trace("** root frame started loading, cleared all page state: {}", frameLoadingId);
            } else {
                this.framesStillLoading.add(frameLoadingId);
                this.logger.trace("** frame started loading, added to in-progress list: {}", this.framesStillLoading);
            }
        }
        if (dtm.methodIs("Page.frameStoppedLoading")) {
            String frameLoadedId = dtm.get("frameId", String.class);
            this.framesStillLoading.remove(frameLoadedId);
            this.logger.trace("** frame stopped loading: {}, remaining in-progress: {}", frameLoadedId, this.framesStillLoading);
        }
        if (dtm.methodIs("Target.attachedToTarget")) {
            this.frameSessions.put(dtm.get("targetInfo.targetId", String.class), dtm.get("sessionId", String.class));
            this.logger.trace("** added frame session: {}", this.frameSessions);
        }
        if (dtm.methodIs("Fetch.requestPaused")) {
            this.handleInterceptedRequest(dtm);
        }
        this.wait.receive(dtm);
    }

    private void handleInterceptedRequest(DevToolsMessage dtm) {
        String requestId = dtm.get("requestId", String.class);
        String requestUrl = dtm.get("request.url", String.class);
        if (this.backend != null) {
            String method = dtm.get("request.method", String.class);
            Map headers = dtm.get("request.headers", Map.class);
            String postData = dtm.get("request.postData", String.class);
            this.logger.debug("intercepting request for url: {}", requestUrl);
            HttpRequest request = new HttpRequest();
            StringUtils.Pair pair = NettyUtils.parseUriIntoUrlBaseAndPath(requestUrl);
            request.setUrlBase(pair.left);
            request.setUri(pair.right);
            request.setMethod(method);
            String karateRequestId = System.identityHashCode(dtm) + "";
            MDC.put((String)"karateRequestId", (String)karateRequestId);
            request.setRequestId(karateRequestId);
            headers.forEach((k, v) -> request.addHeader((String)k, (String)v));
            if (postData != null) {
                request.setBody(FileUtils.toBytes(postData));
            } else {
                request.setBody(FileUtils.EMPTY_BYTES);
            }
            HttpResponse response = this.backend.buildResponse(request, System.currentTimeMillis());
            String responseBody = response.getBody() == null ? "" : Base64.getEncoder().encodeToString(response.getBody());
            ArrayList responseHeaders = new ArrayList();
            MultiValuedMap mvm = response.getHeaders();
            if (mvm != null) {
                for (String name : mvm.keySet()) {
                    Object value = mvm.getFirst(name);
                    HashMap<String, Object> nv = new HashMap<String, Object>(2);
                    nv.put("name", name);
                    nv.put("value", value);
                    responseHeaders.add(nv);
                }
            }
            this.method("Fetch.fulfillRequest").param("requestId", requestId).param("responseCode", response.getStatus()).param("responseHeaders", responseHeaders).param("body", responseBody).sendWithoutWaiting();
        } else {
            this.logger.warn("no mock server, continuing paused request to url: {}", requestUrl);
            this.method("Fetch.continueRequest").param("requestId", requestId).sendWithoutWaiting();
        }
    }

    private DevToolsMessage evalOnce(String expression, boolean quickly, boolean fireAndForget) {
        DevToolsMessage toSend = this.method("Runtime.evaluate").param("expression", expression).param("returnByValue", true);
        if (this.executionContextId != null) {
            toSend.param("contextId", this.executionContextId);
        }
        if (quickly) {
            toSend.setTimeout(this.options.getRetryInterval());
        }
        if (fireAndForget) {
            toSend.sendWithoutWaiting();
            return null;
        }
        return toSend.send();
    }

    protected DevToolsMessage eval(String expression) {
        return this.eval(expression, false);
    }

    private DevToolsMessage eval(String expression, boolean quickly) {
        DevToolsMessage dtm = this.evalOnce(expression, quickly, false);
        if (dtm.isResultError()) {
            String message = "js eval failed once:" + expression + ", error: " + dtm.getResult().getAsString();
            this.logger.warn(message, new Object[0]);
            this.options.sleep();
            dtm = this.evalOnce(expression, quickly, false);
            if (dtm.isResultError()) {
                message = "js eval failed twice:" + expression + ", error: " + dtm.getResult().getAsString();
                this.logger.error(message, new Object[0]);
                throw new RuntimeException(message);
            }
        }
        return dtm;
    }

    protected void retryIfEnabled(String locator) {
        if (this.options.isRetryEnabled()) {
            this.waitFor(locator);
        }
        if (this.options.highlight) {
            String highlightJs = this.options.highlight(locator, this.options.highlightDuration);
            this.evalOnce(highlightJs, true, true);
        }
    }

    protected int getRootNodeId() {
        return this.method("DOM.getDocument").param("depth", 0).send().getResult("root.nodeId", Integer.class);
    }

    @Override
    public Integer elementId(String locator) {
        DevToolsMessage dtm = this.method("DOM.querySelector").param("nodeId", this.getRootNodeId()).param("selector", locator).send();
        if (dtm.isResultError()) {
            return null;
        }
        return dtm.getResult("nodeId").getAsInt();
    }

    @Override
    public List elementIds(String locator) {
        if (locator.startsWith("/")) {
            this.getRootNodeId();
            DevToolsMessage dtm = this.method("DOM.performSearch").param("query", locator).send();
            String searchId = dtm.getResult("searchId", String.class);
            int resultCount = dtm.getResult("resultCount", Integer.class);
            dtm = this.method("DOM.getSearchResults").param("searchId", searchId).param("fromIndex", 0).param("toIndex", resultCount).send();
            return dtm.getResult("nodeIds", List.class);
        }
        DevToolsMessage dtm = this.method("DOM.querySelectorAll").param("nodeId", this.getRootNodeId()).param("selector", locator).send();
        if (dtm.isResultError()) {
            return Collections.EMPTY_LIST;
        }
        return dtm.getResult("nodeIds").getAsList();
    }

    @Override
    public DriverOptions getOptions() {
        return this.options;
    }

    @Override
    public void activate() {
        this.method("Target.activateTarget").param("targetId", this.rootFrameId).send();
    }

    protected void initWindowIdAndState() {
        DevToolsMessage dtm = this.method("Browser.getWindowForTarget").param("targetId", this.rootFrameId).send();
        if (!dtm.isResultError()) {
            this.windowId = dtm.getResult("windowId").getValue(Integer.class);
            this.windowState = (String)dtm.getResult("bounds").getAsMap().get("windowState");
        }
    }

    @Override
    public Map<String, Object> getDimensions() {
        DevToolsMessage dtm = this.method("Browser.getWindowForTarget").param("targetId", this.rootFrameId).send();
        Map<String, Object> map = dtm.getResult("bounds").getAsMap();
        Integer x = (Integer)map.remove("left");
        Integer y = (Integer)map.remove("top");
        map.put("x", x);
        map.put("y", y);
        return map;
    }

    @Override
    public void setDimensions(Map<String, Object> map) {
        Integer left = (Integer)map.remove("x");
        Integer top = (Integer)map.remove("y");
        map.put("left", left);
        map.put("top", top);
        Map<String, Object> temp = this.getDimensions();
        temp.putAll(map);
        temp.remove("windowState");
        this.method("Browser.setWindowBounds").param("windowId", this.windowId).param("bounds", temp).send();
    }

    @Override
    public void close() {
        this.method("Page.close").send();
    }

    @Override
    public void quit() {
        this.method("Target.closeTarget").param("targetId", this.rootFrameId).sendWithoutWaiting();
        this.client.close();
        if (this.command != null) {
            this.command.close(true);
        }
    }

    @Override
    public void setUrl(String url) {
        this.method("Page.navigate").param("url", url).send(DevToolsWait.ALL_FRAMES_LOADED);
    }

    @Override
    public void refresh() {
        this.method("Page.reload").send(DevToolsWait.ALL_FRAMES_LOADED);
    }

    @Override
    public void reload() {
        this.method("Page.reload").param("ignoreCache", true).send();
    }

    private void history(int delta) {
        DevToolsMessage dtm = this.method("Page.getNavigationHistory").send();
        int currentIndex = dtm.getResult("currentIndex").getValue(Integer.class);
        List list = dtm.getResult("entries").getValue(List.class);
        int targetIndex = currentIndex + delta;
        if (targetIndex < 0 || targetIndex == list.size()) {
            return;
        }
        Map entry = (Map)list.get(targetIndex);
        Integer id = (Integer)entry.get("id");
        this.method("Page.navigateToHistoryEntry").param("entryId", id).send(DevToolsWait.ALL_FRAMES_LOADED);
    }

    @Override
    public void back() {
        this.history(-1);
    }

    @Override
    public void forward() {
        this.history(1);
    }

    private void setWindowState(String state) {
        if (!"normal".equals(this.windowState)) {
            this.method("Browser.setWindowBounds").param("windowId", this.windowId).param("bounds", Collections.singletonMap("windowState", "normal")).send();
            this.windowState = "normal";
        }
        if (!state.equals(this.windowState)) {
            this.method("Browser.setWindowBounds").param("windowId", this.windowId).param("bounds", Collections.singletonMap("windowState", state)).send();
            this.windowState = state;
        }
    }

    @Override
    public void maximize() {
        this.setWindowState("maximized");
    }

    @Override
    public void minimize() {
        this.setWindowState("minimized");
    }

    @Override
    public void fullscreen() {
        this.setWindowState("fullscreen");
    }

    @Override
    public Element click(String locator) {
        this.retryIfEnabled(locator);
        this.eval(DriverOptions.selector(locator) + ".click()");
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public Element select(String locator, String text) {
        this.retryIfEnabled(locator);
        this.eval(this.options.optionSelector(locator, text));
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public Element select(String locator, int index) {
        this.retryIfEnabled(locator);
        this.eval(this.options.optionSelector(locator, index));
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public Driver submit() {
        this.submit = true;
        return this;
    }

    @Override
    public Element focus(String locator) {
        this.retryIfEnabled(locator);
        this.eval(this.options.focusJs(locator));
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public Element clear(String locator) {
        this.eval(DriverOptions.selector(locator) + ".value = ''");
        return DriverElement.locatorExists(this, locator);
    }

    private void sendKey(char c, int modifiers, String type, Integer keyCode) {
        DevToolsMessage dtm = this.method("Input.dispatchKeyEvent").param("modifiers", modifiers).param("type", type);
        if (keyCode == null) {
            dtm.param("text", c + "");
        } else {
            switch (keyCode) {
                case 13: {
                    dtm.param("text", "\r");
                    break;
                }
                case 9: {
                    if ("char".equals(type)) {
                        return;
                    }
                    dtm.param("text", "");
                    break;
                }
                case 46: {
                    if ("rawKeyDown".equals(type)) {
                        dtm.param("type", "keyDown");
                    }
                    dtm.param("text", ".");
                    break;
                }
                default: {
                    dtm.param("text", c + "");
                }
            }
            dtm.param("windowsVirtualKeyCode", keyCode);
        }
        dtm.send();
    }

    @Override
    public Element input(String locator, String value) {
        this.retryIfEnabled(locator);
        this.eval(this.options.focusJs(locator));
        Input input = new Input(value);
        while (input.hasNext()) {
            char c = input.next();
            int modifiers = input.getModifierFlags();
            Integer keyCode = Keys.code(c);
            if (keyCode != null) {
                this.sendKey(c, modifiers, "rawKeyDown", keyCode);
                this.sendKey(c, modifiers, "char", keyCode);
                this.sendKey(c, modifiers, "keyUp", keyCode);
                continue;
            }
            this.logger.warn("unknown character / key code: {}", Character.valueOf(c));
            this.sendKey(c, modifiers, "char", null);
        }
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public void actions(List<Map<String, Object>> sequence) {
        boolean submitRequested = this.submit;
        this.submit = false;
        for (Map<String, Object> map : sequence) {
            List actions = (List)map.get("actions");
            if (actions == null) {
                this.logger.warn("no actions property found: {}", sequence);
                return;
            }
            Iterator iterator = actions.iterator();
            while (iterator.hasNext()) {
                String chromeType;
                Map action = (Map)iterator.next();
                String type = (String)action.get("type");
                if (type == null) {
                    this.logger.warn("no type property found: {}", action);
                    continue;
                }
                switch (type) {
                    case "pointerMove": {
                        chromeType = "mouseMoved";
                        break;
                    }
                    case "pointerDown": {
                        chromeType = "mousePressed";
                        break;
                    }
                    case "pointerUp": {
                        chromeType = "mouseReleased";
                        break;
                    }
                    default: {
                        chromeType = null;
                    }
                }
                if (chromeType == null) {
                    this.logger.warn("unexpected action type: {}", action);
                    continue;
                }
                Integer x = (Integer)action.get("x");
                Integer y = (Integer)action.get("y");
                if (x != null) {
                    this.currentMouseXpos = x;
                }
                if (y != null) {
                    this.currentMouseYpos = y;
                }
                Integer duration = (Integer)action.get("duration");
                DevToolsMessage toSend = this.method("Input.dispatchMouseEvent").param("type", chromeType).param("x", this.currentMouseXpos).param("y", this.currentMouseYpos);
                if ("mousePressed".equals(chromeType) || "mouseReleased".equals(chromeType)) {
                    toSend.param("button", "left").param("clickCount", 1);
                }
                if (!iterator.hasNext() && submitRequested) {
                    this.submit = true;
                }
                toSend.send();
                if (duration == null) continue;
                this.options.sleep(duration);
            }
        }
    }

    @Override
    public String text(String id) {
        return this.property(id, "textContent");
    }

    private <T> T callFunctionOnNode(int nodeId, String function, Class<T> type) {
        DevToolsMessage dtm = this.method("DOM.resolveNode").param("nodeId", nodeId).send();
        String objectId = dtm.getResult("object.objectId", String.class);
        return this.callFunctionOnObject(objectId, function, type);
    }

    private <T> T callFunctionOnObject(String objectId, String function, Class<T> type) {
        DevToolsMessage dtm = this.method("Runtime.callFunctionOn").param("objectId", objectId).param("functionDeclaration", function).send();
        return dtm.getResult().getValue(type);
    }

    @Override
    public String html(String id) {
        return this.property(id, "outerHTML");
    }

    @Override
    public String value(String locator) {
        return this.property(locator, "value");
    }

    @Override
    public Element value(String locator, String value) {
        this.retryIfEnabled(locator);
        this.eval(DriverOptions.selector(locator) + ".value = '" + value + "'");
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public String attribute(String id, String name) {
        this.retryIfEnabled(id);
        DevToolsMessage dtm = this.eval(DriverOptions.selector(id) + ".getAttribute('" + name + "')");
        return dtm.getResult().getAsString();
    }

    @Override
    public String property(String id, String name) {
        this.retryIfEnabled(id);
        DevToolsMessage dtm = this.eval(DriverOptions.selector(id) + "['" + name + "']");
        return dtm.getResult().getAsString();
    }

    @Override
    public boolean enabled(String id) {
        this.retryIfEnabled(id);
        DevToolsMessage dtm = this.eval(DriverOptions.selector(id) + ".disabled");
        return !dtm.getResult().isBooleanTrue();
    }

    @Override
    public boolean waitUntil(String expression) {
        return this.options.retry(() -> {
            try {
                return this.eval(expression, true).getResult().isBooleanTrue();
            }
            catch (Exception e) {
                this.logger.warn("waitUntil evaluate failed: {}", e.getMessage());
                return false;
            }
        }, b -> b, "waitUntil (js)", true);
    }

    @Override
    public Object script(String expression) {
        return this.eval(expression).getResult().getValue();
    }

    @Override
    public String getTitle() {
        DevToolsMessage dtm = this.eval("document.title");
        return dtm.getResult().getAsString();
    }

    @Override
    public String getUrl() {
        return this.currentUrl;
    }

    @Override
    public List<Map> getCookies() {
        DevToolsMessage dtm = this.method("Network.getAllCookies").send();
        return dtm.getResult("cookies").getAsList();
    }

    @Override
    public Map<String, Object> cookie(String name) {
        List<Map> list = this.getCookies();
        if (list == null) {
            return null;
        }
        for (Map map : list) {
            if (map == null || !name.equals(map.get("name"))) continue;
            return map;
        }
        return null;
    }

    @Override
    public void cookie(Map<String, Object> cookie) {
        if (cookie.get("url") == null && cookie.get("domain") == null) {
            cookie = new HashMap<String, Object>(cookie);
            cookie.put("url", this.currentUrl);
        }
        this.method("Network.setCookie").params(cookie).send();
    }

    @Override
    public void deleteCookie(String name) {
        this.method("Network.deleteCookies").param("name", name).param("url", this.currentUrl).send();
    }

    @Override
    public void clearCookies() {
        this.method("Network.clearBrowserCookies").send();
    }

    @Override
    public void dialog(boolean accept) {
        this.dialog(accept, null);
    }

    @Override
    public void dialog(boolean accept, String text) {
        DevToolsMessage temp = this.method("Page.handleJavaScriptDialog").param("accept", accept);
        if (text == null) {
            temp.send();
        } else {
            temp.param("promptText", text).send();
        }
    }

    @Override
    public String getDialog() {
        return this.currentDialogText;
    }

    public byte[] pdf(Map<String, Object> options) {
        DevToolsMessage dtm = this.method("Page.printToPDF").params(options).send();
        String temp = dtm.getResult("data").getAsString();
        return Base64.getDecoder().decode(temp);
    }

    @Override
    public byte[] screenshot(boolean embed) {
        return this.screenshot(null, embed);
    }

    @Override
    public Map<String, Object> position(String locator) {
        boolean submitTemp = this.submit;
        this.submit = false;
        this.retryIfEnabled(locator);
        String expression = DriverOptions.selector(locator) + ".getBoundingClientRect()";
        DevToolsMessage dtm = this.method("Runtime.evaluate").param("expression", expression).send();
        String objectId = dtm.getResult("objectId").getAsString();
        dtm = this.method("Runtime.getProperties").param("objectId", objectId).param("accessorPropertiesOnly", true).send();
        this.submit = submitTemp;
        return this.options.newMapWithSelectedKeys(dtm.getResult().getAsMap(), "x", "y", "width", "height");
    }

    @Override
    public byte[] screenshot(String id, boolean embed) {
        DevToolsMessage dtm;
        if (id == null) {
            dtm = this.method("Page.captureScreenshot").send();
        } else {
            Map<String, Object> map = this.position(id);
            map.put("scale", 1);
            dtm = this.method("Page.captureScreenshot").param("clip", map).send();
        }
        String temp = dtm.getResult("data").getAsString();
        byte[] bytes = Base64.getDecoder().decode(temp);
        if (embed) {
            this.options.embedPngImage(bytes);
        }
        return bytes;
    }

    public byte[] screenshotFull() {
        DevToolsMessage layout = this.method("Page.getLayoutMetrics").send();
        Map<String, Object> size = layout.getResult("contentSize").getAsMap();
        Map<String, Object> map = this.options.newMapWithSelectedKeys(size, "height", "width");
        map.put("x", 0);
        map.put("y", 0);
        map.put("scale", 1);
        DevToolsMessage dtm = this.method("Page.captureScreenshot").param("clip", map).send();
        if (dtm.isResultError()) {
            this.logger.error("unable to capture screenshot: {}", dtm);
            return new byte[0];
        }
        String temp = dtm.getResult("data").getAsString();
        return Base64.getDecoder().decode(temp);
    }

    @Override
    public List<String> getPages() {
        DevToolsMessage dtm = this.method("Target.getTargets").send();
        return dtm.getResult("targetInfos.targetId").getAsList();
    }

    @Override
    public void switchPage(String titleOrUrl) {
        if (titleOrUrl == null) {
            return;
        }
        DevToolsMessage dtm = this.method("Target.getTargets").send();
        List targets = dtm.getResult("targetInfos").getAsList();
        String targetId = null;
        String targetUrl = null;
        for (Map map : targets) {
            String title = (String)map.get("title");
            String url = (String)map.get("url");
            if ((title == null || !title.contains(titleOrUrl)) && (url == null || !url.contains(titleOrUrl))) continue;
            targetId = (String)map.get("targetId");
            targetUrl = url;
            break;
        }
        if (targetId != null) {
            this.method("Target.activateTarget").param("targetId", targetId).send();
            this.currentUrl = targetUrl;
        } else {
            this.logger.warn("failed to switch page to {}", titleOrUrl);
        }
    }

    @Override
    public void switchPage(int index) {
        if (index == -1) {
            return;
        }
        DevToolsMessage dtm = this.method("Target.getTargets").send();
        List targets = dtm.getResult("targetInfos").getAsList();
        if (index < targets.size()) {
            Map target = (Map)targets.get(index);
            String targetId = (String)target.get("targetId");
            this.method("Target.activateTarget").param("targetId", targetId).send();
            this.currentUrl = (String)target.get("url");
        } else {
            this.logger.warn("failed to switch frame by index: {}", index);
        }
    }

    @Override
    public void switchFrame(int index) {
        if (index == -1) {
            this.executionContextId = null;
            this.sessionId = null;
            return;
        }
        List ids = this.elementIds("iframe,frame");
        if (index < ids.size()) {
            Integer nodeId = (Integer)ids.get(index);
            this.setExecutionContext(nodeId, index);
        } else {
            this.logger.warn("unable to switch frame by index: {}", index);
        }
    }

    @Override
    public void switchFrame(String locator) {
        if (locator == null) {
            this.executionContextId = null;
            this.sessionId = null;
            return;
        }
        this.retryIfEnabled(locator);
        Integer nodeId = this.elementId(locator);
        if (nodeId == null) {
            return;
        }
        this.setExecutionContext(nodeId, locator);
    }

    private void setExecutionContext(int nodeId, Object locator) {
        DevToolsMessage dtm = this.method("DOM.describeNode").param("nodeId", nodeId).param("depth", 0).send();
        String frameId = dtm.getResult("node.frameId", String.class);
        if (frameId == null) {
            this.logger.warn("unable to find frame by nodeId: {}", locator);
            return;
        }
        this.sessionId = this.frameSessions.get(frameId);
        if (this.sessionId != null) {
            this.logger.trace("found out-of-process frame - session: {} - {}", frameId, this.sessionId);
            return;
        }
        dtm = this.method("Page.createIsolatedWorld").param("frameId", frameId).send();
        this.executionContextId = dtm.getResult("executionContextId").getValue(Integer.class);
        if (this.executionContextId == null) {
            this.logger.warn("execution context is null, unable to switch frame by locator: {}", locator);
        }
    }

    public void enableNetworkEvents() {
        this.method("Network.enable").send();
    }

    public void enablePageEvents() {
        this.method("Page.enable").send();
    }

    public void enableRuntimeEvents() {
        this.method("Runtime.enable").send();
    }

    public void enableTargetEvents() {
        this.method("Target.setAutoAttach").param("autoAttach", true).param("waitForDebuggerOnStart", false).param("flatten", true).send();
    }

    public void intercept(Map<String, Object> config) {
        List patterns = (List)(config = new ScriptValue(config).getAsMap()).get("patterns");
        if (patterns == null) {
            throw new RuntimeException("missing array argument 'patterns': " + config);
        }
        if (this.backend != null) {
            throw new RuntimeException("'intercept()' can be called only once");
        }
        ScenarioContext context = this.getOptions().getContext();
        String mock = (String)config.get("mock");
        if (mock == null) {
            throw new RuntimeException("missing argument 'mock': " + config);
        }
        ScriptValue mockSv = FileUtils.readFile(mock, context);
        if (!mockSv.isFeature()) {
            throw new RuntimeException("'mock' is not a feature file: " + config + ", " + mockSv);
        }
        Feature feature = mockSv.getValue(Feature.class);
        this.backend = new FeaturesBackend(feature);
        this.method("Fetch.enable").param("patterns", patterns).send();
    }

    public void inputFile(String locator, String ... relativePaths) {
        ArrayList<String> files = new ArrayList<String>(relativePaths.length);
        ScriptBridge bridge = this.options.getContext().bindings.bridge;
        for (String p : relativePaths) {
            files.add(bridge.toAbsolutePath(p));
        }
        Integer nodeId = this.elementId(locator);
        this.method("DOM.setFileInputFiles").param("files", files).param("nodeId", nodeId).send();
    }
}

