/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.AssertionResult;
import com.intuit.karate.AssignType;
import com.intuit.karate.CallContext;
import com.intuit.karate.Config;
import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.LogAppender;
import com.intuit.karate.Logger;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptBindings;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.ScriptValueMap;
import com.intuit.karate.StepActions;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.Embed;
import com.intuit.karate.core.Engine;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.FeatureParser;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.MatchType;
import com.intuit.karate.core.PerfEvent;
import com.intuit.karate.core.Plugin;
import com.intuit.karate.core.PluginFactory;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioExecutionUnit;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.core.Tags;
import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Key;
import com.intuit.karate.exception.KarateException;
import com.intuit.karate.exception.KarateFileNotFoundException;
import com.intuit.karate.http.Cookie;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpRequestBuilder;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.MultiPartItem;
import com.intuit.karate.http.MultiValuedMap;
import com.intuit.karate.netty.WebSocketClient;
import com.intuit.karate.netty.WebSocketOptions;
import com.intuit.karate.shell.Command;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ScenarioContext {
    public Logger logger;
    public LogAppender appender;
    public final ScriptBindings bindings;
    public final int callDepth;
    public final boolean reuseParentContext;
    public final ScenarioContext parentContext;
    public final List<String> tags;
    public final Map<String, List<String>> tagValues;
    public final ScriptValueMap vars;
    public final FeatureContext rootFeatureContext;
    public final FeatureContext featureContext;
    public final Collection<ExecutionHook> executionHooks;
    public final boolean perfMode;
    public final ClassLoader classLoader;
    public final Function<String, Object> read = s -> {
        ScriptValue sv = FileUtils.readFile(s, this);
        if (sv.isXml()) {
            return sv.getValue();
        }
        return sv.getAfterConvertingFromJsonOrXmlIfNeeded();
    };
    private Config config;
    private HttpClient client;
    private Driver driver;
    private Plugin robot;
    private HttpRequestBuilder request = new HttpRequestBuilder();
    private HttpRequest prevRequest;
    private HttpResponse prevResponse;
    private boolean reportDisabled;
    private List<FeatureResult> callResults;
    private PerfEvent prevPerfEvent;
    private List<Embed> prevEmbeds;
    private ScenarioExecutionUnit executionUnit;
    private final Object LOCK = new Object();
    private Object signalResult;
    private List<WebSocketClient> webSocketClients;

    public void setLogger(Logger logger) {
        this.logger = logger;
        this.appender = logger.getAppender();
    }

    public void logLastPerfEvent(String failureMessage) {
        if (this.prevPerfEvent != null && this.executionHooks != null) {
            if (failureMessage != null) {
                this.prevPerfEvent.setFailed(true);
                this.prevPerfEvent.setMessage(failureMessage);
            }
            this.executionHooks.forEach(h -> h.reportPerfEvent(this.prevPerfEvent));
        }
        this.prevPerfEvent = null;
    }

    public void capturePerfEvent(PerfEvent event) {
        this.logLastPerfEvent(null);
        this.prevPerfEvent = event;
    }

    public List<FeatureResult> getAndClearCallResults() {
        List<FeatureResult> temp = this.callResults;
        this.callResults = null;
        return temp;
    }

    public void addCallResult(FeatureResult result) {
        ScenarioContext threadContext = Engine.THREAD_CONTEXT.get();
        if (threadContext != null) {
            threadContext.addCallResultInternal(result);
        } else {
            this.addCallResultInternal(result);
        }
    }

    private void addCallResultInternal(FeatureResult callResult) {
        if (this.callResults == null) {
            this.callResults = new ArrayList<FeatureResult>();
        }
        this.callResults.add(callResult);
    }

    public ScenarioExecutionUnit getExecutionUnit() {
        return this.executionUnit;
    }

    public void setExecutionUnit(ScenarioExecutionUnit executionUnit) {
        this.executionUnit = executionUnit;
    }

    public void setPrevRequest(HttpRequest prevRequest) {
        this.prevRequest = prevRequest;
    }

    public void setPrevResponse(HttpResponse prevResponse) {
        this.prevResponse = prevResponse;
    }

    public HttpRequestBuilder getRequestBuilder() {
        return this.request;
    }

    public HttpRequest getPrevRequest() {
        return this.prevRequest;
    }

    public HttpResponse getPrevResponse() {
        return this.prevResponse;
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public int getCallDepth() {
        return this.callDepth;
    }

    public FeatureContext getFeatureContext() {
        return this.featureContext;
    }

    public Config getConfig() {
        return this.config;
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.classLoader.getResourceAsStream(name);
    }

    private static Map<String, Object> info(ScenarioContext context) {
        ScenarioExecutionUnit unit;
        HashMap<String, Object> info = new HashMap<String, Object>(6);
        Path featurePath = context.featureContext.feature.getPath();
        if (featurePath != null) {
            info.put("featureDir", featurePath.getParent().toString());
            info.put("featureFileName", featurePath.getFileName().toString());
        }
        if ((unit = context.executionUnit) != null) {
            info.put("scenarioName", unit.scenario.getName());
            info.put("scenarioDescription", unit.scenario.getDescription());
            info.put("scenarioType", unit.scenario.getKeyword());
            String errorMessage = unit.getError() == null ? null : unit.getError().getMessage();
            info.put("errorMessage", errorMessage);
        }
        return info;
    }

    public Map<String, Object> getScenarioInfo() {
        ScenarioContext threadContext = Engine.THREAD_CONTEXT.get();
        if (threadContext != null) {
            return ScenarioContext.info(threadContext);
        }
        return ScenarioContext.info(this);
    }

    public boolean hotReload() {
        boolean success = false;
        Scenario scenario = this.executionUnit.scenario;
        Feature feature = scenario.getFeature();
        feature = FeatureParser.parse(feature.getResource());
        for (Step oldStep : this.executionUnit.getSteps()) {
            String newText;
            String oldText;
            Step newStep = feature.findStepByLine(oldStep.getLine());
            if (newStep == null || (oldText = oldStep.getText()).equals(newText = newStep.getText())) continue;
            try {
                FeatureParser.updateStepFromText(oldStep, newStep.getText());
                this.logger.info("hot reloaded line: {} - {}", newStep.getLine(), newStep.getText());
                success = true;
            }
            catch (Exception e) {
                this.logger.warn("failed to hot reload step: {}", e.getMessage());
            }
        }
        return success;
    }

    public void updateConfigCookies(Map<String, Cookie> cookies) {
        if (cookies == null) {
            return;
        }
        if (this.config.getCookies().isNull()) {
            this.config.setCookies(new ScriptValue(cookies));
        } else {
            Map<String, Object> map = this.config.getCookies().evalAsMap(this);
            map.putAll(cookies);
            this.config.setCookies(new ScriptValue(map));
        }
    }

    public boolean isReportDisabled() {
        return this.reportDisabled;
    }

    public void setReportDisabled(boolean reportDisabled) {
        this.reportDisabled = reportDisabled;
    }

    public boolean isPrintEnabled() {
        return this.config.isPrintEnabled();
    }

    public ScenarioContext(FeatureContext featureContext, CallContext call, Scenario scenario, LogAppender appender) {
        this(featureContext, call, null, scenario, appender);
    }

    public ScenarioContext(FeatureContext featureContext, CallContext call, ClassLoader classLoader, Scenario scenario, LogAppender appender) {
        this.featureContext = featureContext;
        this.classLoader = classLoader == null ? ScenarioContext.resolveClassLoader(call) : classLoader;
        this.logger = new Logger();
        if (appender == null) {
            appender = LogAppender.NO_OP;
        }
        this.logger.setAppender(appender);
        this.appender = appender;
        this.callDepth = call.callDepth;
        this.reuseParentContext = call.reuseParentContext;
        this.executionHooks = call.executionHooks;
        this.perfMode = call.perfMode;
        if (scenario != null) {
            Tags tagsEffective = scenario.getTagsEffective();
            this.tags = tagsEffective.getTags();
            this.tagValues = tagsEffective.getTagValues();
        } else {
            this.tags = null;
            this.tagValues = null;
        }
        if (this.reuseParentContext) {
            this.parentContext = call.context;
            this.vars = call.context.vars;
            this.config = call.context.config;
            this.rootFeatureContext = call.context.rootFeatureContext;
            this.webSocketClients = call.context.webSocketClients;
        } else if (call.context != null) {
            this.parentContext = call.context;
            this.vars = call.context.vars.copy(false);
            this.config = new Config(call.context.config);
            this.rootFeatureContext = call.context.rootFeatureContext;
        } else {
            this.parentContext = null;
            this.vars = new ScriptValueMap();
            this.config = new Config();
            this.config.setClientClass(call.httpClientClass);
            this.rootFeatureContext = featureContext;
        }
        this.client = HttpClient.construct(this.config, this);
        this.bindings = new ScriptBindings(this);
        if (call.context != null) {
            if (call.context.driver != null) {
                this.setDriver(call.context.driver);
            }
            if (call.context.robot != null) {
                this.setRobot(call.context.robot);
            }
        }
        if (call.context == null && call.evalKarateConfig) {
            try {
                Script.callAndUpdateConfigAndAlsoVarsIfMapReturned(false, ScriptBindings.READ_KARATE_CONFIG_BASE, null, this);
            }
            catch (Exception e) {
                if (e instanceof KarateFileNotFoundException) {
                    this.logger.trace("skipping 'classpath:karate-base.js': {}", e.getMessage());
                }
                throw new RuntimeException("evaluation of 'classpath:karate-base.js' failed", e);
            }
            String configDir = System.getProperty("karate.config.dir");
            String configScript = ScriptBindings.readKarateConfigForEnv(true, configDir, null);
            try {
                Script.callAndUpdateConfigAndAlsoVarsIfMapReturned(false, configScript, null, this);
            }
            catch (Exception e) {
                if (e instanceof KarateFileNotFoundException) {
                    this.logger.warn("skipping bootstrap configuration: {}", e.getMessage());
                }
                String message = "evaluation of 'karate-config.js' failed: " + e.getMessage();
                this.logger.error("{}", message);
                throw new RuntimeException(message, e);
            }
            if (featureContext.env != null) {
                configScript = ScriptBindings.readKarateConfigForEnv(false, configDir, featureContext.env);
                try {
                    Script.callAndUpdateConfigAndAlsoVarsIfMapReturned(false, configScript, null, this);
                }
                catch (Exception e) {
                    if (e instanceof KarateFileNotFoundException) {
                        this.logger.trace("skipping bootstrap configuration for env: {} - {}", featureContext.env, e.getMessage());
                    }
                    throw new RuntimeException("evaluation of 'karate-config-" + featureContext.env + ".js' failed", e);
                }
            }
        }
        if (call.callArg != null) {
            call.callArg.forEach((k, v) -> this.vars.put((String)k, v));
            this.vars.put("__arg", call.callArg);
            this.vars.put("__loop", (Object)call.loopIndex);
        } else if (call.context != null) {
            this.vars.put("__arg", ScriptValue.NULL);
            this.vars.put("__loop", (Object)-1);
        }
        this.logger.trace("karate context init - initial properties: {}", this.vars);
    }

    private static ClassLoader resolveClassLoader(CallContext call) {
        if (call.context == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return call.context.classLoader;
    }

    public ScenarioContext copy() {
        return new ScenarioContext(this);
    }

    private ScenarioContext(ScenarioContext sc) {
        this.featureContext = sc.featureContext;
        this.classLoader = sc.classLoader;
        this.logger = sc.logger;
        this.appender = sc.appender;
        this.callDepth = sc.callDepth;
        this.reuseParentContext = sc.reuseParentContext;
        this.parentContext = sc.parentContext;
        this.executionHooks = sc.executionHooks;
        this.perfMode = sc.perfMode;
        this.tags = sc.tags;
        this.tagValues = sc.tagValues;
        this.vars = sc.vars.copy(true);
        this.config = new Config(sc.config);
        this.rootFeatureContext = sc.rootFeatureContext;
        this.client = HttpClient.construct(this.config, this);
        this.bindings = new ScriptBindings(this);
        this.request = sc.request.copy();
        this.prevRequest = sc.prevRequest;
        this.prevResponse = sc.prevResponse;
        this.prevPerfEvent = sc.prevPerfEvent;
        this.callResults = sc.callResults;
        this.prevEmbeds = sc.prevEmbeds;
        this.webSocketClients = sc.webSocketClients;
        this.signalResult = sc.signalResult;
        if (sc.driver != null) {
            this.setDriver(sc.driver);
        }
        if (sc.robot != null) {
            this.setRobot(sc.robot);
        }
    }

    public void configure(Config config) {
        this.config = config;
        this.client = HttpClient.construct(config, this);
    }

    public void configure(String key, ScriptValue value) {
        if (this.config.configure(key = StringUtils.trimToEmpty(key), value)) {
            if (key.startsWith("httpClient")) {
                this.client = HttpClient.construct(this.config, this);
            } else {
                this.client.configure(this.config, this);
            }
        }
    }

    private List<String> evalList(List<String> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        try {
            for (String value : values) {
                ScriptValue temp = Script.evalKarateExpression(value, this);
                list.add(temp.getAsString());
            }
        }
        catch (Exception e) {
            String joined = StringUtils.join(values, ',');
            ScriptValue temp = Script.evalKarateExpression(joined, this);
            if (temp.isListLike()) {
                return temp.getAsList();
            }
            return Collections.singletonList(temp.getAsString());
        }
        return list;
    }

    private Map<String, Object> evalMapExpr(String expr) {
        ScriptValue value = Script.evalKarateExpression(expr, this);
        if (!value.isMapLike()) {
            throw new KarateException("cannot convert to map: " + expr);
        }
        return value.getAsMap();
    }

    private String getVarAsString(String name) {
        ScriptValue sv = (ScriptValue)this.vars.get(name);
        if (sv == null) {
            throw new RuntimeException("no variable found with name: " + name);
        }
        return sv.getAsString();
    }

    private static String asString(Map<String, Object> map, String key) {
        Object o = map.get(key);
        return o == null ? null : o.toString();
    }

    public void updateResponseVars() {
        this.vars.put("responseStatus", (Object)this.prevResponse.getStatus());
        this.vars.put("requestTimeStamp", (Object)this.prevResponse.getStartTime());
        this.vars.put("responseTime", (Object)this.prevResponse.getResponseTime());
        this.vars.put("responseCookies", this.prevResponse.getCookies());
        MultiValuedMap responseHeaders = this.prevResponse.getHeaders();
        if (this.config.isLowerCaseResponseHeaders() && responseHeaders != null) {
            responseHeaders = responseHeaders.tolowerCaseKeys();
        }
        this.vars.put("responseHeaders", responseHeaders);
        byte[] responseBytes = this.prevResponse.getBody();
        this.bindings.putAdditionalVariable("responseBytes", responseBytes);
        String responseString = FileUtils.toString(responseBytes);
        Object responseBody = responseString;
        responseString = StringUtils.trimToEmpty(responseString);
        if (Script.isJson(responseString)) {
            try {
                responseBody = JsonUtils.toJsonDocStrict(responseString);
                this.vars.put("responseType", "json");
            }
            catch (Exception e) {
                this.vars.put("responseType", "string");
                this.logger.warn("json parsing failed, response data type set to string: {}", e.getMessage());
            }
        } else if (Script.isXml(responseString)) {
            try {
                responseBody = XmlUtils.toXmlDoc(responseString);
                this.vars.put("responseType", "xml");
            }
            catch (Exception e) {
                this.vars.put("responseType", "string");
                this.logger.warn("xml parsing failed, response data type set to string: {}", e.getMessage());
            }
        } else {
            this.vars.put("responseType", "string");
        }
        this.vars.put("response", responseBody);
    }

    public void invokeAfterHookIfConfigured(boolean afterFeature) {
        ScriptValue sv;
        if (this.callDepth > 0) {
            return;
        }
        ScriptValue scriptValue = sv = afterFeature ? this.config.getAfterFeature() : this.config.getAfterScenario();
        if (sv.isFunction()) {
            try {
                Engine.THREAD_CONTEXT.set(this);
                sv.invokeFunction(this, null);
                Engine.THREAD_CONTEXT.set(null);
            }
            catch (Exception e) {
                String prefix = afterFeature ? "afterFeature" : "afterScenario";
                this.logger.warn("{} hook failed: {}", prefix, e.getMessage());
            }
        }
    }

    public Result evalAsStep(String expression) {
        Scenario scenario = this.executionUnit.scenario;
        Step evalStep = new Step(scenario.getFeature(), scenario, scenario.getIndex() + 1);
        try {
            FeatureParser.updateStepFromText(evalStep, expression);
        }
        catch (Exception e) {
            return Result.failed(0L, e, evalStep);
        }
        StepActions evalActions = new StepActions(this);
        return Engine.executeStep(evalStep, evalActions);
    }

    public void configure(String key, String exp) {
        this.configure(key, Script.evalKarateExpression(exp, this));
    }

    public void url(String expression) {
        String temp = Script.evalKarateExpression(expression, this).getAsString();
        this.request.setUrl(temp);
    }

    public void path(List<String> paths) {
        for (String path : paths) {
            ScriptValue temp = Script.evalKarateExpression(path, this);
            if (temp.isListLike()) {
                List list = temp.getAsList();
                for (Object o : list) {
                    if (o == null) continue;
                    this.request.addPath(o.toString());
                }
                continue;
            }
            this.request.addPath(temp.getAsString());
        }
    }

    public void param(String name, List<String> values) {
        this.request.setParam(name, this.evalList(values));
    }

    public void params(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object temp = entry.getValue();
            if (temp == null) {
                this.request.removeParam(key);
                continue;
            }
            if (temp instanceof List) {
                this.request.setParam(key, (List)temp);
                continue;
            }
            this.request.setParam(key, temp.toString());
        }
    }

    public void cookie(String name, String value) {
        Cookie cookie;
        ScriptValue sv = Script.evalKarateExpression(value, this);
        if (sv.isMapLike()) {
            cookie = new Cookie((Map<String, String>)sv.getAsMap());
            cookie.put("name", name);
        } else {
            cookie = new Cookie(name, sv.getAsString());
        }
        this.request.setCookie(cookie);
    }

    public void cookies(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object temp = entry.getValue();
            if (temp == null) {
                this.request.removeCookie(key);
                continue;
            }
            this.request.setCookie(new Cookie(key, temp.toString()));
        }
    }

    public void header(String name, List<String> values) {
        this.request.setHeader(name, this.evalList(values));
    }

    public void headers(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object temp = entry.getValue();
            if (temp == null) {
                this.request.removeHeader(key);
                continue;
            }
            if (temp instanceof List) {
                this.request.setHeader(key, (List)temp);
                continue;
            }
            this.request.setHeader(key, temp.toString());
        }
    }

    public void formField(String name, List<String> values) {
        this.request.setFormField(name, this.evalList(values));
    }

    public void formFields(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object temp = entry.getValue();
            if (temp == null) {
                this.request.removeFormField(key);
                continue;
            }
            if (temp instanceof List) {
                this.request.setFormField(key, (List)temp);
                continue;
            }
            this.request.setFormField(key, temp.toString());
        }
    }

    public void request(ScriptValue body) {
        this.request.setBody(body);
    }

    public void request(String requestBody) {
        ScriptValue temp = Script.evalKarateExpression(requestBody, this);
        this.request(temp);
    }

    public void table(String name, List<Map<String, String>> table) {
        int pos = name.indexOf(61);
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        List<Map<String, Object>> list = Script.evalTable(table, this);
        DocumentContext doc = JsonPath.parse(list);
        this.vars.put(name.trim(), doc);
    }

    public void replace(String name, List<Map<String, String>> table) {
        name = name.trim();
        String text = this.getVarAsString(name);
        String replaced = Script.replacePlaceholders(text, table, this);
        this.vars.put(name, replaced);
    }

    public void replace(String name, String token, String value) {
        name = name.trim();
        String text = this.getVarAsString(name);
        String replaced = Script.replacePlaceholderText(text, token, value, this);
        this.vars.put(name, replaced);
    }

    public void assign(AssignType assignType, String name, String exp) {
        Script.assign(assignType, name, exp, this, true);
    }

    public void assertTrue(String expression) {
        AssertionResult ar = Script.assertBoolean(expression, this);
        if (!ar.pass) {
            this.logger.error("{}", ar);
            throw new KarateException(ar.message);
        }
    }

    private void clientInvoke() {
        try {
            this.prevResponse = this.client.invoke(this.request, this);
            this.updateResponseVars();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.logger.error("http request failed: {}", message);
            throw new KarateException(message);
        }
    }

    private void clientInvokeWithRetries() {
        int maxRetries = this.config.getRetryCount();
        int sleep = this.config.getRetryInterval();
        int retryCount = 0;
        while (true) {
            ScriptValue sv;
            if (retryCount == maxRetries) {
                throw new KarateException("too many retry attempts: " + maxRetries);
            }
            if (retryCount > 0) {
                try {
                    this.logger.debug("sleeping before retry #{}", retryCount);
                    Thread.sleep(sleep);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.clientInvoke();
            try {
                sv = Script.evalKarateExpression(this.request.getRetryUntil(), this);
            }
            catch (Exception e) {
                this.logger.warn("retry condition evaluation failed: {}", e.getMessage());
                sv = ScriptValue.NULL;
            }
            if (sv.isBooleanTrue()) {
                if (retryCount <= 0) break;
                this.logger.debug("retry condition satisfied", new Object[0]);
                break;
            }
            this.logger.debug("retry condition not satisfied: {}", this.request.getRetryUntil());
            ++retryCount;
        }
    }

    public void method(String method) {
        if (!HttpUtils.HTTP_METHODS.contains(method.toUpperCase())) {
            method = Script.evalKarateExpression(method, this).getAsString();
        }
        this.request.setMethod(method);
        if (this.request.isRetry()) {
            this.clientInvokeWithRetries();
        } else {
            this.clientInvoke();
        }
        String prevUrl = this.request.getUrl();
        this.request = new HttpRequestBuilder();
        this.request.setUrl(prevUrl);
    }

    public void retry(String expression) {
        this.request.setRetryUntil(expression);
    }

    public void soapAction(String action) {
        if ((action = Script.evalKarateExpression(action, this).getAsString()) == null) {
            action = "";
        }
        this.request.setHeader("SOAPAction", action);
        this.request.setHeader("Content-Type", "text/xml");
        this.method("post");
    }

    public void multipartField(String name, String value) {
        ScriptValue sv = Script.evalKarateExpression(value, this);
        this.request.addMultiPartItem(name, sv);
    }

    public void multipartFields(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        map.forEach((k, v) -> {
            ScriptValue sv = new ScriptValue(v);
            this.request.addMultiPartItem((String)k, sv);
        });
    }

    public void multipartFile(String name, String value) {
        Object o;
        name = name.trim();
        ScriptValue sv = Script.evalKarateExpression(value, this);
        if (!sv.isMapLike()) {
            throw new RuntimeException("mutipart file value should be json");
        }
        Map<String, Object> map = sv.getAsMap();
        String read = ScenarioContext.asString(map, "read");
        ScriptValue fileValue = read == null ? ((o = map.get("value")) == null ? null : new ScriptValue(o)) : FileUtils.readFile(read, this);
        if (fileValue == null) {
            throw new RuntimeException("mutipart file json should have a value for 'read' or 'value'");
        }
        MultiPartItem item = new MultiPartItem(name, fileValue);
        String filename = ScenarioContext.asString(map, "filename");
        item.setFilename(filename);
        String contentType = ScenarioContext.asString(map, "contentType");
        if (contentType != null) {
            item.setContentType(contentType);
        }
        this.request.addMultiPartItem(item);
    }

    public void multipartFiles(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        map.forEach((k, v) -> {
            ScriptValue sv = new ScriptValue(v);
            this.multipartFile((String)k, sv.getAsString());
        });
    }

    public void print(List<String> exps) {
        if (this.isPrintEnabled()) {
            String prev = "";
            StringBuilder sb = new StringBuilder();
            sb.append("[print]");
            for (String exp : exps) {
                if (!prev.isEmpty()) {
                    exp = prev + StringUtils.trimToNull(exp);
                }
                if (exp == null) {
                    sb.append("null");
                    continue;
                }
                ScriptValue sv = Script.getIfVariableReference(exp.trim(), this);
                if (sv == null) {
                    try {
                        sv = Script.evalJsExpression(exp, this);
                        prev = "";
                    }
                    catch (Exception e) {
                        prev = exp + ", ";
                        continue;
                    }
                }
                sb.append(' ').append(sv.getAsPrettyString());
            }
            this.logger.info("{}", sb);
        }
    }

    public void status(int status) {
        if (status != this.prevResponse.getStatus()) {
            String rawResponse = ((ScriptValue)this.vars.get("response")).getAsString();
            String responseTime = ((ScriptValue)this.vars.get("responseTime")).getAsString();
            String message = "status code was: " + this.prevResponse.getStatus() + ", expected: " + status + ", response time: " + responseTime + ", url: " + this.prevResponse.getUri() + ", response: " + rawResponse;
            this.logger.error(message, new Object[0]);
            throw new KarateException(message);
        }
    }

    public void match(MatchType matchType, String name, String path, String expected) {
        AssertionResult ar = Script.matchNamed(matchType, name, path, expected, this);
        if (!ar.pass) {
            this.logger.error("{}", ar);
            throw new KarateException(ar.message);
        }
    }

    public void set(String name, String path, String value) {
        Script.setValueByPath(name, path, value, this);
    }

    public void set(String name, String path, List<Map<String, String>> table) {
        Script.setByPathTable(name, path, table, this);
    }

    public void remove(String name, String path) {
        Script.removeValueByPath(name, path, this);
    }

    public void call(boolean callonce, String line) {
        StringUtils.Pair pair = Script.parseCallArgs(line);
        Script.callAndUpdateConfigAndAlsoVarsIfMapReturned(callonce, pair.left, pair.right, this);
    }

    public ScriptValue eval(String exp) {
        return Script.evalJsExpression(exp, this);
    }

    public List<Embed> getAndClearEmbeds() {
        List<Embed> temp = this.prevEmbeds;
        this.prevEmbeds = null;
        return temp;
    }

    public void embed(byte[] bytes, String contentType) {
        Embed embed = new Embed();
        embed.setBytes(bytes);
        embed.setMimeType(contentType);
        ScenarioContext threadContext = Engine.THREAD_CONTEXT.get();
        if (threadContext != null) {
            threadContext.embed(embed);
        } else {
            this.embed(embed);
        }
    }

    public void embed(Embed embed) {
        if (this.prevEmbeds == null) {
            this.prevEmbeds = new ArrayList<Embed>();
        }
        this.prevEmbeds.add(embed);
    }

    public WebSocketClient webSocket(WebSocketOptions options) {
        WebSocketClient webSocketClient = new WebSocketClient(options, this.logger);
        if (this.webSocketClients == null) {
            this.webSocketClients = new ArrayList<WebSocketClient>();
        }
        this.webSocketClients.add(webSocketClient);
        return webSocketClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal(Object result) {
        this.logger.trace("signal called: {}", result);
        Object object = this.LOCK;
        synchronized (object) {
            this.signalResult = result;
            this.LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object listen(long timeout, Runnable runnable) {
        if (runnable != null) {
            this.logger.trace("submitting listen function", new Object[0]);
            new Thread(runnable).start();
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.signalResult != null) {
                this.logger.debug("signal arrived early ! result: {}", this.signalResult);
                Object temp = this.signalResult;
                this.signalResult = null;
                return temp;
            }
            try {
                this.logger.trace("entered listen wait state", new Object[0]);
                this.LOCK.wait(timeout);
                this.logger.trace("exit listen wait state, result: {}", this.signalResult);
            }
            catch (InterruptedException e) {
                this.logger.error("listen timed out: {}", e.getMessage());
            }
            Object temp = this.signalResult;
            this.signalResult = null;
            return temp;
        }
    }

    private void autoDef(Plugin plugin, String instanceName) {
        for (String methodName : plugin.methodNames()) {
            String invoke = instanceName + "." + methodName;
            String js = "function(){ if (arguments.length == 0) return " + invoke + "(); if (arguments.length == 1) return " + invoke + "(arguments[0]); if (arguments.length == 2) return " + invoke + "(arguments[0], arguments[1]); return " + invoke + "(arguments[0], arguments[1], arguments[2]) }";
            ScriptValue sv = ScriptBindings.eval(js, this.bindings);
            this.bindings.putAdditionalVariable(methodName, sv.getValue());
        }
    }

    private void setDriver(Driver driver) {
        this.driver = driver;
        driver.setContext(this);
        this.bindings.putAdditionalVariable("driver", driver);
        if (this.robot != null) {
            this.logger.warn("'robot' is active, use 'driver.' prefix for driver methods", new Object[0]);
            return;
        }
        this.autoDef(driver, "driver");
        this.bindings.putAdditionalVariable("Key", Key.INSTANCE);
    }

    public void driver(String expression) {
        ScriptValue sv = Script.evalKarateExpression(expression, this);
        if (this.driver == null) {
            Map<String, Object> options = this.config.getDriverOptions();
            if (options == null) {
                options = new HashMap<String, Object>();
            }
            options.put("target", this.config.getDriverTarget());
            if (sv.isMapLike()) {
                options.putAll(sv.getAsMap());
            }
            this.setDriver(DriverOptions.start(this, options, this.appender));
        }
        if (sv.isString()) {
            this.driver.setUrl(sv.getAsString());
        }
    }

    private void setRobot(Plugin robot) {
        this.robot = robot;
        robot.setContext(this);
        this.bindings.putAdditionalVariable("robot", robot);
        if (this.driver != null) {
            this.logger.warn("'driver' is active, use 'robot.' prefix for robot methods", new Object[0]);
            return;
        }
        this.autoDef(robot, "robot");
        this.bindings.putAdditionalVariable("Key", Key.INSTANCE);
    }

    public void robot(String expression) {
        ScriptValue sv = Script.evalKarateExpression(expression, this);
        if (this.robot == null) {
            Map<String, Object> options = this.config.getRobotOptions();
            if (options == null) {
                options = new HashMap<String, Object>();
            }
            if (sv.isMapLike()) {
                options.putAll(sv.getAsMap());
            } else if (sv.isString()) {
                options.put("window", sv.getAsString());
            }
            try {
                Class<?> clazz = Class.forName("com.intuit.karate.robot.RobotFactory");
                PluginFactory factory = (PluginFactory)clazz.newInstance();
                this.robot = factory.create(this, options);
            }
            catch (KarateException ke) {
                throw ke;
            }
            catch (Exception e) {
                String message = "cannot instantiate robot, is 'karate-robot' included as a maven / gradle dependency ? " + e.getMessage();
                this.logger.error(message, new Object[0]);
                throw new RuntimeException(message, e);
            }
            this.setRobot(this.robot);
        }
    }

    public void stop(StepResult lastStepResult) {
        if (this.reuseParentContext) {
            if (this.driver != null) {
                this.parentContext.setDriver(this.driver);
            }
            if (this.robot != null) {
                this.parentContext.setRobot(this.robot);
            }
            this.parentContext.webSocketClients = this.webSocketClients;
            return;
        }
        if (this.callDepth == 0) {
            if (this.webSocketClients != null) {
                this.webSocketClients.forEach(WebSocketClient::close);
            }
            if (this.driver != null) {
                this.driver.quit();
                DriverOptions options = this.driver.getOptions();
                if (options.target != null) {
                    this.logger.debug("custom target configured, attempting stop()", new Object[0]);
                    Map<String, Object> map = options.target.stop(this.logger);
                    String video = (String)map.get("video");
                    if (video != null && lastStepResult != null) {
                        Embed embed = Embed.forVideoFile(video);
                        lastStepResult.addEmbed(embed);
                    }
                } else {
                    File src;
                    if (options.afterStop != null) {
                        Command.execLine(null, options.afterStop);
                    }
                    if (options.videoFile != null && (src = new File(options.videoFile)).exists()) {
                        String path = FileUtils.getBuildDir() + File.separator + System.currentTimeMillis() + ".mp4";
                        File dest = new File(path);
                        FileUtils.copy(src, dest);
                        Embed embed = Embed.forVideoFile("../" + dest.getName());
                        lastStepResult.addEmbed(embed);
                        this.logger.debug("appended video to report: {}", dest.getPath());
                    }
                }
            }
            if (this.robot != null) {
                this.robot.afterScenario();
            }
        }
    }
}

