/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MethodPattern {
    public final String regex;
    public final Method method;
    private final Pattern pattern;

    MethodPattern(Method method, String regex) {
        this.regex = regex;
        this.method = method;
        try {
            this.pattern = Pattern.compile(regex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> match(String text) {
        Matcher matcher = this.pattern.matcher(text);
        if (matcher.lookingAt()) {
            ArrayList<String> args = new ArrayList<String>(matcher.groupCount());
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                int startIndex = matcher.start(i);
                args.add(startIndex == -1 ? null : matcher.group(i));
            }
            return args;
        }
        return null;
    }

    public String toString() {
        return "\n" + this.pattern + " " + this.method.toGenericString();
    }
}

