/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.FileUtils;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.HtmlReport;
import com.intuit.karate.core.HtmlTagsReport;
import java.io.File;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HtmlSummaryReport
extends HtmlReport {
    private final Element tbody;
    private final HtmlTagsReport tagsReport = new HtmlTagsReport();
    private int passCount;
    private int failCount;

    public HtmlSummaryReport() {
        this.set("/html/head/title", "Karate Summary Report");
        this.setById("nav-type", "Features");
        this.contentContainer.appendChild(this.div("page-heading alert alert-primary", this.tagsLink()));
        Element table = this.node("table", "features-table table table-sm");
        this.contentContainer.appendChild(table);
        Element thead = this.node("thead", null);
        table.appendChild(thead);
        Element tr = this.node("tr", null);
        thead.appendChild(tr);
        tr.appendChild(this.th("Feature", null));
        tr.appendChild(this.th("Title", null));
        tr.appendChild(this.th("Passed", "num"));
        tr.appendChild(this.th("Failed", "num"));
        tr.appendChild(this.th("Scenarios", "num"));
        tr.appendChild(this.th("Time (ms)", "num"));
        this.tbody = this.node("tbody", null);
        table.appendChild(this.tbody);
    }

    public void addFeatureResult(FeatureResult result) {
        String rowClass = result.isFailed() ? "failed-lt" : "passed-lt";
        Element tr = this.node("tr", rowClass);
        this.tbody.appendChild(tr);
        String featureUri = result.getDisplayUri();
        String featurePath = HtmlSummaryReport.getHtmlFileName(result);
        Element tdFeature = this.node("td", null);
        tr.appendChild(tdFeature);
        Element featureLink = this.node("a", null);
        tdFeature.appendChild(featureLink);
        featureLink.setTextContent(featureUri);
        featureLink.setAttribute("href", featurePath);
        tr.appendChild(this.td(result.getFeature().getNameAndDescription(), null));
        tr.appendChild(this.td(result.getPassedCount() + "", "num"));
        tr.appendChild(this.td(result.getFailedCount() + "", "num"));
        tr.appendChild(this.td(result.getScenarioCount() + "", "num"));
        String duration = this.formatter.format(result.getDurationMillis());
        tr.appendChild(this.td(duration, "num"));
        if (result.isFailed()) {
            ++this.failCount;
            Element featureNav = this.div("nav-item failed", new Node[0]);
            Element failedLink = this.node("a", null);
            featureNav.appendChild(failedLink);
            failedLink.setTextContent(result.getFeature().getNameForReport());
            failedLink.setAttribute("href", featurePath);
            this.navContainer.appendChild(featureNav);
        } else {
            ++this.passCount;
        }
        this.tagsReport.addFeatureResult(result);
    }

    public File save(String targetDir) {
        this.tagsReport.save(targetDir);
        this.setById("nav-pass", this.passCount + "");
        this.setById("nav-fail", this.failCount + "");
        File file = this.saveHtmlToFile(targetDir, "karate-summary.html");
        System.out.println("\nHTML report: (paste into browser to view) | Karate version: " + FileUtils.getKarateVersion() + "\n" + file.toURI() + "\n===================================================================\n");
        return file;
    }
}

