/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Results;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.HtmlFeatureReport;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioResult;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class HtmlReport {
    protected final Document doc;
    protected final Node navContainer;
    protected final Node contentContainer;
    protected final DecimalFormat formatter;
    protected final String dateString;
    private static final String[] RESOURCES = new String[]{"bootstrap.min.css", "bootstrap.min.js", "jquery.min.js", "jquery.tablesorter.min.js", "karate-logo.png", "karate-logo.svg", "karate-report.css", "karate-report.js"};

    public HtmlReport() {
        String html = HtmlReport.getResourceAsString("report-template.html");
        this.doc = XmlUtils.toXmlDoc(html);
        this.formatter = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        this.formatter.applyPattern("0");
        Node leftNav = XmlUtils.getNodeByPath(this.doc, "/html/body/div/div[1]", false);
        this.navContainer = this.div("nav-container", new Node[0]);
        leftNav.appendChild(this.navContainer);
        this.contentContainer = XmlUtils.getNodeByPath(this.doc, "/html/body/div/div[2]", false);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a");
        this.dateString = sdf.format(new Date());
        this.setById("nav-date", this.dateString);
    }

    protected static void copyFile(ClassLoader cl, String srcPath, String destPath) {
        byte[] bytes = FileUtils.toBytes(cl.getResourceAsStream(srcPath));
        File dest = new File(destPath);
        FileUtils.writeToFile(dest, bytes);
    }

    protected void initStaticResources(String targetDir) {
        String resPath = targetDir + File.separator + "res" + File.separator;
        File res = new File(resPath);
        if (res.exists()) {
            return;
        }
        ClassLoader cl = this.getClass().getClassLoader();
        for (String name : RESOURCES) {
            HtmlReport.copyFile(cl, "res/" + name, resPath + name);
        }
        HtmlReport.copyFile(cl, "favicon.ico", targetDir + File.separator + "favicon.ico");
    }

    protected static String getResourceAsString(String name) {
        return FileUtils.toString(HtmlFeatureReport.class.getClassLoader().getResourceAsStream(name));
    }

    protected void set(String path, String value) {
        XmlUtils.setByPath((Node)this.doc, path, value);
    }

    protected void setById(String id, String value) {
        String path = "//div[@id='" + id + "']";
        Node node = XmlUtils.getNodeByPath(this.doc, path, false);
        if (node != null) {
            node.setTextContent(value);
        }
    }

    protected Element div(String clazz, String value) {
        return this.node("div", clazz, value);
    }

    protected Element div(String clazz, Node ... childNodes) {
        Element parent = this.node("div", clazz);
        for (Node child : childNodes) {
            parent.appendChild(child);
        }
        return parent;
    }

    protected Element node(String name, String clazz, String text) {
        return XmlUtils.createElement(this.doc, name, text, clazz == null ? null : Collections.singletonMap("class", clazz));
    }

    protected Element node(String name, String clazz) {
        return this.node(name, clazz, null);
    }

    protected Element th(String content, String clazz) {
        Element th = this.node("th", clazz);
        th.setTextContent(content);
        return th;
    }

    protected Element td(String content, String clazz) {
        Element td = this.node("td", clazz);
        td.setTextContent(content);
        return td;
    }

    protected Element summaryLink() {
        Element link = this.node("a", null);
        link.setAttribute("href", "karate-summary.html");
        link.setTextContent("Summary");
        return link;
    }

    protected Element tagsLink() {
        Element link = this.node("a", null);
        link.setAttribute("href", "karate-tags.html");
        link.setTextContent("Tags");
        return link;
    }

    protected static String getHtmlFileName(FeatureResult result) {
        return result.getPackageQualifiedName() + ".html";
    }

    protected File saveHtmlToFile(String targetDir, String fileName) {
        File file = new File(targetDir + File.separator + fileName);
        try {
            String xml = "<!DOCTYPE html>\n" + XmlUtils.toString(this.doc, false);
            this.initStaticResources(targetDir);
            FileUtils.writeToFile(file, xml);
        }
        catch (Exception e) {
            System.out.println("html report output failed: " + e.getMessage());
        }
        return file;
    }

    public static File saveTimeline(String targetDir, Results results, String fileName) {
        LinkedHashMap<String, Integer> groupsMap = new LinkedHashMap<String, Integer>();
        List<ScenarioResult> scenarioResults = results.getScenarioResults();
        ArrayList items = new ArrayList(scenarioResults.size());
        int id = 1;
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        for (ScenarioResult sr : scenarioResults) {
            String threadName = sr.getThreadName();
            Integer groupId = (Integer)groupsMap.get(threadName);
            if (groupId == null) {
                groupId = groupsMap.size() + 1;
                groupsMap.put(threadName, groupId);
            }
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(7);
            items.add(item);
            item.put("id", id++);
            item.put("group", groupId);
            Scenario s = sr.getScenario();
            String featureName = s.getFeature().getResource().getFileNameWithoutExtension();
            String content = featureName + s.getDisplayMeta();
            item.put("content", content);
            item.put("start", sr.getStartTime());
            item.put("end", sr.getEndTime());
            String startTime = dateFormat.format(new Date(sr.getStartTime()));
            String endTime = dateFormat.format(new Date(sr.getEndTime()));
            content = content + " " + startTime + "-" + endTime;
            String scenarioTitle = StringUtils.trimToEmpty(s.getName());
            if (!scenarioTitle.isEmpty()) {
                content = content + " " + scenarioTitle;
            }
            item.put("title", content);
        }
        ArrayList groups = new ArrayList(groupsMap.size());
        groupsMap.forEach((k, v) -> {
            LinkedHashMap<String, Object> group = new LinkedHashMap<String, Object>(2);
            groups.add(group);
            group.put("id", v);
            group.put("content", k);
        });
        StringBuilder sb = new StringBuilder();
        sb.append("\nvar groups = new vis.DataSet(").append(JsonUtils.toJson(groups)).append(");").append('\n');
        sb.append("var items = new vis.DataSet(").append(JsonUtils.toJson(items)).append(");").append('\n');
        sb.append("var container = document.getElementById('visualization');\nvar timeline = new vis.Timeline(container);\ntimeline.setOptions({ groupOrder: 'content' });\ntimeline.setGroups(groups);\ntimeline.setItems(items);\n");
        if (fileName == null) {
            fileName = File.separator + "timeline.html";
        }
        File htmlFile = new File(targetDir + fileName);
        String html = HtmlReport.getResourceAsString("timeline-template.html");
        html = html.replace("//timeline//", sb.toString());
        FileUtils.writeToFile(htmlFile, html);
        return htmlFile;
    }
}

