/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Match;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptValueMap;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureBackend;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FeaturesBackend {
    private final List<FeatureBackend> featureBackends;
    private static final String ALLOWED_METHODS = "GET, HEAD, POST, PUT, DELETE, PATCH";

    public FeaturesBackend(Feature feature) {
        this(new Feature[]{feature});
    }

    public FeaturesBackend(Feature[] features) {
        this(features, null);
    }

    public FeaturesBackend(Feature[] features, Map<String, Object> arg) {
        this.featureBackends = Arrays.stream(features).map(feature -> new FeatureBackend((Feature)feature, arg)).collect(Collectors.toList());
        this.getContext().logger.info("all backends initialized", new Object[0]);
    }

    public boolean isCorsEnabled() {
        return this.featureBackends.stream().anyMatch(fb -> fb.getContext().getConfig().isCorsEnabled());
    }

    public ScenarioContext getContext() {
        return this.featureBackends.get(0).getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse buildResponse(HttpRequest request, long startTime) {
        if ("OPTIONS".equals(request.getMethod()) && this.isCorsEnabled()) {
            return this.corsCheck(request, startTime);
        }
        FeaturesBackend featuresBackend = this;
        synchronized (featuresBackend) {
            FeatureBackend.FeatureScenarioMatch matchingInfo;
            Match match = new Match().text("requestUrlBase", request.getUrlBase()).text("requestUri", request.getUri()).text("requestMethod", request.getMethod()).def("requestHeaders", request.getHeaders()).def("responseStatus", 200).def("requestParams", request.getParams());
            byte[] requestBytes = request.getBody();
            if (requestBytes != null) {
                match.def("requestBytes", requestBytes);
                String requestString = FileUtils.toString(requestBytes);
                Object requestBody = requestString;
                if (Script.isJson(requestString)) {
                    try {
                        requestBody = JsonUtils.toJsonDoc(requestString);
                    }
                    catch (Exception e) {
                        this.getContext().logger.warn("json parsing failed, request data type set to string: {}", e.getMessage());
                    }
                } else if (Script.isXml(requestString)) {
                    try {
                        requestBody = XmlUtils.toXmlDoc(requestString);
                    }
                    catch (Exception e) {
                        this.getContext().logger.warn("xml parsing failed, request data type set to string: {}", e.getMessage());
                    }
                }
                match.def("request", requestBody);
            }
            if ((matchingInfo = this.getMatchingScenario(match.vars())) == null) {
                this.getContext().logger.warn("no matching scenarios in backend feature files", new Object[0]);
                HttpResponse response = new HttpResponse(startTime, System.currentTimeMillis());
                response.addHeader("Content-Type", "text/plain");
                String requestId = request.getRequestId();
                if (requestId != null) {
                    response.addHeader("X-Karate-Request-Id", requestId);
                }
                response.setStatus(404);
                response.setBody("no matching scenarios in backend feature files".getBytes(Charset.forName("UTF-8")));
                return response;
            }
            FeatureBackend matchingFeature = matchingInfo.getFeatureBackend();
            Scenario matchingScenario = matchingInfo.getScenario();
            return matchingFeature.buildResponse(request, startTime, matchingScenario, match.vars());
        }
    }

    public HttpResponse corsCheck(HttpRequest request, long startTime) {
        HttpResponse response = new HttpResponse(startTime, System.currentTimeMillis());
        response.setStatus(200);
        response.addHeader("Allow", ALLOWED_METHODS);
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Allow-Methods", ALLOWED_METHODS);
        List requestHeaders = (List)request.getHeaders().get("Access-Control-Request-Headers");
        if (requestHeaders != null) {
            response.putHeader("Access-Control-Allow-Headers", requestHeaders);
        }
        return response;
    }

    public ScriptValueMap handle(ScriptValueMap args) {
        FeatureBackend.FeatureScenarioMatch matchingInfo = this.getMatchingScenario(args);
        return matchingInfo.getFeatureBackend().handle(args, matchingInfo.getScenario());
    }

    public FeatureBackend.FeatureScenarioMatch getMatchingScenario(ScriptValueMap args) {
        FeatureBackend.FeatureScenarioMatch matched = null;
        ArrayList<FeatureBackend.FeatureScenarioMatch> matches = new ArrayList<FeatureBackend.FeatureScenarioMatch>();
        ArrayList<FeatureBackend.FeatureScenarioMatch> defaults = new ArrayList<FeatureBackend.FeatureScenarioMatch>();
        for (FeatureBackend featureBackend : this.featureBackends) {
            List<FeatureBackend.FeatureScenarioMatch> featureMatches = featureBackend.getMatchingScenarios(args);
            Scenario defaultMatch = featureBackend.getDefaultScenario(args);
            matches.addAll(featureMatches);
            if (defaultMatch == null) continue;
            defaults.add(new FeatureBackend.FeatureScenarioMatch(featureBackend, defaultMatch));
        }
        if (matches.isEmpty() && defaults.isEmpty()) {
            this.getContext().logger.error("no scenarios matched request", new Object[0]);
            return null;
        }
        matched = matches.stream().max((left, right) -> left.compareScores((FeatureBackend.FeatureScenarioMatch)right)).orElse(null);
        if (matched == null) {
            matched = (FeatureBackend.FeatureScenarioMatch)defaults.stream().findFirst().get();
            this.getContext().logger.debug("scenario defaulted: {}", FeaturesBackend.matchInfo(matched));
        } else {
            this.getContext().logger.debug("scenario matched: {}", FeaturesBackend.matchInfo(matched));
        }
        return matched;
    }

    private static String matchInfo(FeatureBackend.FeatureScenarioMatch matched) {
        Scenario scenario = matched.getScenario();
        String featureInfo = matched.getFeatureBackend().getFeatureName() + " " + scenario.getDisplayMeta();
        String scenarioName = scenario.getName();
        return StringUtils.isBlank(scenarioName) ? featureInfo : featureInfo + " " + scenarioName;
    }
}

