/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.CallContext;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.ScriptValueMap;
import com.intuit.karate.StepActions;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Engine;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.FeatureSection;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.core.Step;
import com.intuit.karate.exception.KarateException;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.HttpUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FeatureBackend {
    private static final String ALLOWED_METHODS = "GET, HEAD, POST, PUT, DELETE, PATCH";
    private final Feature feature;
    private final StepActions actions;
    private final ScenarioContext context;
    private final String featureName;
    private static final String VAR_AFTER_SCENARIO = "afterScenario";

    private static void putBinding(String name, ScenarioContext context) {
        String function = "function(a){ return karate." + name + "(a) }";
        context.vars.put(name, Script.evalJsExpression(function, context));
    }

    private static void putBinding2(String name, ScenarioContext context) {
        String function = "function(a, b){ return karate." + name + "(a, b) }";
        context.vars.put(name, Script.evalJsExpression(function, context));
    }

    public ScenarioContext getContext() {
        return this.context;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public FeatureBackend(Feature feature) {
        this(feature, null);
    }

    public FeatureBackend(Feature feature, Map<String, Object> arg) {
        this.feature = feature;
        this.featureName = feature.getPath().toFile().getName();
        CallContext callContext = new CallContext(null, false, new ExecutionHook[0]);
        FeatureContext featureContext = new FeatureContext(null, feature, null);
        this.actions = new StepActions(featureContext, callContext, null, null);
        this.context = this.actions.context;
        FeatureBackend.putBinding("pathMatches", this.context);
        FeatureBackend.putBinding("methodIs", this.context);
        FeatureBackend.putBinding("paramValue", this.context);
        FeatureBackend.putBinding("paramExists", this.context);
        FeatureBackend.putBinding("typeContains", this.context);
        FeatureBackend.putBinding("acceptContains", this.context);
        FeatureBackend.putBinding2("headerContains", this.context);
        FeatureBackend.putBinding("bodyPath", this.context);
        if (arg != null) {
            arg.forEach((k, v) -> this.context.vars.put((String)k, v));
        }
        if (feature.isBackgroundPresent()) {
            for (Step step : feature.getBackground().getSteps()) {
                Result result = Engine.executeStep(step, this.actions);
                if (!result.isFailed()) continue;
                String message = "server-side background init failed - " + this.featureName + ":" + step.getLine();
                this.context.logger.error(message, new Object[0]);
                throw new KarateException(message, result.getError());
            }
        }
        this.context.logger.info("backend {} initialized", this.featureName);
    }

    public ScriptValueMap handle(ScriptValueMap args, Scenario scenario) {
        this.context.vars.putAll(args);
        this.isMatchingScenario(scenario);
        for (Step step : scenario.getSteps()) {
            Result result = Engine.executeStep(step, this.actions);
            if (result.isAborted()) {
                this.context.logger.debug("abort at {}:{}", this.featureName, step.getLine());
                break;
            }
            if (!result.isFailed()) continue;
            String message = "server-side scenario failed - " + this.featureName + ":" + step.getLine();
            this.context.logger.error(message, new Object[0]);
            throw new KarateException(message, result.getError());
        }
        return this.context.vars;
    }

    public List<FeatureScenarioMatch> getMatchingScenarios(ScriptValueMap args) {
        this.context.vars.putAll(args);
        ArrayList<FeatureScenarioMatch> matchingScenarios = new ArrayList<FeatureScenarioMatch>();
        for (FeatureSection fs : this.feature.getSections()) {
            if (fs.isOutline()) {
                this.context.logger.warn("skipping scenario outline - {}:{}", this.featureName, fs.getScenarioOutline().getLine());
                break;
            }
            Scenario scenario = fs.getScenario();
            if (!this.isMatchingScenario(scenario)) continue;
            ArrayList<Integer> scores = new ArrayList<Integer>();
            ScriptValue pathMatchScoresValue = this.context.vars.getOrDefault("pathMatchScores", ScriptValue.NULL);
            boolean methodMatch = this.context.vars.getOrDefault("methodMatch", ScriptValue.FALSE).getValue(Boolean.class);
            int headersMatchScore = this.context.vars.getOrDefault("headersMatchScore", ScriptValue.ZERO).getAsInt();
            int queryMatchScore = this.context.vars.getOrDefault("queryMatchScore", ScriptValue.ZERO).getAsInt();
            scores.addAll(pathMatchScoresValue.isNull() ? Arrays.asList(0, 0, 0) : pathMatchScoresValue.getAsList());
            scores.add(methodMatch ? 1 : 0);
            scores.add(queryMatchScore);
            scores.add(headersMatchScore);
            matchingScenarios.add(new FeatureScenarioMatch(this, scenario, scores));
        }
        return matchingScenarios;
    }

    private boolean isMatchingScenario(Scenario scenario) {
        if (this.isDefaultScenario(scenario)) {
            return false;
        }
        String expression = StringUtils.trimToNull(scenario.getName() + scenario.getDescription());
        try {
            ScriptValue sv = Script.evalJsExpression(expression, this.context);
            if (sv.isBooleanTrue()) {
                this.context.logger.debug("scenario matched: {}", expression);
                return true;
            }
            this.context.logger.debug("scenario skipped: {}", expression);
            return false;
        }
        catch (Exception e) {
            this.context.logger.warn("scenario match evaluation failed: {}", e.getMessage());
            return false;
        }
    }

    public Scenario getDefaultScenario(ScriptValueMap args) {
        for (FeatureSection fs : this.feature.getSections()) {
            Scenario scenario = fs.getScenario();
            if (!this.isDefaultScenario(scenario)) continue;
            return scenario;
        }
        return null;
    }

    private boolean isDefaultScenario(Scenario scenario) {
        return StringUtils.trimToNull(scenario.getName() + scenario.getDescription()) == null;
    }

    public HttpResponse corsCheck(HttpRequest request, long startTime) {
        if (this.context.getConfig().isCorsEnabled()) {
            HttpResponse response = new HttpResponse(startTime, System.currentTimeMillis());
            response.setStatus(200);
            response.addHeader("Allow", ALLOWED_METHODS);
            response.addHeader("Access-Control-Allow-Origin", "*");
            response.addHeader("Access-Control-Allow-Methods", ALLOWED_METHODS);
            List requestHeaders = (List)request.getHeaders().get("Access-Control-Request-Headers");
            if (requestHeaders != null) {
                response.putHeader("Access-Control-Allow-Headers", requestHeaders);
            }
            return response;
        }
        return null;
    }

    public HttpResponse buildResponse(HttpRequest request, long startTime, Scenario scenario, ScriptValueMap args) {
        String string;
        ScriptValueMap result = this.handle(args, scenario);
        ScriptValue configResponseHeaders = this.context.getConfig().getResponseHeaders();
        ScriptValue responseValue = (ScriptValue)result.remove("response");
        ScriptValue responseStatusValue = (ScriptValue)result.remove("responseStatus");
        long configResponseDelayValue = this.context.getConfig().getResponseDelay();
        ScriptValue responseDelayValue = (ScriptValue)result.remove("responseDelay");
        ScriptValue responseHeaders = (ScriptValue)result.remove("responseHeaders");
        ScriptValue afterScenario = (ScriptValue)result.remove(VAR_AFTER_SCENARIO);
        if (afterScenario == null) {
            afterScenario = this.context.getConfig().getAfterScenario();
        }
        Map<String, Object> configResponseHeadersMap = configResponseHeaders == null ? null : configResponseHeaders.evalAsMap(this.context);
        Map<String, Object> responseHeadersMap = responseHeaders == null ? null : responseHeaders.evalAsMap(this.context);
        int responseStatus = responseStatusValue == null ? 200 : Integer.valueOf(responseStatusValue.getAsString());
        long delay = responseDelayValue == null || responseDelayValue.isNull() ? configResponseDelayValue : Double.valueOf(responseDelayValue.getAsString()).longValue();
        HttpResponse response = new HttpResponse(startTime, System.currentTimeMillis());
        response.setStatus(responseStatus);
        response.setDelay(delay);
        if (responseValue != null && !responseValue.isNull()) {
            response.setBody(responseValue.getAsByteArray());
        }
        if (responseHeadersMap != null) {
            if (configResponseHeadersMap != null) {
                for (Map.Entry<String, Object> entry : configResponseHeadersMap.entrySet()) {
                    responseHeadersMap.putIfAbsent(entry.getKey(), entry.getValue());
                }
            }
        } else if (configResponseHeadersMap != null) {
            responseHeadersMap = configResponseHeadersMap;
        }
        boolean contentTypeHeaderExists = false;
        if (responseHeadersMap != null) {
            for (Map.Entry<String, Object> entry : responseHeadersMap.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                if ("Content-Type".equalsIgnoreCase(k)) {
                    contentTypeHeaderExists = true;
                }
                if (v instanceof List) {
                    response.putHeader(k, (List)v);
                    continue;
                }
                if (v == null) continue;
                response.addHeader(k, v.toString());
            }
        }
        if ((string = request.getRequestId()) != null) {
            response.addHeader("X-Karate-Request-Id", string);
        }
        if (!contentTypeHeaderExists && responseValue != null) {
            response.addHeader("Content-Type", HttpUtils.getContentType(responseValue));
        }
        if (this.context.getConfig().isCorsEnabled()) {
            response.addHeader("Access-Control-Allow-Origin", "*");
        }
        if (afterScenario != null && afterScenario.isFunction()) {
            afterScenario.invokeFunction(this.context, null);
        }
        return response;
    }

    public static class FeatureScenarioMatch {
        private final FeatureBackend featureBackend;
        private final Scenario scenario;
        private final List<Integer> scores;
        private static final List<Integer> DEFAULT_SCORES = Collections.unmodifiableList(Arrays.asList(0, 0, 0, 0, 0, 0));

        public FeatureScenarioMatch(FeatureBackend featureBackend, Scenario scenario) {
            this.scenario = scenario;
            this.scores = DEFAULT_SCORES;
            this.featureBackend = featureBackend;
        }

        public FeatureScenarioMatch(FeatureBackend featureBackend, Scenario scenario, List<Integer> scores) {
            this.scenario = scenario;
            this.scores = Collections.unmodifiableList(scores);
            this.featureBackend = featureBackend;
        }

        public FeatureBackend getFeatureBackend() {
            return this.featureBackend;
        }

        public Scenario getScenario() {
            return this.scenario;
        }

        public List<Integer> getScores() {
            return this.scores;
        }

        public int compareScores(FeatureScenarioMatch other) {
            for (int i = 0; i < this.scores.size(); ++i) {
                Integer otherScore;
                Integer score = this.scores.get(i);
                int compareTo = score.compareTo(otherScore = other.getScores().get(i));
                if (compareTo == 0) continue;
                return compareTo;
            }
            return 0;
        }
    }
}

