/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.Actions;
import com.intuit.karate.CallContext;
import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Results;
import com.intuit.karate.StepActions;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.Action;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.FeatureExecutionUnit;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.MethodMatch;
import com.intuit.karate.core.MethodPattern;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.exception.KarateAbortException;
import com.intuit.karate.exception.KarateException;
import cucumber.api.java.en.When;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Engine {
    private static final Collection<MethodPattern> PATTERNS;
    private static final double MILLION = 1000000.0;
    private static final double BILLION = 1.0E9;
    private static final String UNKNOWN = "-unknown-";
    public static final ThreadLocal<ScenarioContext> THREAD_CONTEXT;

    private Engine() {
    }

    public static double nanosToSeconds(long nanos) {
        return (double)nanos / 1.0E9;
    }

    public static double nanosToMillis(long nanos) {
        return (double)nanos / 1000000.0;
    }

    public static FeatureResult executeFeatureSync(String env, Feature feature, String tagSelector, CallContext callContext) {
        FeatureContext featureContext = new FeatureContext(env, feature, tagSelector);
        if (callContext == null) {
            callContext = new CallContext(null, true, new ExecutionHook[0]);
        }
        ExecutionContext exec = new ExecutionContext(null, System.currentTimeMillis(), featureContext, callContext, null, null, null);
        FeatureExecutionUnit unit = new FeatureExecutionUnit(exec);
        unit.run();
        return exec.result;
    }

    public static String getFeatureName(Step step) {
        if (step.getScenario() == null) {
            return UNKNOWN;
        }
        return step.getScenario().getFeature().getPath().getFileName().toString();
    }

    public static Result executeStep(Step step, Actions actions) {
        Object[] args;
        String text = step.getText();
        List<MethodMatch> matches = Engine.findMethodsMatching(text);
        if (matches.isEmpty()) {
            KarateException e = new KarateException("no step-definition method match found for: " + text);
            return Result.failed(0L, e, step);
        }
        if (matches.size() > 1) {
            KarateException e = new KarateException("more than one step-definition method matched: " + text + " - " + matches);
            return Result.failed(0L, e, step);
        }
        MethodMatch match = matches.get(0);
        Object last = step.getDocString() != null ? step.getDocString() : (step.getTable() != null ? step.getTable().getRowsAsMaps() : null);
        try {
            args = match.convertArgs(last);
        }
        catch (Exception ee) {
            KarateException e = new KarateException("no step-definition method match found for: " + text);
            return Result.failed(0L, e, step);
        }
        long startTime = System.nanoTime();
        try {
            match.method.invoke((Object)actions, args);
            return Result.passed(Engine.getElapsedTime(startTime));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof KarateAbortException) {
                return Result.aborted(Engine.getElapsedTime(startTime));
            }
            return Result.failed(Engine.getElapsedTime(startTime), e.getTargetException(), step);
        }
        catch (Exception e) {
            return Result.failed(Engine.getElapsedTime(startTime), e, step);
        }
    }

    public static File saveResultJson(String targetDir, FeatureResult result, String fileName) {
        List<Map<String, Object>> single = Collections.singletonList(result.toMap());
        String json = JsonUtils.toJson(single);
        if (fileName == null) {
            fileName = result.getPackageQualifiedName() + ".json";
        }
        File file = new File(targetDir + File.separator + fileName);
        FileUtils.writeToFile(file, json);
        return file;
    }

    public static String formatNanos(long nanos, DecimalFormat formatter) {
        return formatter.format(Engine.nanosToSeconds(nanos));
    }

    public static String formatMillis(double millis, DecimalFormat formatter) {
        return formatter.format(millis / 1000.0);
    }

    private static Throwable appendSteps(List<StepResult> steps, StringBuilder sb) {
        Throwable error = null;
        for (StepResult sr : steps) {
            int length = sb.length();
            sb.append(sr.getStep().getPrefix());
            sb.append(' ');
            sb.append(sr.getStep().getText());
            sb.append(' ');
            do {
                sb.append('.');
            } while (sb.length() - length < 75);
            sb.append(' ');
            sb.append(sr.getResult().getStatus());
            sb.append('\n');
            if (!sr.getResult().isFailed()) continue;
            sb.append("\nStack Trace:\n");
            StringWriter sw = new StringWriter();
            error = sr.getResult().getError();
            error.printStackTrace(new PrintWriter(sw));
            sb.append(sw.toString());
            sb.append('\n');
        }
        return error;
    }

    public static File saveResultXml(String targetDir, FeatureResult result, String fileName) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        formatter.applyPattern("0.######");
        Document doc = XmlUtils.newDocument();
        Element root = doc.createElement("testsuite");
        doc.appendChild(root);
        root.setAttribute("name", result.getDisplayUri());
        root.setAttribute("skipped", "0");
        String baseName = result.getPackageQualifiedName();
        int testCount = 0;
        int failureCount = 0;
        long totalDuration = 0L;
        Iterator<ScenarioResult> iterator = result.getScenarioResults().iterator();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            Element stepsHolder;
            ScenarioResult sr = iterator.next();
            totalDuration += sr.getDurationNanos();
            if (sr.isFailed()) {
                ++failureCount;
            }
            Element testCase = doc.createElement("testcase");
            root.appendChild(testCase);
            testCase.setAttribute("classname", baseName);
            ++testCount;
            long duration = sr.getDurationNanos();
            Throwable error = Engine.appendSteps(sr.getStepResults(), sb);
            String name = sr.getScenario().getName();
            if (StringUtils.isBlank(name)) {
                name = testCount + "";
            }
            testCase.setAttribute("name", name);
            testCase.setAttribute("time", Engine.formatNanos(duration, formatter));
            if (error != null) {
                stepsHolder = doc.createElement("failure");
                stepsHolder.setAttribute("message", error.getMessage());
            } else {
                stepsHolder = doc.createElement("system-out");
            }
            testCase.appendChild(stepsHolder);
            stepsHolder.setTextContent(sb.toString());
        }
        root.setAttribute("tests", testCount + "");
        root.setAttribute("failures", failureCount + "");
        root.setAttribute("time", Engine.formatNanos(totalDuration, formatter));
        String xml = XmlUtils.toString(doc, true);
        if (fileName == null) {
            fileName = baseName + ".xml";
        }
        File file = new File(targetDir + File.separator + fileName);
        FileUtils.writeToFile(file, xml);
        return file;
    }

    private static long getElapsedTime(long startTime) {
        return System.nanoTime() - startTime;
    }

    public static File saveStatsJson(String targetDir, Results results) {
        String json = JsonUtils.toJson(results.toMap());
        String fileName = "results-json.txt";
        File file = new File(targetDir + File.separator + fileName);
        FileUtils.writeToFile(file, json);
        return file;
    }

    private static List<MethodMatch> findMethodsMatching(String text) {
        ArrayList<MethodMatch> matches = new ArrayList<MethodMatch>(1);
        for (MethodPattern pattern : PATTERNS) {
            List<String> args = pattern.match(text);
            if (args == null) continue;
            matches.add(new MethodMatch(pattern.method, args));
        }
        return matches;
    }

    static {
        HashMap<String, MethodPattern> temp = new HashMap<String, MethodPattern>();
        ArrayList<MethodPattern> overwrite = new ArrayList<MethodPattern>();
        for (Method method : StepActions.class.getMethods()) {
            When when = method.getDeclaredAnnotation(When.class);
            if (when != null) {
                String regex = when.value();
                temp.put(regex, new MethodPattern(method, regex));
                continue;
            }
            Action action = method.getDeclaredAnnotation(Action.class);
            if (action == null) continue;
            String regex = action.value();
            overwrite.add(new MethodPattern(method, regex));
        }
        for (MethodPattern mp : overwrite) {
            temp.put(mp.regex, mp);
        }
        PATTERNS = temp.values();
        THREAD_CONTEXT = new ThreadLocal();
    }
}

